/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast;

import antlr.ANTLRException;
import antlr.RecognitionException;
import antlr.TokenStreamException;
import antlr.collections.AST;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.QueryException;
import org.hibernate.ScrollableResults;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.event.EventSource;
import org.hibernate.hql.FilterTranslator;
import org.hibernate.hql.ParameterTranslations;
import org.hibernate.hql.antlr.HqlTokenTypes;
import org.hibernate.hql.antlr.SqlTokenTypes;
import org.hibernate.hql.ast.HqlParser;
import org.hibernate.hql.ast.HqlSqlWalker;
import org.hibernate.hql.ast.ParameterTranslationsImpl;
import org.hibernate.hql.ast.QuerySyntaxException;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.exec.BasicExecutor;
import org.hibernate.hql.ast.exec.MultiTableDeleteExecutor;
import org.hibernate.hql.ast.exec.MultiTableUpdateExecutor;
import org.hibernate.hql.ast.exec.StatementExecutor;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.InsertStatement;
import org.hibernate.hql.ast.tree.QueryNode;
import org.hibernate.hql.ast.tree.Statement;
import org.hibernate.hql.ast.util.ASTPrinter;
import org.hibernate.loader.hql.QueryLoader;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public class QueryTranslatorImpl
implements FilterTranslator {
    private static final Log log = LogFactory.getLog((Class)QueryTranslatorImpl.class);
    private static final Log AST_LOG = LogFactory.getLog((String)"org.hibernate.hql.ast.AST");
    private SessionFactoryImplementor factory;
    private String hql;
    private boolean shallowQuery;
    private Map tokenReplacements;
    private Map enabledFilters;
    private boolean compiled;
    private QueryLoader queryLoader;
    private StatementExecutor statementExecutor;
    private Statement sqlAst;
    private String sql;
    private ParameterTranslations paramTranslations;

    public QueryTranslatorImpl(String query, Map enabledFilters, SessionFactoryImplementor factory) {
        this.hql = query;
        this.compiled = false;
        this.shallowQuery = false;
        this.enabledFilters = enabledFilters;
        this.factory = factory;
    }

    public void compile(Map replacements, boolean shallow) throws QueryException, MappingException {
        this.doCompile(replacements, shallow, null);
    }

    public void compile(String collectionRole, Map replacements, boolean shallow) throws QueryException, MappingException {
        this.doCompile(replacements, shallow, collectionRole);
    }

    public Statement getSqlAST() {
        return this.sqlAst;
    }

    private synchronized void doCompile(Map replacements, boolean shallow, String collectionRole) {
        if (this.compiled) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"compile() : The query is already compiled, skipping...");
            }
            return;
        }
        this.tokenReplacements = replacements;
        if (this.tokenReplacements == null) {
            this.tokenReplacements = new HashMap();
        }
        this.shallowQuery = shallow;
        try {
            HqlParser parser = this.parse(true);
            HqlSqlWalker w = this.analyze(parser, collectionRole);
            this.sqlAst = (Statement)w.getAST();
            if (this.sqlAst.needsExecutor()) {
                this.statementExecutor = this.buildAppropriateStatementExecutor(w);
            } else {
                this.generate((AST)((QueryNode)this.sqlAst));
                this.queryLoader = new QueryLoader(this, this.factory, w.getSelectClause());
            }
            this.compiled = true;
        }
        catch (QueryException qe) {
            qe.setQueryString(this.hql);
            throw qe;
        }
        catch (RecognitionException e) {
            throw new QuerySyntaxException(e, this.hql);
        }
        catch (ANTLRException e) {
            QueryException qe = new QueryException(e.getMessage(), e);
            qe.setQueryString(this.hql);
            throw qe;
        }
        this.enabledFilters = null;
    }

    private void generate(AST sqlAst) throws QueryException, RecognitionException {
        if (this.sql == null) {
            SqlGenerator gen = new SqlGenerator(this.factory);
            gen.statement(sqlAst);
            this.sql = gen.getSQL();
            if (log.isDebugEnabled()) {
                log.debug((Object)("HQL: " + this.hql));
                log.debug((Object)("SQL: " + this.sql));
            }
            gen.getParseErrorHandler().throwQueryException();
        }
    }

    private HqlSqlWalker analyze(HqlParser parser, String collectionRole) throws QueryException, RecognitionException {
        HqlSqlWalker w = new HqlSqlWalker(this, this.factory, parser, this.tokenReplacements, collectionRole);
        AST hqlAst = parser.getAST();
        w.statement(hqlAst);
        if (AST_LOG.isDebugEnabled()) {
            ASTPrinter printer = new ASTPrinter(SqlTokenTypes.class);
            AST_LOG.debug((Object)printer.showAsString(w.getAST(), "--- SQL AST ---"));
        }
        w.getParseErrorHandler().throwQueryException();
        return w;
    }

    private HqlParser parse(boolean filter) throws TokenStreamException, RecognitionException {
        HqlParser parser = HqlParser.getInstance(this.hql);
        parser.setFilter(filter);
        if (log.isDebugEnabled()) {
            log.debug((Object)("parse() - HQL: " + this.hql));
        }
        parser.statement();
        AST hqlAst = parser.getAST();
        this.showHqlAst(hqlAst);
        parser.getParseErrorHandler().throwQueryException();
        return parser;
    }

    void showHqlAst(AST hqlAst) {
        if (AST_LOG.isDebugEnabled()) {
            ASTPrinter printer = new ASTPrinter(HqlTokenTypes.class);
            printer.setShowClassNames(false);
            AST_LOG.debug((Object)printer.showAsString(hqlAst, "--- HQL AST ---"));
        }
    }

    private void errorIfDML() throws HibernateException {
        if (this.sqlAst.needsExecutor()) {
            throw new HibernateException("Not supported for DML operations");
        }
    }

    private void errorIfSelect() throws HibernateException {
        if (!this.sqlAst.needsExecutor()) {
            throw new HibernateException("Not supported for select queries");
        }
    }

    private HqlSqlWalker getWalker() {
        return this.sqlAst.getWalker();
    }

    public Type[] getReturnTypes() {
        this.errorIfDML();
        return this.getWalker().getReturnTypes();
    }

    public String[] getReturnAliases() {
        this.errorIfDML();
        return this.getWalker().getReturnAliases();
    }

    public String[][] getColumnNames() {
        this.errorIfDML();
        return this.getWalker().getSelectClause().getColumnNames();
    }

    public Set getQuerySpaces() {
        return this.getWalker().getQuerySpaces();
    }

    public List list(SessionImplementor session, QueryParameters queryParameters) throws HibernateException {
        this.errorIfDML();
        return this.queryLoader.list(session, queryParameters);
    }

    public Iterator iterate(QueryParameters queryParameters, EventSource session) throws HibernateException {
        this.errorIfDML();
        return this.queryLoader.iterate(queryParameters, session);
    }

    public ScrollableResults scroll(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        this.errorIfDML();
        return this.queryLoader.scroll(queryParameters, session);
    }

    public int executeUpdate(QueryParameters queryParameters, SessionImplementor session) throws HibernateException {
        this.errorIfSelect();
        return this.statementExecutor.execute(queryParameters, session);
    }

    public String getSQLString() {
        return this.sql;
    }

    public boolean isShallowQuery() {
        return this.shallowQuery;
    }

    public String getQueryString() {
        return this.hql;
    }

    public Map getEnabledFilters() {
        return this.enabledFilters;
    }

    public int[] getNamedParameterLocs(String name) {
        return this.getWalker().getNamedParameterLocations(name);
    }

    public boolean containsCollectionFetches() {
        this.errorIfDML();
        List collectionFetches = ((QueryNode)this.sqlAst).getFromClause().getCollectionFetches();
        return collectionFetches != null && collectionFetches.size() > 0;
    }

    public void validateScrollability() throws HibernateException {
        this.errorIfDML();
        QueryNode query = (QueryNode)this.sqlAst;
        List collectionFetches = query.getFromClause().getCollectionFetches();
        if (collectionFetches.isEmpty()) {
            return;
        }
        if (this.isShallowQuery()) {
            return;
        }
        if (this.getReturnTypes().length > 1) {
            throw new HibernateException("cannot scroll with collection fetches and returned tuples");
        }
        FromElement owner = null;
        Iterator itr = query.getSelectClause().getFromElementsForLoad().iterator();
        while (itr.hasNext()) {
            FromElement fromElement = (FromElement)itr.next();
            if (fromElement.getOrigin() != null) continue;
            owner = fromElement;
            break;
        }
        if (owner == null) {
            throw new HibernateException("unable to locate collection fetch(es) owner for scrollability checks");
        }
        AST primaryOrdering = query.getOrderByClause().getFirstChild();
        if (primaryOrdering != null) {
            String[] idColNames = owner.getQueryable().getIdentifierColumnNames();
            String expectedPrimaryOrderSeq = StringHelper.join(", ", StringHelper.qualify(owner.getTableAlias(), idColNames));
            if (!primaryOrdering.getText().startsWith(expectedPrimaryOrderSeq)) {
                throw new HibernateException("cannot scroll results with collection fetches which are not ordered primarily by the root entity's PK");
            }
        }
    }

    private StatementExecutor buildAppropriateStatementExecutor(HqlSqlWalker walker) {
        Statement statement = (Statement)walker.getAST();
        if (walker.getStatementType() == 13) {
            FromElement fromElement = walker.getFinalFromClause().getFromElement();
            Queryable persister = fromElement.getQueryable();
            if (persister.isMultiTable()) {
                return new MultiTableDeleteExecutor(walker);
            }
            return new BasicExecutor(walker, persister);
        }
        if (walker.getStatementType() == 51) {
            FromElement fromElement = walker.getFinalFromClause().getFromElement();
            Queryable persister = fromElement.getQueryable();
            if (persister.isMultiTable()) {
                return new MultiTableUpdateExecutor(walker);
            }
            return new BasicExecutor(walker, persister);
        }
        if (walker.getStatementType() == 29) {
            return new BasicExecutor(walker, ((InsertStatement)statement).getIntoClause().getQueryable());
        }
        throw new QueryException("Unexpected statement type");
    }

    public ParameterTranslations getParameterTranslations() {
        if (this.paramTranslations == null) {
            this.paramTranslations = new ParameterTranslationsImpl(this.getWalker().getParameters());
        }
        return this.paramTranslations;
    }
}

