/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.syslogng.forward;

import com.clustercontrol.monitor.message.LogOutputJobRunInfo;
import com.clustercontrol.monitor.message.LogOutputNotifyInfo;
import com.clustercontrol.syslogng.bean.LogFilterInfo;
import com.clustercontrol.syslogng.forward.EJBContoroler;
import com.clustercontrol.syslogng.forward.FileUtil;
import com.clustercontrol.syslogng.forward.LogFilterRepositoryInfo;
import com.clustercontrol.syslogng.forward.MessageInfo;
import com.clustercontrol.syslogng.forward.MessageParser;
import com.clustercontrol.syslogng.forward.UpdateRepositoryInfoReceiveTopic;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LogManager
extends Thread {
    private static final String TXT_FILE_PATH = "msg.file.txt.path";
    private static final String TXT_FILE_SUFFIX = "msg.file.txt.syffix";
    private static final String MAX_FILE_COUNT = "msg.max.file.count";
    private static final String MULTI_ID = "multi.id";
    private FileUtil m_fileUtil;
    private EJBContoroler m_ejbControl;
    private UpdateRepositoryInfoReceiveTopic m_updateRepository;
    private LinkedList<Object> m_msgList = new LinkedList();
    private ArrayList m_filterList = null;
    private boolean m_waiting = false;
    private boolean m_processErr = true;
    private String m_multiId = null;
    private Log log = LogFactory.getLog(this.getClass());

    public LogManager(Properties props) {
        int maxFileCount;
        this.setName("LogManager");
        String filePath = props.getProperty(TXT_FILE_PATH, ".");
        String msgSuffix = props.getProperty(TXT_FILE_SUFFIX, ".txt");
        try {
            maxFileCount = Integer.parseInt(props.getProperty(MAX_FILE_COUNT, ".txt"));
        }
        catch (Exception e) {
            maxFileCount = -1;
        }
        this.m_fileUtil = new FileUtil(filePath, msgSuffix, maxFileCount);
        this.m_ejbControl = new EJBContoroler(this, props);
        this.m_updateRepository = new UpdateRepositoryInfoReceiveTopic(this.m_ejbControl, props);
        this.m_multiId = props.getProperty(MULTI_ID, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.log.debug((Object)"Thread Start!!");
        while (true) {
            Object msg = null;
            LogManager logManager = this;
            synchronized (logManager) {
                msg = this.getMsg();
                if (msg == null) {
                    this.log.debug((Object)(this.getName() + ": Waiting for processing..."));
                    this.m_waiting = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    this.m_waiting = false;
                    continue;
                }
            }
            if (msg instanceof String) {
                this.log.debug((Object)("proccess msg:" + msg));
                if (this.m_filterList == null) {
                    this.log.debug((Object)("file output msg:" + msg));
                    this.m_fileUtil.write((String)msg);
                    this.m_processErr = true;
                    continue;
                }
                this.proccess((String)msg);
                continue;
            }
            if (!(msg instanceof ArrayList)) continue;
            this.log.debug((Object)"\u30d5\u30a3\u30eb\u30bf\u30fc\u53d7\u4fe1:");
            this.m_filterList = (ArrayList)msg;
            if (!this.m_processErr) continue;
            this.processRetry();
            this.m_processErr = false;
        }
        this.terminate();
        this.log.debug((Object)"Thread End!!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object obj) {
        boolean notifyFlg = false;
        Object object = this.m_msgList;
        synchronized (object) {
            if (this.m_msgList.size() == 0) {
                notifyFlg = true;
            }
            if (obj instanceof String) {
                this.m_msgList.add(obj);
            } else if (obj instanceof ArrayList) {
                this.m_msgList.add(0, obj);
            }
        }
        if (notifyFlg && this.isWaiting()) {
            object = this;
            synchronized (object) {
                this.notify();
            }
        }
    }

    public void addMsg(String msg) {
        this.log.debug((Object)("file output msg:" + msg));
        this.m_fileUtil.write(msg);
        this.m_processErr = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getMsg() {
        LinkedList<Object> linkedList = this.m_msgList;
        synchronized (linkedList) {
            try {
                return this.m_msgList.removeFirst();
            }
            catch (NoSuchElementException e) {
                return null;
            }
        }
    }

    public synchronized boolean isWaiting() {
        return this.m_waiting;
    }

    protected void proccess(String msg) {
        MessageInfo logmsg = MessageParser.parse(msg);
        if (logmsg == null) {
            return;
        }
        for (LogFilterRepositoryInfo filterRepInfo : this.m_filterList) {
            String facilityID = filterRepInfo.getFilter().getFacilityId();
            facilityID = facilityID.equals("UNREGISTERED") ? filterRepInfo.contains(logmsg.getHostName(), false) : filterRepInfo.contains(logmsg.getHostName(), true);
            if (facilityID == null) continue;
            LogFilterInfo filterInfo = filterRepInfo.getFilter();
            String pattern = filterInfo.getPattern();
            try {
                if (!logmsg.getMessage().matches(pattern)) continue;
                if (filterInfo.getProcessType() == 1) {
                    this.log.debug((Object)("Process:" + filterInfo.getDescription() + ":" + msg));
                    LogOutputNotifyInfo logOutput = this.makeMessage(msg, logmsg, filterRepInfo, facilityID, logmsg.getHostName());
                    boolean runFlg = false;
                    runFlg = filterInfo.getCalendarId() == null ? true : this.m_ejbControl.isRun(filterInfo.getCalendarId(), logOutput);
                    if (runFlg) {
                        this.m_ejbControl.sendMsg(logOutput);
                    }
                } else {
                    this.log.debug((Object)("Non Process:" + filterInfo.getDescription() + ":" + msg));
                }
                return;
            }
            catch (Exception e) {
                this.log.error((Object)("\u30d5\u30a3\u30eb\u30bf\u6761\u4ef6\u304c\u7121\u52b9;" + filterInfo.getDescription()), (Throwable)e);
            }
        }
        this.log.debug((Object)("\u8a72\u5f53\u30d5\u30a3\u30eb\u30bf\u30fc\u306a\u3057:" + msg));
    }

    private LogOutputNotifyInfo makeMessage(String msg, MessageInfo logmsg, LogFilterRepositoryInfo filterRepInfo, String facilityID, String NodeName) {
        this.log.debug((Object)"Make ObjectMsg");
        LogFilterInfo filterInfo = filterRepInfo.getFilter();
        LogOutputNotifyInfo logOutput = new LogOutputNotifyInfo();
        logOutput.setPluginId("SLOGNG");
        logOutput.setMonitorId(filterInfo.getMonitorId());
        logOutput.setFacilityId(facilityID);
        if (facilityID.equals("UNREGISTERED")) {
            logOutput.setScopeText(NodeName);
        } else {
            logOutput.setScopeText(filterRepInfo.getNodeName(facilityID));
        }
        logOutput.setApplication(filterInfo.getApplication());
        logOutput.setMessageId(filterInfo.getMessageId());
        logOutput.setMessage(filterInfo.getMessage());
        logOutput.setMessageOrg(msg);
        logOutput.setPriority(filterInfo.getPriority());
        logOutput.setGenerationDate(logmsg.getGenerationDate());
        logOutput.setNotifyId(filterInfo.getNotifyId());
        if (this.m_multiId != null && !"".equals(this.m_multiId)) {
            logOutput.setMultiId(this.m_multiId);
        }
        if (filterInfo.getJobRun() == 1) {
            LogOutputJobRunInfo jobRunInfo = new LogOutputJobRunInfo();
            jobRunInfo.setJobRun(filterInfo.getJobRun());
            jobRunInfo.setJobId(filterInfo.getJobId());
            jobRunInfo.setJobInhibitionFlg(filterInfo.getJobInhibitionFlg());
            jobRunInfo.setJobFailurePriority(filterInfo.getJobFailurePriority());
            logOutput.setJobRun(jobRunInfo);
        }
        return logOutput;
    }

    private synchronized void processRetry() {
        this.log.info((Object)"\u30e1\u30c3\u30bb\u30fc\u30b8\u518d\u51e6\u7406!");
        Collection col = this.m_fileUtil.getFileList();
        for (File file : col) {
            String msg = this.m_fileUtil.readTxtFile(file);
            this.proccess(msg);
            file.delete();
        }
    }

    private void terminate() {
        this.m_ejbControl.terminate();
        this.m_updateRepository.terminate();
    }
}

