/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.remoting;

import java.io.ObjectStreamException;
import java.io.Serializable;
import org.jboss.aop.advice.Interceptor;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.InvocationResponse;
import org.jboss.remoting.Client;
import org.jboss.remoting.InvokerLocator;

public class InvokeRemoteInterceptor
implements Interceptor,
Serializable {
    private static final long serialVersionUID = -145166951731929406L;
    public static final InvokeRemoteInterceptor singleton = new InvokeRemoteInterceptor();
    public static final String REMOTING = "REMOTING";
    public static final String INVOKER_LOCATOR = "INVOKER_LOCATOR";
    public static final String SUBSYSTEM = "SUBSYSTEM";

    public String getName() {
        return "InvokeRemoteInterceptor";
    }

    public Object invoke(Invocation invocation) throws Throwable {
        InvokerLocator locator = (InvokerLocator)invocation.getMetaData((Object)REMOTING, (Object)INVOKER_LOCATOR);
        if (locator == null) {
            throw new RuntimeException("No InvokerLocator supplied.  Can't invoke remotely!");
        }
        String subsystem = (String)invocation.getMetaData((Object)REMOTING, (Object)SUBSYSTEM);
        if (subsystem == null) {
            subsystem = "AOP";
        }
        Client client = new Client(locator, subsystem);
        InvocationResponse response = (InvocationResponse)client.invoke((Object)invocation, null);
        invocation.setResponseContextInfo(response.getContextInfo());
        return response.getResponse();
    }

    Object readResolve() throws ObjectStreamException {
        return singleton;
    }
}

