/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.handler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.Handler;
import javax.xml.rpc.handler.HandlerChain;
import javax.xml.rpc.handler.HandlerInfo;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPPart;
import org.jboss.axis.AxisFault;
import org.jboss.axis.Constants;
import org.jboss.axis.message.SOAPElementAxisImpl;
import org.jboss.logging.Logger;
import org.jboss.webservice.handler.HandlerWrapper;

public abstract class HandlerChainBaseImpl
implements HandlerChain {
    private static Logger log = Logger.getLogger((Class)HandlerChainBaseImpl.class);
    public static final int STATE_DOES_NOT_EXIST = 0;
    public static final int STATE_CREATED = 1;
    public static final int STATE_READY = 2;
    public static final int STATE_DESTROYED = 3;
    protected ArrayList handlers = new ArrayList();
    protected HashSet roles = new HashSet();
    protected int falseIndex = -1;
    protected int state;

    public HandlerChainBaseImpl(List infos, Set roles) {
        log.debug((Object)("Create a handler chain for roles: " + roles));
        this.addHandlersToChain(infos, roles);
    }

    private void addHandlersToChain(List infos, Set roleSet) {
        try {
            if (infos != null) {
                for (int i = 0; i < infos.size(); ++i) {
                    HandlerInfo info = (HandlerInfo)infos.get(i);
                    HandlerWrapper handler = new HandlerWrapper((Handler)info.getHandlerClass().newInstance());
                    this.handlers.add(new Entry(handler, info));
                }
            }
            if (roleSet != null) {
                this.roles.addAll(roleSet);
            }
        }
        catch (Exception e) {
            throw new JAXRPCException("Cannot initialize handler chain", (Throwable)e);
        }
        this.state = 1;
    }

    public int getState() {
        return this.state;
    }

    public void init(Map config) {
        log.debug((Object)("init: [config=" + config + "]"));
        for (int i = 0; i < this.handlers.size(); ++i) {
            Entry entry = (Entry)this.handlers.get(i);
            entry.handler.init(entry.info);
        }
        this.state = 2;
    }

    public void destroy() {
        log.debug((Object)"destroy");
        for (int i = 0; i < this.handlers.size(); ++i) {
            Entry entry = (Entry)this.handlers.get(i);
            entry.handler.destroy();
        }
        this.handlers.clear();
        this.state = 3;
    }

    public String[] getRoles() {
        String[] arr = new String[this.roles.size()];
        this.roles.toArray(arr);
        return arr;
    }

    public void setRoles(String[] soapActorNames) {
        List<String> newRoles = Arrays.asList(soapActorNames);
        log.debug((Object)("setRoles: " + newRoles));
        this.roles.clear();
        this.roles.addAll(newRoles);
    }

    public boolean handleRequest(MessageContext msgContext) {
        int handlerIndex;
        boolean doNext = true;
        log.debug((Object)"Enter: doHandleRequest");
        this.replaceDirtyHandlers();
        Handler currHandler = null;
        try {
            try {
                for (handlerIndex = 0; doNext && handlerIndex < this.handlers.size(); ++handlerIndex) {
                    SOAPPart soapPart;
                    org.jboss.axis.MessageContext msgCtx;
                    String lastMessageTrace = null;
                    if (log.isTraceEnabled()) {
                        msgCtx = (org.jboss.axis.MessageContext)msgContext;
                        soapPart = msgCtx.getRequestMessage().getSOAPPart();
                        lastMessageTrace = this.traceSOAPPart(soapPart, lastMessageTrace);
                    }
                    currHandler = ((Entry)this.handlers.get(handlerIndex)).getHandler();
                    log.debug((Object)("Handle request: " + currHandler));
                    doNext = currHandler.handleRequest(msgContext);
                    if (!log.isTraceEnabled()) continue;
                    msgCtx = (org.jboss.axis.MessageContext)msgContext;
                    soapPart = msgCtx.getRequestMessage().getSOAPPart();
                    lastMessageTrace = this.traceSOAPPart(soapPart, lastMessageTrace);
                }
                Object var9_9 = null;
                if (!doNext) {
                    this.falseIndex = handlerIndex;
                }
            }
            catch (RuntimeException e) {
                log.error((Object)"RuntimeException in request handler", (Throwable)e);
                doNext = false;
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!doNext) {
                this.falseIndex = handlerIndex;
            }
            log.debug((Object)("Exit: doHandleRequest with status: " + doNext));
            throw throwable;
        }
        log.debug((Object)("Exit: doHandleRequest with status: " + doNext));
        return doNext;
    }

    public boolean handleResponse(MessageContext msgContext) {
        boolean doNext = true;
        log.debug((Object)"Enter: handleResponse");
        int handlerIndex = this.handlers.size() - 1;
        if (this.falseIndex != -1) {
            handlerIndex = this.falseIndex;
        }
        Handler currHandler = null;
        try {
            try {
                while (doNext && handlerIndex >= 0) {
                    SOAPPart soapPart;
                    org.jboss.axis.MessageContext msgCtx;
                    String lastMessageTrace = null;
                    if (log.isTraceEnabled()) {
                        msgCtx = (org.jboss.axis.MessageContext)msgContext;
                        soapPart = msgCtx.getResponseMessage().getSOAPPart();
                        lastMessageTrace = this.traceSOAPPart(soapPart, lastMessageTrace);
                    }
                    currHandler = ((Entry)this.handlers.get(handlerIndex)).getHandler();
                    log.debug((Object)("Handle response: " + currHandler));
                    doNext = currHandler.handleResponse(msgContext);
                    if (log.isTraceEnabled()) {
                        msgCtx = (org.jboss.axis.MessageContext)msgContext;
                        soapPart = msgCtx.getResponseMessage().getSOAPPart();
                        lastMessageTrace = this.traceSOAPPart(soapPart, lastMessageTrace);
                    }
                    --handlerIndex;
                }
                Object var9_9 = null;
                if (!doNext) {
                    this.falseIndex = handlerIndex;
                }
            }
            catch (RuntimeException rte) {
                log.error((Object)"RuntimeException in response handler", (Throwable)rte);
                doNext = false;
                throw rte;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!doNext) {
                this.falseIndex = handlerIndex;
            }
            log.debug((Object)("Exit: handleResponse with status: " + doNext));
            throw throwable;
        }
        log.debug((Object)("Exit: handleResponse with status: " + doNext));
        return doNext;
    }

    public boolean handleFault(MessageContext msgContext) {
        boolean doNext = true;
        int handlerIndex = this.handlers.size() - 1;
        if (this.falseIndex != -1) {
            handlerIndex = this.falseIndex;
        }
        Handler currHandler = null;
        while (doNext && handlerIndex >= 0) {
            currHandler = ((Entry)this.handlers.get(handlerIndex)).getHandler();
            log.debug((Object)("Handle fault: " + currHandler));
            doNext = currHandler.handleFault(msgContext);
            --handlerIndex;
        }
        return doNext;
    }

    protected String traceSOAPPart(SOAPPart soapPart, String lastMessageTrace) {
        try {
            SOAPEnvelope env = soapPart.getEnvelope();
            String envAsString = ((SOAPElementAxisImpl)env).getAsStringFromInternal();
            if (!envAsString.equals(lastMessageTrace)) {
                log.trace((Object)envAsString);
                lastMessageTrace = envAsString;
            }
            return lastMessageTrace;
        }
        catch (SOAPException e) {
            log.error((Object)"Cannot get SOAPEnvelope", (Throwable)e);
            return null;
        }
    }

    protected void replaceDirtyHandlers() {
        for (int i = 0; i < this.handlers.size(); ++i) {
            Entry entry = (Entry)this.handlers.get(i);
            if (entry.handler.getState() != 0) continue;
            log.debug((Object)("Replacing dirty handler: " + entry.handler));
            try {
                HandlerWrapper handler = new HandlerWrapper((Handler)entry.info.getHandlerClass().newInstance());
                entry.handler = handler;
                handler.init(entry.info);
                continue;
            }
            catch (Exception e) {
                log.error((Object)("Cannot create handler instance for: " + entry.info));
            }
        }
    }

    protected Handler getHandlerAt(int pos) {
        if (pos < 0 || this.handlers.size() <= pos) {
            throw new IllegalArgumentException("No handler at position: " + pos);
        }
        Entry entry = (Entry)this.handlers.get(pos);
        return entry.handler;
    }

    protected void checkMustUnderstand(MessageContext msgContext) {
        String errorMsg;
        block6: {
            errorMsg = null;
            try {
                SOAPMessageContext msgCtx = (SOAPMessageContext)msgContext;
                SOAPPart soapPart = msgCtx.getMessage().getSOAPPart();
                SOAPHeader soapHeader = soapPart.getEnvelope().getHeader();
                if (soapHeader == null) break block6;
                Iterator it = soapHeader.examineAllHeaderElements();
                block2: while (errorMsg == null && it.hasNext()) {
                    SOAPHeaderElement headerElement = (SOAPHeaderElement)it.next();
                    if (!headerElement.getMustUnderstand()) continue;
                    QName headerName = new QName(headerElement.getNamespaceURI(), headerElement.getLocalName());
                    String actor = headerElement.getActor();
                    if (actor == null || "http://schemas.xmlsoap.org/soap/actor/next".equals(actor)) {
                        errorMsg = "Unprocessed mustUnderstand header " + headerName;
                        break;
                    }
                    if (actor == null || !this.roles.contains(actor)) continue;
                    Iterator itHandlers = this.handlers.iterator();
                    while (itHandlers.hasNext()) {
                        Entry entry = (Entry)itHandlers.next();
                        Handler handler = entry.getHandler();
                        List<QName> headers = Arrays.asList(handler.getHeaders());
                        if (!headers.contains(headerName)) continue;
                        errorMsg = "Unprocessed mustUnderstand header " + headerName;
                        continue block2;
                    }
                }
            }
            catch (SOAPException e) {
                log.error((Object)"Cannot check mustUnderstand for headers", (Throwable)e);
            }
        }
        if (errorMsg != null) {
            AxisFault fault = new AxisFault(errorMsg);
            fault.setFaultCode(Constants.FAULT_MUSTUNDERSTAND);
            throw new JAXRPCException((Throwable)fault);
        }
    }

    public boolean remove(Object o) {
        return this.handlers.remove(o);
    }

    public boolean containsAll(Collection c) {
        return this.handlers.containsAll(c);
    }

    public boolean removeAll(Collection c) {
        return this.handlers.removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.handlers.retainAll(c);
    }

    public int hashCode() {
        return this.handlers.hashCode();
    }

    public boolean equals(Object o) {
        return this.handlers.equals(o);
    }

    public Iterator iterator() {
        return this.handlers.iterator();
    }

    public List subList(int fromIndex, int toIndex) {
        return this.handlers.subList(fromIndex, toIndex);
    }

    public ListIterator listIterator() {
        return this.handlers.listIterator();
    }

    public ListIterator listIterator(int index) {
        return this.handlers.listIterator(index);
    }

    public int size() {
        return this.handlers.size();
    }

    public void clear() {
        this.handlers.clear();
    }

    public boolean isEmpty() {
        return this.handlers.isEmpty();
    }

    public Object[] toArray() {
        return this.handlers.toArray();
    }

    public Object get(int index) {
        return this.handlers.get(index);
    }

    public Object remove(int index) {
        return this.handlers.remove(index);
    }

    public void add(int index, Object element) {
        this.handlers.add(index, element);
    }

    public int indexOf(Object elem) {
        return this.handlers.indexOf(elem);
    }

    public int lastIndexOf(Object elem) {
        return this.handlers.lastIndexOf(elem);
    }

    public boolean add(Object o) {
        return this.handlers.add(o);
    }

    public boolean contains(Object elem) {
        return this.handlers.contains(elem);
    }

    public boolean addAll(int index, Collection c) {
        return this.handlers.addAll(index, c);
    }

    public boolean addAll(Collection c) {
        return this.handlers.addAll(c);
    }

    public Object set(int index, Object element) {
        return this.handlers.set(index, element);
    }

    public Object[] toArray(Object[] a) {
        return this.handlers.toArray(a);
    }

    private class Entry {
        private HandlerWrapper handler;
        private HandlerInfo info;

        public Entry(HandlerWrapper handler, HandlerInfo info) {
            this.handler = handler;
            this.info = info;
        }

        public Handler getHandler() {
            return this.handler;
        }

        public HandlerInfo getInfo() {
            return this.info;
        }
    }
}

