/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.multiplex;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.SocketException;
import org.jboss.logging.Logger;
import org.jboss.remoting.transport.multiplex.VirtualSocket;

public class MultiplexingInputStream
extends PipedInputStream {
    protected static final Logger log = Logger.getLogger((Class)(class$org$jboss$remoting$transport$multiplex$MultiplexingInputStream == null ? (class$org$jboss$remoting$transport$multiplex$MultiplexingInputStream = MultiplexingInputStream.class$("org.jboss.remoting.transport.multiplex.MultiplexingInputStream")) : class$org$jboss$remoting$transport$multiplex$MultiplexingInputStream));
    private VirtualSocket socket;
    private PipedOutputStream sourceStream;
    private boolean eof = false;
    private boolean closed = false;
    private boolean remoteShutDownPending = false;
    private Thread readThread;
    static /* synthetic */ Class class$org$jboss$remoting$transport$multiplex$MultiplexingInputStream;

    public MultiplexingInputStream(PipedOutputStream sourceStream, VirtualSocket socket) throws IOException {
        super(sourceStream);
        this.sourceStream = sourceStream;
        this.socket = socket;
    }

    public MultiplexingInputStream(PipedOutputStream sourceStream) throws IOException {
        super(sourceStream);
        this.sourceStream = sourceStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.closed) {
            throw new SocketException("Socket closed");
        }
        if (this.remoteShutDownPending && this.available() == 0) {
            this.remoteShutDownPending = false;
            this.setEOF();
            return -1;
        }
        try {
            MultiplexingInputStream multiplexingInputStream = this;
            synchronized (multiplexingInputStream) {
                this.readThread = Thread.currentThread();
                log.debug((Object)"read(): calling super.read()");
                int b = super.read();
                this.readThread = null;
                log.debug((Object)"read(): returning from super.read()");
                return b;
            }
        }
        catch (InterruptedIOException e) {
            if (this.remoteShutDownPending) {
                this.remoteShutDownPending = false;
                this.setEOF();
                return -1;
            }
            throw e;
        }
        catch (IOException e) {
            if (this.closed) {
                throw new SocketException("Socket closed");
            }
            if (this.remoteShutDownPending) {
                log.debug((Object)"read(): interrupted due to remote shutdown pending");
                this.remoteShutDownPending = false;
                this.setEOF();
                return -1;
            }
            throw e;
        }
    }

    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] bytes, int off, int len) throws IOException {
        if (this.eof) {
            return -1;
        }
        if (this.closed) {
            throw new SocketException("Socket closed");
        }
        if (this.remoteShutDownPending && this.available() == 0) {
            this.remoteShutDownPending = false;
            this.setEOF();
            return -1;
        }
        try {
            MultiplexingInputStream multiplexingInputStream = this;
            synchronized (multiplexingInputStream) {
                this.readThread = Thread.currentThread();
                log.debug((Object)"read(): calling super.read()");
                int n = super.read(bytes, off, len);
                this.readThread = null;
                log.debug((Object)"read(): returning from super.read()");
                return n;
            }
        }
        catch (InterruptedIOException e) {
            if (this.remoteShutDownPending) {
                this.remoteShutDownPending = false;
                this.setEOF();
                return -1;
            }
            throw e;
        }
        catch (IOException e) {
            if (this.closed) {
                throw new SocketException("Socket closed");
            }
            if (this.remoteShutDownPending) {
                log.debug((Object)"read(): interrupted due to remote shutdown pending");
                this.remoteShutDownPending = false;
                this.setEOF();
                return -1;
            }
            throw e;
        }
    }

    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        super.close();
        if (this.socket != null) {
            this.socket.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleRemoteShutdown() throws IOException {
        log.debug((Object)"entering handleRemoteShutdown()");
        if (this.eof) {
            return;
        }
        this.remoteShutDownPending = true;
        if (this.available() == 0) {
            MultiplexingInputStream multiplexingInputStream = this;
            synchronized (multiplexingInputStream) {
                if (this.readThread != null) {
                    this.readThread.interrupt();
                }
            }
        }
    }

    protected void setEOF() {
        this.eof = true;
    }

    protected int timedRead() throws IOException {
        final IntWrapper b = new IntWrapper();
        final IOExceptionWrapper readException = new IOExceptionWrapper();
        final Thread thisThread = Thread.currentThread();
        final Object lock = new Object();
        final Thread readThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    Object object = lock;
                    synchronized (object) {
                        log.info((Object)"readThread: entered sync section");
                        b.set(MultiplexingInputStream.super.read());
                        lock.notifyAll();
                    }
                }
                catch (IOException e) {
                    readException.set(e);
                }
            }
        };
        Thread waitThread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = lock;
                synchronized (object) {
                    readThread.start();
                    lock.notifyAll();
                    try {
                        lock.wait();
                    }
                    catch (InterruptedException e) {
                        log.info((Object)e);
                    }
                    thisThread.interrupt();
                }
            }
        };
        waitThread.start();
        while (!(b.isSet() || readException.isSet() || this.remoteShutDownPending || this.eof)) {
            try {
                Thread.sleep(2000L);
                log.debug((Object)"timedRead(): waiting 1000");
            }
            catch (InterruptedException e) {
                log.info((Object)"timeRead(): interrupted");
            }
        }
        if (readException.isSet()) {
            throw readException.get();
        }
        log.info((Object)("timedRead(): returning: " + b.get()));
        return b.get();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class IntWrapper {
        private int i;
        private boolean set = false;

        IntWrapper() {
        }

        int get() {
            return this.i;
        }

        void set(int i) {
            this.i = i;
            this.set = true;
        }

        boolean isSet() {
            return this.set;
        }
    }

    class IOExceptionWrapper {
        private IOException e;

        IOExceptionWrapper() {
        }

        IOException get() {
            return this.e;
        }

        void set(IOException e) {
            this.e = e;
        }

        boolean isSet() {
            return this.e != null;
        }
    }
}

