/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.corba;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;

public class ORBFactory {
    private static final Logger log = Logger.getLogger((Class)ORBFactory.class);
    private static ORB orb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ORB getORB() {
        Class clazz = ORBFactory.class;
        synchronized (clazz) {
            if (orb == null) {
                Properties properties;
                try {
                    properties = (Properties)AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return System.getProperties();
                        }
                    });
                }
                catch (SecurityException ignored) {
                    log.trace((Object)"Unable to retrieve system properties", (Throwable)ignored);
                    properties = null;
                }
                orb = ORB.init((String[])new String[0], (Properties)properties);
                try {
                    POA rootPOA = (POA)orb.resolve_initial_references("RootPOA");
                    rootPOA.the_POAManager().activate();
                }
                catch (Throwable t) {
                    log.warn((Object)"Unable to activate POA", t);
                }
            }
            return orb;
        }
    }

    public static void setORB(ORB orb) {
        if (ORBFactory.orb != null) {
            throw new IllegalStateException("ORB has already been set");
        }
        ORBFactory.orb = orb;
    }
}

