/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jacorb.notification.engine.AbstractDeliverTask;
import org.jacorb.notification.engine.AbstractFilterTask;
import org.jacorb.notification.engine.FilterProxySupplierTask;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.FilterStage;

public class FilterConsumerAdminTask
extends AbstractFilterTask {
    private static final FilterStage[] NO_CURRENT_FILTER_STAGE = new FilterStage[0];
    private static int sCount = 0;
    private int id_ = ++sCount;
    protected List listOfFilterStageWithMessageConsumer_ = new ArrayList();

    FilterConsumerAdminTask(TaskExecutor taskExecutor, TaskProcessor taskProcessor, TaskFactory taskFactory) {
        super(taskExecutor, taskProcessor, taskFactory);
    }

    public String toString() {
        return "[FilterConsumerAdminTask#" + this.id_ + "]";
    }

    public void setFilterStage(AbstractFilterTask abstractFilterTask) {
        this.arrayCurrentFilterStage_ = abstractFilterTask.getFilterStageToBeProcessed();
    }

    public FilterStage[] getFilterStagesWithMessageConsumer() {
        return this.listOfFilterStageWithMessageConsumer_.toArray(FILTERSTAGE_ARRAY_TEMPLATE);
    }

    private void clearFilterStagesWithMessageConsumer() {
        this.listOfFilterStageWithMessageConsumer_.clear();
    }

    public void reset() {
        super.reset();
        this.clearFilterStagesWithMessageConsumer();
        this.arrayCurrentFilterStage_ = NO_CURRENT_FILTER_STAGE;
    }

    public void doWork() throws InterruptedException {
        this.logger_.debug("doWork");
        if (this.arrayCurrentFilterStage_.length > 0) {
            this.filter();
            this.pushToConsumers();
        } else {
            this.logger_.debug("No ConsumerAdmin connected");
            this.message_.dispose();
        }
        this.dispose();
    }

    private void pushToConsumers() throws InterruptedException {
        FilterStage[] filterStageArray = this.getFilterStagesWithMessageConsumer();
        FilterProxySupplierTask filterProxySupplierTask = null;
        if (filterStageArray.length > 0) {
            AbstractDeliverTask[] abstractDeliverTaskArray = null;
            abstractDeliverTaskArray = this.getTaskFactory().newPushToConsumerTask(filterStageArray, this.copyMessage());
            AbstractDeliverTask.scheduleTasks(abstractDeliverTaskArray);
        }
        filterProxySupplierTask = this.getTaskFactory().newFilterProxySupplierTask(this);
        filterProxySupplierTask.schedule();
    }

    private void filter() throws InterruptedException {
        for (int i = 0; i < this.arrayCurrentFilterStage_.length; ++i) {
            this.checkInterrupt();
            boolean bl = false;
            if (!this.arrayCurrentFilterStage_[i].isDisposed()) {
                bl = this.message_.match(this.arrayCurrentFilterStage_[i]);
            }
            if (bl) {
                if (this.arrayCurrentFilterStage_[i].hasInterFilterGroupOperatorOR()) {
                    this.listOfFilterStageWithMessageConsumer_.addAll(this.arrayCurrentFilterStage_[i].getSubsequentFilterStages());
                    continue;
                }
                this.addFilterStage(this.arrayCurrentFilterStage_[i].getSubsequentFilterStages());
                continue;
            }
            Iterator iterator = this.arrayCurrentFilterStage_[i].getSubsequentFilterStages().iterator();
            while (iterator.hasNext()) {
                FilterStage filterStage = (FilterStage)iterator.next();
                if (!filterStage.hasInterFilterGroupOperatorOR()) continue;
                this.addFilterStage(filterStage);
            }
        }
    }
}

