/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.axis;

import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.AxisState;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.CategoryLabelWidthType;
import org.jfree.chart.axis.CategoryTick;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.TickLabelEntity;
import org.jfree.chart.event.AxisChangeEvent;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.text.G2TextMeasurer;
import org.jfree.text.TextBlock;
import org.jfree.text.TextUtilities;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.Size2D;
import org.jfree.util.Log;
import org.jfree.util.LogContext;
import org.jfree.util.ObjectUtils;
import org.jfree.util.ShapeUtils;

public class CategoryAxis
extends Axis
implements Cloneable,
Serializable {
    public static final double DEFAULT_AXIS_MARGIN = 0.05;
    public static final double DEFAULT_CATEGORY_MARGIN = 0.2;
    private double lowerMargin = 0.05;
    private double upperMargin = 0.05;
    private double categoryMargin = 0.2;
    private float maxCategoryLabelWidthRatio = 0.0f;
    private int categoryLabelPositionOffset;
    private CategoryLabelPositions categoryLabelPositions;
    private Map categoryLabelToolTips;
    protected static final LogContext logger = Log.createContext(class$org$jfree$chart$axis$CategoryAxis == null ? (class$org$jfree$chart$axis$CategoryAxis = CategoryAxis.class$("org.jfree.chart.axis.CategoryAxis")) : class$org$jfree$chart$axis$CategoryAxis);
    static /* synthetic */ Class class$org$jfree$chart$axis$CategoryAxis;

    public CategoryAxis() {
        this(null);
    }

    public CategoryAxis(String label) {
        super(label);
        this.setTickMarksVisible(false);
        this.categoryLabelPositionOffset = 4;
        this.categoryLabelPositions = CategoryLabelPositions.STANDARD;
        this.categoryLabelToolTips = new HashMap();
    }

    public double getLowerMargin() {
        return this.lowerMargin;
    }

    public void setLowerMargin(double margin) {
        this.lowerMargin = margin;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getUpperMargin() {
        return this.upperMargin;
    }

    public void setUpperMargin(double margin) {
        this.upperMargin = margin;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getCategoryMargin() {
        return this.categoryMargin;
    }

    public void setCategoryMargin(double margin) {
        this.categoryMargin = margin;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public float getMaxCategoryLabelWidthRatio() {
        return this.maxCategoryLabelWidthRatio;
    }

    public void setMaxCategoryLabelWidthRatio(float ratio) {
        this.maxCategoryLabelWidthRatio = ratio;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public int getCategoryLabelPositionOffset() {
        return this.categoryLabelPositionOffset;
    }

    public void setCategoryLabelPositionOffset(int offset) {
        this.categoryLabelPositionOffset = offset;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public CategoryLabelPositions getCategoryLabelPositions() {
        return this.categoryLabelPositions;
    }

    public void setCategoryLabelPositions(CategoryLabelPositions positions) {
        if (positions == null) {
            throw new IllegalArgumentException("Null 'positions' argument.");
        }
        this.categoryLabelPositions = positions;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void addCategoryLabelToolTip(Comparable category, String tooltip) {
        if (category == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        this.categoryLabelToolTips.put(category, tooltip);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void removeCategoryLabelToolTip(Comparable category) {
        if (category == null) {
            throw new IllegalArgumentException("Null 'category' argument.");
        }
        this.categoryLabelToolTips.remove(category);
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public void clearCategoryLabelToolTips() {
        this.categoryLabelToolTips.clear();
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public double getCategoryJava2DCoordinate(CategoryAnchor anchor, int category, int categoryCount, Rectangle2D area, RectangleEdge edge) {
        double result = 0.0;
        if (anchor == CategoryAnchor.START) {
            result = this.getCategoryStart(category, categoryCount, area, edge);
        } else if (anchor == CategoryAnchor.MIDDLE) {
            result = this.getCategoryMiddle(category, categoryCount, area, edge);
        } else if (anchor == CategoryAnchor.END) {
            result = this.getCategoryEnd(category, categoryCount, area, edge);
        }
        return result;
    }

    public double getCategoryStart(int category, int categoryCount, Rectangle2D area, RectangleEdge edge) {
        double result = 0.0;
        if (edge == RectangleEdge.TOP || edge == RectangleEdge.BOTTOM) {
            result = area.getX() + area.getWidth() * this.getLowerMargin();
        } else if (edge == RectangleEdge.LEFT || edge == RectangleEdge.RIGHT) {
            result = area.getMinY() + area.getHeight() * this.getLowerMargin();
        }
        double categorySize = this.calculateCategorySize(categoryCount, area, edge);
        double categoryGapWidth = this.calculateCategoryGapSize(categoryCount, area, edge);
        return result += (double)category * (categorySize + categoryGapWidth);
    }

    public double getCategoryMiddle(int category, int categoryCount, Rectangle2D area, RectangleEdge edge) {
        return this.getCategoryStart(category, categoryCount, area, edge) + this.calculateCategorySize(categoryCount, area, edge) / 2.0;
    }

    public double getCategoryEnd(int category, int categoryCount, Rectangle2D area, RectangleEdge edge) {
        return this.getCategoryStart(category, categoryCount, area, edge) + this.calculateCategorySize(categoryCount, area, edge);
    }

    protected double calculateCategorySize(int categoryCount, Rectangle2D area, RectangleEdge edge) {
        double result = 0.0;
        double available = 0.0;
        if (edge == RectangleEdge.TOP || edge == RectangleEdge.BOTTOM) {
            available = area.getWidth();
        } else if (edge == RectangleEdge.LEFT || edge == RectangleEdge.RIGHT) {
            available = area.getHeight();
        }
        if (categoryCount > 1) {
            result = available * (1.0 - this.getLowerMargin() - this.getUpperMargin() - this.getCategoryMargin());
            result /= (double)categoryCount;
        } else {
            result = available * (1.0 - this.getLowerMargin() - this.getUpperMargin());
        }
        return result;
    }

    protected double calculateCategoryGapSize(int categoryCount, Rectangle2D area, RectangleEdge edge) {
        double result = 0.0;
        double available = 0.0;
        if (edge == RectangleEdge.TOP || edge == RectangleEdge.BOTTOM) {
            available = area.getWidth();
        } else if (edge == RectangleEdge.LEFT || edge == RectangleEdge.RIGHT) {
            available = area.getHeight();
        }
        if (categoryCount > 1) {
            result = available * this.getCategoryMargin() / (double)(categoryCount - 1);
        }
        return result;
    }

    public AxisSpace reserveSpace(Graphics2D g2, Plot plot, Rectangle2D plotArea, RectangleEdge edge, AxisSpace space) {
        if (space == null) {
            space = new AxisSpace();
        }
        if (!this.isVisible()) {
            return space;
        }
        double tickLabelHeight = 0.0;
        double tickLabelWidth = 0.0;
        if (this.isTickLabelsVisible()) {
            g2.setFont(this.getTickLabelFont());
            AxisState state = new AxisState();
            this.refreshTicks(g2, state, plotArea, plotArea, edge);
            if (edge == RectangleEdge.TOP) {
                tickLabelHeight = state.getMax();
            } else if (edge == RectangleEdge.BOTTOM) {
                tickLabelHeight = state.getMax();
            } else if (edge == RectangleEdge.LEFT) {
                tickLabelWidth = state.getMax();
            } else if (edge == RectangleEdge.RIGHT) {
                tickLabelWidth = state.getMax();
            }
        }
        Rectangle2D labelEnclosure = this.getLabelEnclosure(g2, edge);
        double labelHeight = 0.0;
        double labelWidth = 0.0;
        if (RectangleEdge.isTopOrBottom(edge)) {
            labelHeight = labelEnclosure.getHeight();
            space.add(labelHeight + tickLabelHeight + (double)this.categoryLabelPositionOffset, edge);
        } else if (RectangleEdge.isLeftOrRight(edge)) {
            labelWidth = labelEnclosure.getWidth();
            space.add(labelWidth + tickLabelWidth + (double)this.categoryLabelPositionOffset, edge);
        }
        return space;
    }

    public void configure() {
    }

    public AxisState draw(Graphics2D g2, double cursor, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge, PlotRenderingInfo plotState) {
        if (logger.isDebugEnabled()) {
            logger.debug("Entering draw() method, cursor = " + cursor);
        }
        if (!this.isVisible()) {
            return new AxisState(cursor);
        }
        if (this.isAxisLineVisible()) {
            this.drawAxisLine(g2, cursor, dataArea, edge);
        }
        AxisState state = new AxisState(cursor);
        state = this.drawCategoryLabels(g2, plotArea, dataArea, edge, state, plotState);
        state = this.drawLabel(this.getLabel(), g2, plotArea, dataArea, edge, state);
        return state;
    }

    protected AxisState drawCategoryLabels(Graphics2D g2, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge, AxisState state, PlotRenderingInfo plotState) {
        if (logger.isDebugEnabled()) {
            logger.debug("Entering drawCategoryLabels() method, cursor = " + state.getCursor());
        }
        if (state == null) {
            throw new IllegalArgumentException("Null 'state' argument.");
        }
        if (this.isTickLabelsVisible()) {
            g2.setFont(this.getTickLabelFont());
            g2.setPaint(this.getTickLabelPaint());
            List ticks = this.refreshTicks(g2, state, plotArea, dataArea, edge);
            state.setTicks(ticks);
            int categoryIndex = 0;
            Iterator iterator = ticks.iterator();
            while (iterator.hasNext()) {
                EntityCollection entities;
                CategoryTick tick = (CategoryTick)iterator.next();
                g2.setPaint(this.getTickLabelPaint());
                CategoryLabelPosition position = this.categoryLabelPositions.getLabelPosition(edge);
                double x0 = 0.0;
                double x1 = 0.0;
                double y0 = 0.0;
                double y1 = 0.0;
                if (edge == RectangleEdge.TOP) {
                    x0 = this.getCategoryStart(categoryIndex, ticks.size(), dataArea, edge);
                    x1 = this.getCategoryEnd(categoryIndex, ticks.size(), dataArea, edge);
                    y1 = state.getCursor() - (double)this.categoryLabelPositionOffset;
                    y0 = y1 - state.getMax();
                } else if (edge == RectangleEdge.BOTTOM) {
                    x0 = this.getCategoryStart(categoryIndex, ticks.size(), dataArea, edge);
                    x1 = this.getCategoryEnd(categoryIndex, ticks.size(), dataArea, edge);
                    y0 = state.getCursor() + (double)this.categoryLabelPositionOffset;
                    y1 = y0 + state.getMax();
                } else if (edge == RectangleEdge.LEFT) {
                    y0 = this.getCategoryStart(categoryIndex, ticks.size(), dataArea, edge);
                    y1 = this.getCategoryEnd(categoryIndex, ticks.size(), dataArea, edge);
                    x1 = state.getCursor() - (double)this.categoryLabelPositionOffset;
                    x0 = x1 - state.getMax();
                } else if (edge == RectangleEdge.RIGHT) {
                    y0 = this.getCategoryStart(categoryIndex, ticks.size(), dataArea, edge);
                    y1 = this.getCategoryEnd(categoryIndex, ticks.size(), dataArea, edge);
                    x0 = state.getCursor() + (double)this.categoryLabelPositionOffset;
                    x1 = x0 - state.getMax();
                }
                Rectangle2D.Double area = new Rectangle2D.Double(x0, y0, x1 - x0, y1 - y0);
                double[] anchorPoint = RectangleAnchor.coordinates(area, position.getCategoryAnchor());
                TextBlock block = tick.getLabel();
                block.draw(g2, (float)anchorPoint[0], (float)anchorPoint[1], position.getLabelAnchor(), (float)anchorPoint[0], (float)anchorPoint[1], position.getAngle());
                Shape bounds = block.calculateBounds(g2, (float)anchorPoint[0], (float)anchorPoint[1], position.getLabelAnchor(), (float)anchorPoint[0], (float)anchorPoint[1], position.getAngle());
                if (plotState != null && (entities = plotState.getOwner().getEntityCollection()) != null) {
                    String tooltip = (String)this.categoryLabelToolTips.get(tick.getCategory());
                    entities.addEntity(new TickLabelEntity(bounds, tooltip, null));
                }
                ++categoryIndex;
            }
            if (edge.equals(RectangleEdge.TOP)) {
                double h = state.getMax();
                state.cursorUp(h);
            } else if (edge.equals(RectangleEdge.BOTTOM)) {
                double h = state.getMax();
                state.cursorDown(h);
            } else if (edge == RectangleEdge.LEFT) {
                double w = state.getMax();
                state.cursorLeft(w);
            } else if (edge == RectangleEdge.RIGHT) {
                double w = state.getMax();
                state.cursorRight(w);
            }
        }
        return state;
    }

    public List refreshTicks(Graphics2D g2, AxisState state, Rectangle2D plotArea, Rectangle2D dataArea, RectangleEdge edge) {
        ArrayList<CategoryTick> ticks = new ArrayList<CategoryTick>();
        if (dataArea.getHeight() <= 0.0 || dataArea.getWidth() < 0.0) {
            return ticks;
        }
        CategoryPlot plot = (CategoryPlot)this.getPlot();
        List categories = plot.getCategories();
        double max = 0.0;
        if (categories != null) {
            CategoryLabelPosition position = this.categoryLabelPositions.getLabelPosition(edge);
            float r = this.maxCategoryLabelWidthRatio;
            if ((double)r <= 0.0) {
                r = position.getWidthRatio();
            }
            float l = 0.0f;
            l = position.getWidthType() == CategoryLabelWidthType.CATEGORY ? (float)this.calculateCategorySize(categories.size(), dataArea, edge) : (RectangleEdge.isLeftOrRight(edge) ? (float)dataArea.getWidth() : (float)dataArea.getHeight());
            int categoryIndex = 0;
            Iterator iterator = categories.iterator();
            while (iterator.hasNext()) {
                Comparable category = (Comparable)iterator.next();
                TextBlock label = this.createLabel(category, l * r, edge, g2);
                if (edge == RectangleEdge.TOP || edge == RectangleEdge.BOTTOM) {
                    max = Math.max(max, this.calculateTextBlockHeight(label, position, g2));
                } else if (edge == RectangleEdge.LEFT || edge == RectangleEdge.RIGHT) {
                    max = Math.max(max, this.calculateTextBlockWidth(label, position, g2));
                }
                CategoryTick tick = new CategoryTick(category, label, position.getLabelAnchor(), position.getRotationAnchor(), position.getAngle());
                ticks.add(tick);
                ++categoryIndex;
            }
        }
        state.setMax(max);
        return ticks;
    }

    protected TextBlock createLabel(Comparable category, float width, RectangleEdge edge, Graphics2D g2) {
        TextBlock label = TextUtilities.createTextBlock(category.toString(), this.getTickLabelFont(), this.getTickLabelPaint(), width, new G2TextMeasurer(g2));
        return label;
    }

    protected double calculateTextBlockWidth(TextBlock block, CategoryLabelPosition position, Graphics2D g2) {
        Insets insets = this.getTickLabelInsets();
        Size2D size = block.calculateDimensions(g2);
        Rectangle2D.Double box = new Rectangle2D.Double(0.0, 0.0, size.getWidth(), size.getHeight());
        Shape rotatedBox = ShapeUtils.rotateShape(box, position.getAngle(), 0.0f, 0.0f);
        double w = rotatedBox.getBounds2D().getWidth() + (double)insets.top + (double)insets.bottom;
        return w;
    }

    protected double calculateTextBlockHeight(TextBlock block, CategoryLabelPosition position, Graphics2D g2) {
        Insets insets = this.getTickLabelInsets();
        Size2D size = block.calculateDimensions(g2);
        Rectangle2D.Double box = new Rectangle2D.Double(0.0, 0.0, size.getWidth(), size.getHeight());
        Shape rotatedBox = ShapeUtils.rotateShape(box, position.getAngle(), 0.0f, 0.0f);
        double h = rotatedBox.getBounds2D().getHeight() + (double)insets.top + (double)insets.bottom;
        return h;
    }

    public Object clone() throws CloneNotSupportedException {
        Object clone = super.clone();
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CategoryAxis && super.equals(obj)) {
            CategoryAxis axis = (CategoryAxis)obj;
            boolean b0 = axis.lowerMargin == this.lowerMargin;
            boolean b1 = axis.upperMargin == this.upperMargin;
            boolean b2 = axis.categoryMargin == this.categoryMargin;
            boolean b3 = axis.maxCategoryLabelWidthRatio == this.maxCategoryLabelWidthRatio;
            boolean b4 = axis.categoryLabelPositionOffset == this.categoryLabelPositionOffset;
            boolean b5 = ObjectUtils.equal(axis.categoryLabelPositions, this.categoryLabelPositions);
            boolean b6 = ObjectUtils.equal(axis.categoryLabelToolTips, this.categoryLabelToolTips);
            return b0 && b1 && b2 && b3 && b4 && b5 && b6;
        }
        return false;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }

    public boolean isVerticalCategoryLabels() {
        return false;
    }

    public void setVerticalCategoryLabels(boolean flag) {
        this.categoryLabelPositions = flag ? CategoryLabelPositions.UP_90 : CategoryLabelPositions.STANDARD;
        this.notifyListeners(new AxisChangeEvent(this));
    }

    public boolean getSkipCategoryLabelsToFit() {
        return false;
    }

    public void setSkipCategoryLabelsToFit(boolean flag) {
    }

    public CategoryLabelPosition getTopCategoryLabelPosition() {
        return this.getCategoryLabelPositions().getLabelPosition(RectangleEdge.TOP);
    }

    public void setTopCategoryLabelPosition(CategoryLabelPosition position) {
        this.setCategoryLabelPositions(new CategoryLabelPositions(position, this.categoryLabelPositions.getLabelPosition(RectangleEdge.BOTTOM), this.categoryLabelPositions.getLabelPosition(RectangleEdge.LEFT), this.categoryLabelPositions.getLabelPosition(RectangleEdge.RIGHT)));
    }

    public CategoryLabelPosition getBottomCategoryLabelPosition() {
        return this.getCategoryLabelPositions().getLabelPosition(RectangleEdge.BOTTOM);
    }

    public void setBottomCategoryLabelPosition(CategoryLabelPosition position) {
        this.setCategoryLabelPositions(new CategoryLabelPositions(this.categoryLabelPositions.getLabelPosition(RectangleEdge.TOP), position, this.categoryLabelPositions.getLabelPosition(RectangleEdge.LEFT), this.categoryLabelPositions.getLabelPosition(RectangleEdge.RIGHT)));
    }

    public CategoryLabelPosition getLeftCategoryLabelPosition() {
        return this.getCategoryLabelPositions().getLabelPosition(RectangleEdge.LEFT);
    }

    public void setLeftCategoryLabelPosition(CategoryLabelPosition position) {
        this.setCategoryLabelPositions(new CategoryLabelPositions(this.categoryLabelPositions.getLabelPosition(RectangleEdge.TOP), this.categoryLabelPositions.getLabelPosition(RectangleEdge.BOTTOM), position, this.categoryLabelPositions.getLabelPosition(RectangleEdge.RIGHT)));
    }

    public CategoryLabelPosition getRightCategoryLabelPosition() {
        return this.getCategoryLabelPositions().getLabelPosition(RectangleEdge.RIGHT);
    }

    public void setRightCategoryLabelPosition(CategoryLabelPosition position) {
        this.setCategoryLabelPositions(new CategoryLabelPositions(this.categoryLabelPositions.getLabelPosition(RectangleEdge.TOP), this.categoryLabelPositions.getLabelPosition(RectangleEdge.BOTTOM), this.categoryLabelPositions.getLabelPosition(RectangleEdge.LEFT), position));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

