/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.services.binding;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.util.HashMap;
import javax.management.Attribute;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.metadata.MetaData;
import org.jboss.services.binding.ServiceBinding;
import org.jboss.services.binding.ServiceConfig;
import org.jboss.services.binding.ServicesConfigDelegate;
import org.jboss.util.Classes;
import org.jboss.util.StringPropertyReplacer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AttributeMappingDelegate
implements ServicesConfigDelegate {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$services$binding$AttributeMappingDelegate == null ? (class$org$jboss$services$binding$AttributeMappingDelegate = AttributeMappingDelegate.class$("org.jboss.services.binding.AttributeMappingDelegate")) : class$org$jboss$services$binding$AttributeMappingDelegate));
    static /* synthetic */ Class class$org$jboss$services$binding$AttributeMappingDelegate;

    public void applyConfig(ServiceConfig config, MBeanServer server) throws Exception {
        String hostAttrName;
        Element delegateConfig = (Element)config.getServiceConfigDelegateConfig();
        if (delegateConfig == null) {
            throw new IllegalArgumentException("ServiceConfig.ServiceConfigDelegateConfig is null");
        }
        String portAttrName = delegateConfig.getAttribute("portName");
        if (portAttrName.length() == 0) {
            portAttrName = null;
        }
        if ((hostAttrName = delegateConfig.getAttribute("hostName")).length() == 0) {
            hostAttrName = null;
        }
        NodeList attributes = delegateConfig.getElementsByTagName("attribute");
        ServiceBinding[] bindings = config.getBindings();
        if (bindings != null && bindings.length > 0) {
            ObjectName serviceName = new ObjectName(config.getServiceName());
            MBeanInfo info = server.getMBeanInfo(serviceName);
            MBeanAttributeInfo[] attrInfo = info.getAttributes();
            HashMap<String, String> attrTypeMap = new HashMap<String, String>();
            for (int a = 0; a < attrInfo.length; ++a) {
                MBeanAttributeInfo attr = attrInfo[a];
                attrTypeMap.put(attr.getName(), attr.getType());
            }
            int port = bindings[0].getPort();
            String host = bindings[0].getHostName();
            if (portAttrName != null) {
                Attribute portAttr = new Attribute(portAttrName, new Integer(port));
                log.debug((Object)("setPort, name='" + portAttrName + "' value=" + port));
                server.setAttribute(serviceName, portAttr);
            }
            if (hostAttrName != null) {
                Attribute hostAttr = this.createAtribute(port, host, attrTypeMap, hostAttrName, host);
                log.debug((Object)("setHost, name='" + hostAttrName + "' value=" + host));
                server.setAttribute(serviceName, hostAttr);
            }
            for (int a = 0; a < attributes.getLength(); ++a) {
                Element attr = (Element)attributes.item(a);
                String name = attr.getAttribute("name");
                if (name.length() == 0) {
                    throw new IllegalArgumentException("attribute element #" + a + " has no name attribute");
                }
                String attrExp = MetaData.getElementContent((Element)attr);
                Attribute theAttr = this.createAtribute(port, host, attrTypeMap, name, attrExp);
                server.setAttribute(serviceName, theAttr);
            }
        }
    }

    private Attribute createAtribute(int port, String host, HashMap attrTypeMap, String attrName, String attrExp) throws Exception {
        String attrText = this.replaceHostAndPort(attrExp, host, "" + port);
        String typeName = (String)attrTypeMap.get(attrName);
        if (typeName == null) {
            throw new DeploymentException("No such attribute: " + attrName);
        }
        Class attrType = Classes.loadClass((String)typeName);
        PropertyEditor editor = PropertyEditorManager.findEditor(attrType);
        if (editor == null) {
            String msg = "No property editor for attribute: " + attrName + "; type=" + typeName;
            throw new DeploymentException(msg);
        }
        editor.setAsText(attrText);
        Object attrValue = editor.getValue();
        log.debug((Object)("setAttribute, name='" + attrName + "', text=" + attrText + ", value=" + attrValue));
        Attribute theAttr = new Attribute(attrName, attrValue);
        return theAttr;
    }

    private String replaceHostAndPort(String text, String host, String port) {
        int index;
        if (text == null) {
            return null;
        }
        StringBuffer replacement = new StringBuffer(text);
        if (host == null) {
            host = "localhost";
        }
        String test = replacement.toString();
        while ((index = test.indexOf("${host}")) >= 0) {
            replacement.replace(index, index + 7, host);
            test = replacement.toString();
        }
        while ((index = test.indexOf("${port}")) >= 0) {
            replacement.replace(index, index + 7, port);
            test = replacement.toString();
        }
        return StringPropertyReplacer.replaceProperties((String)replacement.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

