/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservice.deployment;

import java.util.HashMap;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.webservice.deployment.BeanXMLMetaData;
import org.jboss.webservice.deployment.TypeMappingDescription;

public class MetaDataRegistry {
    private final Logger log = Logger.getLogger((Class)MetaDataRegistry.class);
    private HashMap typeMappingMetaData = new HashMap();

    public void registerTypeMappingMetaData(TypeMappingDescription typeMapping) {
        QName qname = typeMapping.getTypeQName();
        BeanXMLMetaData metaData = typeMapping.getMetaData();
        if (metaData == null) {
            throw new IllegalArgumentException("Cannot register null meta data");
        }
        if (!this.isTypeMappingMetaDataRegisterd(qname) || typeMapping.isUserDefined()) {
            this.log.debug((Object)("Register type mapping meta data for: " + qname));
            this.typeMappingMetaData.put(qname, metaData);
        } else {
            this.log.debug((Object)("Ignore register type mapping meta data for: " + qname));
        }
    }

    public BeanXMLMetaData getTypeMappingMetaData(QName typeName) {
        return (BeanXMLMetaData)this.typeMappingMetaData.get(typeName);
    }

    public boolean isTypeMappingMetaDataRegisterd(QName typeName) {
        return this.typeMappingMetaData.get(typeName) != null;
    }

    public void unregisterTypeMappingMetaData(QName typeName) {
        this.typeMappingMetaData.remove(typeName);
    }
}

