/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.axis.server;

import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import org.jboss.axis.AxisFault;
import org.jboss.axis.server.AxisServer;
import org.jboss.axis.server.DefaultAxisServerFactory;
import org.jboss.axis.utils.Messages;
import org.jboss.logging.Logger;

public class JNDIAxisServerFactory
extends DefaultAxisServerFactory {
    private static Logger log = Logger.getLogger((String)JNDIAxisServerFactory.class.getName());

    public AxisServer getServer(Map environment) throws AxisFault {
        String name;
        log.debug((Object)"Enter: JNDIAxisServerFactory::getServer");
        InitialContext context = null;
        try {
            context = new InitialContext();
        }
        catch (NamingException e) {
            log.warn((Object)Messages.getMessage("jndiNotFound00"), (Throwable)e);
        }
        ServletContext servletContext = null;
        try {
            servletContext = (ServletContext)environment.get("servletContext");
        }
        catch (ClassCastException e) {
            log.warn((Object)Messages.getMessage("servletContextWrongClass00"), (Throwable)e);
        }
        AxisServer server = null;
        if (context != null && servletContext != null && (name = servletContext.getRealPath("/WEB-INF/Server")) != null) {
            try {
                server = (AxisServer)context.lookup(name);
            }
            catch (NamingException e) {
                server = super.getServer(environment);
                try {
                    context.bind(name, (Object)server);
                }
                catch (NamingException e1) {
                    // empty catch block
                }
            }
        }
        if (server == null) {
            server = super.getServer(environment);
        }
        log.debug((Object)"Exit: JNDIAxisServerFactory::getServer");
        return server;
    }
}

