/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.console.remote;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import javax.management.MBeanServer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.console.remote.RemoteMBeanAttributeInvocation;
import org.jboss.console.remote.RemoteMBeanInvocation;
import org.jboss.invocation.InvocationException;
import org.jboss.invocation.MarshalledValue;
import org.jboss.logging.Logger;
import org.jboss.mx.util.JMXExceptionDecoder;
import org.jboss.mx.util.MBeanServerLocator;

public class InvokerServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$console$remote$InvokerServlet == null ? (class$org$jboss$console$remote$InvokerServlet = InvokerServlet.class$("org.jboss.console.remote.InvokerServlet")) : class$org$jboss$console$remote$InvokerServlet));
    private static String REQUEST_CONTENT_TYPE = "application/x-java-serialized-object; class=org.jboss.console.remote.RemoteMBeanInvocation";
    private static String RESPONSE_CONTENT_TYPE = "application/x-java-serialized-object; class=org.jboss.invocation.MarshalledValue";
    private MBeanServer mbeanServer;
    static /* synthetic */ Class class$org$jboss$console$remote$InvokerServlet;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.mbeanServer = MBeanServerLocator.locateJBoss();
        if (this.mbeanServer == null) {
            throw new ServletException("Failed to locate the MBeanServer");
        }
    }

    public void destroy() {
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)("processRequest, ContentLength: " + request.getContentLength()));
            log.trace((Object)("processRequest, ContentType: " + request.getContentType()));
        }
        try {
            Serializable invocation;
            response.setContentType(RESPONSE_CONTENT_TYPE);
            Object mi = request.getAttribute("RemoteMBeanInvocation");
            if (mi == null) {
                ServletInputStream sis = request.getInputStream();
                ObjectInputStream ois = new ObjectInputStream((InputStream)sis);
                mi = ois.readObject();
                ois.close();
            }
            Object value = null;
            if (mi instanceof RemoteMBeanInvocation) {
                invocation = (RemoteMBeanInvocation)mi;
                value = this.mbeanServer.invoke(invocation.targetObjectName, invocation.actionName, invocation.params, invocation.signature);
            } else {
                invocation = (RemoteMBeanAttributeInvocation)mi;
                value = this.mbeanServer.getAttribute(((RemoteMBeanAttributeInvocation)invocation).targetObjectName, ((RemoteMBeanAttributeInvocation)invocation).attributeName);
            }
            MarshalledValue mv = new MarshalledValue(value);
            ServletOutputStream sos = response.getOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)sos);
            oos.writeObject(mv);
            oos.close();
        }
        catch (Throwable t) {
            t = JMXExceptionDecoder.decode((Throwable)t);
            InvocationException appException = new InvocationException(t);
            log.debug((Object)"Invoke threw exception", t);
            response.resetBuffer();
            MarshalledValue mv = new MarshalledValue((Object)appException);
            ServletOutputStream sos = response.getOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream((OutputStream)sos);
            oos.writeObject(mv);
            oos.close();
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.processRequest(request, response);
    }

    public String getServletInfo() {
        return "An HTTP to JMX MBeanServer servlet";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

