/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.callback;

import java.lang.reflect.Method;
import org.hibernate.ejb.callback.BeanCallback;
import org.hibernate.ejb.callback.Callback;
import org.hibernate.ejb.callback.ListenerCallback;

public final class CallbackResolver {
    private CallbackResolver() {
    }

    public static Callback resolveCallback(Class beanClass, Class annotation, Class listener) throws Exception {
        Class<?>[] args;
        Class<?> returnType;
        int i;
        Callback callback = null;
        Method[] methods = beanClass.getDeclaredMethods();
        for (i = 0; i < methods.length; ++i) {
            if (methods[i].getAnnotation(annotation) == null) continue;
            if (callback == null) {
                callback = new BeanCallback(methods[i]);
                returnType = methods[i].getReturnType();
                args = methods[i].getParameterTypes();
                if (returnType != Void.TYPE && args.length != 0) {
                    throw new RuntimeException("Callback methods annotated on the bean class must return void and take no arguments: " + annotation.getName() + " - " + methods[i]);
                }
                if (methods[i].isAccessible()) continue;
                methods[i].setAccessible(true);
                continue;
            }
            throw new RuntimeException("You can only annotate one callback method with " + annotation.getName() + " in bean class: " + beanClass.getName());
        }
        if (listener != null) {
            try {
                methods = listener.getDeclaredMethods();
                for (i = 0; i < methods.length; ++i) {
                    if (methods[i].getAnnotation(annotation) == null) continue;
                    if (callback == null) {
                        callback = new ListenerCallback(methods[i], listener.newInstance());
                        returnType = methods[i].getReturnType();
                        args = methods[i].getParameterTypes();
                        if (returnType != Void.TYPE && args.length != 0) {
                            throw new RuntimeException("Callback methods annotated in a listener bean class must return void and take one argument: " + annotation.getName() + " - " + methods[i]);
                        }
                        if (methods[i].isAccessible()) continue;
                        methods[i].setAccessible(true);
                        continue;
                    }
                    throw new RuntimeException("You can only annotate one callback method with " + annotation.getName() + " in bean class: " + beanClass.getName() + " and callback listener: " + listener.getName());
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getCause());
            }
        }
        return callback;
    }
}

