/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.registry.InvalidRequestException;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import javax.xml.registry.infomodel.SpecificationLink;
import org.apache.ws.scout.registry.infomodel.RegistryObjectImpl;
import org.apache.ws.scout.registry.infomodel.SpecificationLinkImpl;

public class ServiceBindingImpl
extends RegistryObjectImpl
implements ServiceBinding {
    private Collection links = null;
    private String accessuri = null;
    private Service service = null;
    private ServiceBinding targetbinding = null;
    private boolean validateuri = false;

    public ServiceBindingImpl(LifeCycleManager lifeCycleManager) {
        super(lifeCycleManager);
    }

    public ServiceBindingImpl(LifeCycleManager lifeCycleManager, InternationalString n) {
        super(lifeCycleManager, n);
    }

    public void addSpecificationLink(SpecificationLink sl) throws JAXRException {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        this.links.add(sl);
        ((SpecificationLinkImpl)sl).setServiceBinding(this);
    }

    public void addSpecificationLinks(Collection col) throws JAXRException {
        try {
            if (this.links == null) {
                this.links = new ArrayList();
            }
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                this.addSpecificationLink((SpecificationLink)iter.next());
            }
        }
        catch (ClassCastException e) {
            throw new UnexpectedObjectException();
        }
    }

    public String getAccessURI() throws JAXRException {
        return this.accessuri;
    }

    public Service getService() throws JAXRException {
        return this.service;
    }

    public Collection getSpecificationLinks() throws JAXRException {
        return this.links;
    }

    public ServiceBinding getTargetBinding() throws JAXRException {
        return this.targetbinding;
    }

    public void removeSpecificationLink(SpecificationLink link) throws JAXRException {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        this.links.remove(link);
    }

    public void removeSpecificationLinks(Collection col) throws JAXRException {
        if (this.links == null) {
            this.links = new ArrayList();
        }
        this.links.removeAll(col);
    }

    public void setAccessURI(String s) throws JAXRException {
        if (this.targetbinding != null) {
            throw new InvalidRequestException("There is already a Target Binding defined");
        }
        this.accessuri = s;
    }

    public void setTargetBinding(ServiceBinding sb) throws JAXRException {
        if (this.accessuri != null) {
            throw new InvalidRequestException("There is already an Access URI defined");
        }
        this.targetbinding = sb;
    }

    public boolean getValidateURI() throws JAXRException {
        return this.validateuri;
    }

    public void setValidateURI(boolean b) throws JAXRException {
        this.validateuri = b;
    }

    public void setService(Service s) {
        this.service = s;
    }
}

