/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.collectiverun.factory;

import com.clustercontrol.collectiverun.bean.CommandInfo;
import com.clustercontrol.collectiverun.bean.CommandParameterInfo;
import com.clustercontrol.collectiverun.bean.EndStatusInfo;
import com.clustercontrol.collectiverun.bean.ItemConstant;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.ParameterInfo;
import com.clustercontrol.collectiverun.bean.ParameterSelectInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.bean.TypeInfo;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstUtil;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectMaster {
    protected static Log m_log = LogFactory.getLog(SelectMaster.class);

    public TreeItem getTree(Locale locale) throws FinderException, NamingException {
        ItemInfo info = new ItemInfo();
        info.setName("");
        info.setType(-1);
        info.setOrderNo(0);
        TreeItem tree = new TreeItem(null, info);
        info = new ItemInfo();
        info.setName(ItemConstant.STRING_COMMADN_COMPOSITE);
        info.setType(-2);
        info.setOrderNo(0);
        TreeItem cmdTree = new TreeItem(tree, info);
        Collection collection = CRunTypeMstUtil.getLocalHome().findAll();
        if (collection != null) {
            for (CRunTypeMstLocal type : collection) {
                this.createTypeTree(type, cmdTree, locale);
            }
        }
        info = new ItemInfo();
        info.setName(ItemConstant.STRING_PARAMETER_COMPOSITE);
        info.setType(-3);
        info.setOrderNo(1);
        TreeItem paramTree = new TreeItem(tree, info);
        collection = CRunParamMstUtil.getLocalHome().findAll();
        if (collection != null) {
            for (CRunParamMstLocal param : collection) {
                this.createParamTree(param, paramTree, locale);
            }
        }
        return tree;
    }

    protected void createTypeTree(CRunTypeMstLocal type, TreeItem parent, Locale locale) {
        TypeInfo info = new TypeInfo();
        info.setId(type.getType_id());
        info.setName(Messages.getString((String)type.getName_id(), (Locale)locale));
        info.setType(0);
        info.setOrderNo(type.getOrder_no().intValue());
        TreeItem item = new TreeItem(parent, (ItemInfo)info);
        Collection collection = type.getCmdMst();
        if (collection != null && collection.size() > 0) {
            for (CRunCmdMstLocal cmd : collection) {
                this.createCommandTree(cmd, item, locale);
            }
        }
    }

    protected void createCommandTree(CRunCmdMstLocal cmd, TreeItem parent, Locale locale) {
        CommandInfo info = new CommandInfo();
        info.setId(cmd.getCommand_id());
        info.setName(Messages.getString((String)cmd.getName_id(), (Locale)locale));
        info.setType(1);
        info.setOrderNo(cmd.getOrder_no().intValue());
        info.setCommand(cmd.getCommand());
        info.setCommandType(cmd.getCommand_type().intValue());
        ArrayList<EndStatusInfo> list = new ArrayList<EndStatusInfo>();
        Collection collection = cmd.getEndMst();
        if (collection != null && collection.size() > 0) {
            for (CRunEndMstLocal endStatus : collection) {
                EndStatusInfo endStatusInfo = new EndStatusInfo();
                endStatusInfo.setEndStatus(endStatus.getEnd_status().intValue());
                endStatusInfo.setStartRangeValue(endStatus.getEnd_value_from().intValue());
                endStatusInfo.setEndRangeValue(endStatus.getEnd_value_to().intValue());
                list.add(endStatusInfo);
            }
        }
        info.setEndStatus(list);
        TreeItem item = new TreeItem(parent, (ItemInfo)info);
        collection = cmd.getCmdParamMst();
        if (collection != null && collection.size() > 0) {
            for (CRunCmdParamMstLocal param : collection) {
                this.createCommandParameterTree(param, item, locale);
            }
        }
    }

    protected void createCommandParameterTree(CRunCmdParamMstLocal cmdParam, TreeItem parent, Locale locale) {
        CommandParameterInfo info = new CommandParameterInfo();
        info.setId(cmdParam.getParam_id());
        CRunParamMstLocal param = cmdParam.getParamMst();
        info.setName(Messages.getString((String)param.getName_id(), (Locale)locale));
        info.setPrefix(cmdParam.getParam_prefix());
        info.setOrderNo(cmdParam.getOrder_no().intValue());
        info.setType(2);
        new TreeItem(parent, (ItemInfo)info);
    }

    protected void createParamTree(CRunParamMstLocal param, TreeItem parent, Locale locale) {
        ParameterInfo info = new ParameterInfo();
        info.setId(param.getParam_id());
        info.setName(Messages.getString((String)param.getName_id(), (Locale)locale));
        info.setType(3);
        info.setParamType(param.getParam_type().intValue());
        TreeItem item = new TreeItem(parent, (ItemInfo)info);
        Collection collection = param.getParamSelectMst();
        if (collection != null && collection.size() > 0) {
            for (CRunParamSelectMstLocal select : collection) {
                this.createParamSelectTree(select, item, locale);
            }
        }
    }

    protected void createParamSelectTree(CRunParamSelectMstLocal select, TreeItem parent, Locale locale) {
        ParameterSelectInfo info = new ParameterSelectInfo();
        info.setId(select.getParam_id());
        info.setName(Messages.getString((String)select.getName_id(), (Locale)locale));
        info.setType(4);
        info.setOrderNo(select.getOrder_no().intValue());
        info.setValue(select.getParam_value());
        new TreeItem(parent, (ItemInfo)info);
    }

    public static String typeIdToString(String typeId, Locale locale) {
        String string = null;
        CRunTypeMstLocal type = null;
        try {
            type = CRunTypeMstUtil.getLocalHome().findByPrimaryKey(typeId);
        }
        catch (FinderException e) {
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (type != null) {
            string = Messages.getString((String)type.getName_id(), (Locale)locale);
        }
        return string;
    }

    public static String stringToTypeId(String string, Locale locale) {
        Collection collection = null;
        try {
            collection = CRunTypeMstUtil.getLocalHome().findAll();
        }
        catch (FinderException e) {
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (collection != null) {
            for (CRunTypeMstLocal type : collection) {
                String name = Messages.getString((String)type.getName_id(), (Locale)locale);
                if (!name.equals(string)) continue;
                return type.getType_id();
            }
        }
        return null;
    }

    public static List<String> getTypeStringList(Locale locale) {
        ArrayList<String> list = new ArrayList<String>();
        Collection collection = null;
        try {
            collection = CRunTypeMstUtil.getLocalHome().findAllSortOrderNo();
        }
        catch (FinderException e) {
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (collection != null) {
            for (CRunTypeMstLocal type : collection) {
                String name = Messages.getString((String)type.getName_id(), (Locale)locale);
                list.add(name);
            }
        }
        return list;
    }

    public static HashMap<String, String> getTypeHashMap(Locale locale) {
        HashMap<String, String> map = new HashMap<String, String>();
        Collection collection = null;
        try {
            collection = CRunTypeMstUtil.getLocalHome().findAll();
        }
        catch (FinderException e) {
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (collection != null) {
            for (CRunTypeMstLocal type : collection) {
                map.put(type.getType_id(), Messages.getString((String)type.getName_id(), (Locale)locale));
                map.put(Messages.getString((String)type.getName_id(), (Locale)locale), type.getType_id());
            }
        }
        return map;
    }
}

