/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.preference;

import com.clustercontrol.jobmanagement.ui.JobManagementUIPlugin;
import com.clustercontrol.jobmanagement.view.JobHistoryView;
import com.clustercontrol.util.Messages;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;

public class JobManagementPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String P_HISTORY_UPDATE_FLG = "historyUpdateFlg";
    public static final String P_HISTORY_UPDATE_CYCLE = "historyUpdateCycle";
    public static final String P_HISTORY_MESSAGE_FLG = "historyMessageFlg";
    public static final String P_HISTORY_MAX_HISTORIES = "historyMaxHistories";

    public JobManagementPreferencePage() {
        super(1);
        this.setPreferenceStore(JobManagementUIPlugin.getDefault().getPreferenceStore());
        this.initializeDefaults();
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setDefault(P_HISTORY_UPDATE_FLG, true);
        store.setDefault(P_HISTORY_UPDATE_CYCLE, 10);
        store.setDefault(P_HISTORY_MESSAGE_FLG, true);
        store.setDefault(P_HISTORY_MAX_HISTORIES, 500);
    }

    public void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        GridData gridData = null;
        Group group = new Group(parent, 32);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 10;
        gridData.verticalSpan = 10;
        group.setLayoutData((Object)gridData);
        group.setText(Messages.getString((String)"view.job.history"));
        this.addField((FieldEditor)new BooleanFieldEditor(P_HISTORY_UPDATE_FLG, Messages.getString((String)"autoupdate.enable"), (Composite)group));
        this.addField((FieldEditor)new IntegerFieldEditor(P_HISTORY_UPDATE_CYCLE, String.valueOf(Messages.getString((String)"autoupdate.cycle")) + " : ", (Composite)group));
        this.addField((FieldEditor)new BooleanFieldEditor(P_HISTORY_MESSAGE_FLG, Messages.getString((String)"over.limit.message"), (Composite)group));
        this.addField((FieldEditor)new IntegerFieldEditor(P_HISTORY_MAX_HISTORIES, String.valueOf(Messages.getString((String)"number.of.display.histories")) + " : ", (Composite)group));
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.applySetting();
        return result;
    }

    protected void applySetting() {
        IPreferenceStore store = this.getPreferenceStore();
        IWorkbench workbench = JobManagementUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow[] windows = workbench.getWorkbenchWindows();
        int windowCount = windows.length;
        int i = 0;
        while (i < windowCount) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int pageCount = pages.length;
            int j = 0;
            while (j < pageCount) {
                JobHistoryView view = (JobHistoryView)pages[j].findView("com.clustercontrol.jobmanagement.view.JobHistoryView");
                if (view != null) {
                    int cycle = store.getInt(P_HISTORY_UPDATE_CYCLE);
                    view.setInterval(cycle);
                    if (store.getBoolean(P_HISTORY_UPDATE_FLG)) {
                        view.startAutoReload();
                    } else {
                        view.stopAutoReload();
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void init(IWorkbench workbench) {
    }
}

