/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.accesscontrol.util;

import com.clustercontrol.util.apllog.AplLogger;
import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.ldap.InitialLdapContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

public class LdapConnectionManager {
    protected static Log m_log = LogFactory.getLog(LdapConnectionManager.class);
    private static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
    private static final String OBJECT_NAME = "user:name=TroubleDetection,service=TroubleDetectionService";
    private static final String OPERATION_NAME = "putMessage";
    private static final int PROVIDER_CONNECT_INTERVAL = 60000;
    private static final int RECONNECT_MAX = 5;
    private static boolean m_provider = true;
    private static boolean m_consumer = false;
    private static long m_conenctTime = System.currentTimeMillis();
    private static String m_outputLog = "";
    private static LdapConnectionManager m_instance = null;

    public static LdapConnectionManager getConnectionManager() {
        if (m_instance == null) {
            m_instance = new LdapConnectionManager();
        }
        return m_instance;
    }

    private LdapConnectionManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DirContext getDirContext() {
        DirContext ctx;
        boolean consumer;
        boolean provider;
        block19: {
            provider = false;
            consumer = false;
            LdapConnectionManager ldapConnectionManager = this;
            synchronized (ldapConnectionManager) {
                long diff = System.currentTimeMillis() - m_conenctTime;
                if (diff >= 60000L) {
                    provider = true;
                    m_conenctTime = System.currentTimeMillis();
                    m_log.debug((Object)"getDirContext() : LDAP ReConnect");
                } else {
                    provider = m_provider;
                }
                consumer = m_consumer;
            }
            ctx = null;
            try {
                if (!provider) {
                    throw new NamingException();
                }
                ctx = this.getDirContext("external/hinemos/ldap/provider");
                if (consumer) {
                    this.outputLog("LDAP03", "001");
                }
                provider = true;
                consumer = false;
            }
            catch (NamingException e) {
                try {
                    ctx = this.getDirContext("external/hinemos/ldap/consumer");
                }
                catch (NamingException e1) {
                    // empty catch block
                }
                if (ctx == null) break block19;
                if (provider && !consumer) {
                    this.outputLog("LDAP02", "001");
                }
                provider = false;
                consumer = true;
            }
        }
        if (ctx == null) {
            AplLogger apllog = new AplLogger("REP", "rep");
            apllog.put("SYS", "001");
            if (provider) {
                this.outputLog("LDAP02", "002");
            } else {
                this.outputLog("LDAP03", "002");
            }
            provider = false;
            consumer = false;
        } else {
            m_log.debug((Object)"getDirContext() : Get LDAP Connection");
        }
        LdapConnectionManager ldapConnectionManager = this;
        synchronized (ldapConnectionManager) {
            m_provider = provider;
            m_consumer = consumer;
        }
        return ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DirContext getDirContext(String jndiName) throws NamingException {
        InitialLdapContext ctx = null;
        for (int i = 0; i < 5; ++i) {
            TimeKeeper timer = new TimeKeeper(3000L);
            try {
                m_log.debug((Object)("getDirContext() : LDAP Connect " + jndiName));
                InitialContext iniCtx = new InitialContext();
                ctx = (InitialLdapContext)iniCtx.lookup(jndiName);
                if (ctx == null) continue;
                break;
            }
            catch (NamingException e) {
                m_log.debug((Object)("getDirContext() : LDAP Connection Error " + jndiName + " : " + e.getMessage()));
                continue;
            }
            finally {
                timer.setLdapResponse(true);
                Thread.currentThread();
                Thread.interrupted();
            }
        }
        if (ctx == null) {
            throw new NamingException();
        }
        return ctx;
    }

    public void setDirContext(DirContext ctx) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputLog(String monitorId, String messageId) {
        String string = m_outputLog;
        synchronized (string) {
            String outputLog = monitorId + messageId;
            if (outputLog.equals("LDAP02002")) {
                m_outputLog = outputLog;
            } else if (outputLog.equals("LDAP03002")) {
                m_outputLog = outputLog;
            } else if (outputLog.equals(m_outputLog)) {
                return;
            }
        }
        try {
            InitialContext ic = new InitialContext();
            RMIAdaptor server = (RMIAdaptor)ic.lookup(LOOKUP_NAME);
            ObjectName name = new ObjectName(OBJECT_NAME);
            Object[] args = new Object[]{monitorId, messageId};
            String[] signature = new String[]{String.class.getName(), String.class.getName()};
            server.invoke(name, OPERATION_NAME, args, signature);
        }
        catch (NamingException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (MalformedObjectNameException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (NullPointerException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (InstanceNotFoundException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (MBeanException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (ReflectionException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
        catch (IOException e) {
            m_log.debug((Object)("outputLog() : " + e.getMessage()));
        }
    }

    class TimeKeeper
    extends Thread {
        long timeout;
        long timerStart;
        boolean ldapResponse = false;
        Thread parent = Thread.currentThread();

        TimeKeeper(long timout) {
            this.timeout = timout;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.timerStart = System.currentTimeMillis();
            long waitTime = this.timeout;
            while (waitTime > 0L) {
                try {
                    TimeKeeper.sleep(waitTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                waitTime = this.timeout - (System.currentTimeMillis() - this.timerStart);
            }
            TimeKeeper timeKeeper = this;
            synchronized (timeKeeper) {
                if (!this.isLdapResponse()) {
                    this.parent.interrupt();
                }
            }
        }

        public boolean isLdapResponse() {
            return this.ldapResponse;
        }

        public synchronized void setLdapResponse(boolean ldapResponse) {
            this.ldapResponse = ldapResponse;
        }
    }
}

