/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.factory;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.util.QuartzUtil;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;
import java.rmi.RemoteException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.CronTrigger;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.jobs.ee.ejb.EJBInvokerJob;

public class ModifySchedule {
    protected static Log m_log = LogFactory.getLog(ModifySchedule.class);

    public void addSchedule(MonitorInfo info, String jndiName, Calendar schedule) throws ParseException, NamingException, SchedulerException {
        String monitorId = info.getMonitorId();
        String monitorTypeId = info.getMonitorTypeId();
        JobDetail job = new JobDetail(monitorId, monitorTypeId, EJBInvokerJob.class);
        job.setDurability(true);
        job.setRequestsRecovery(true);
        job.getJobDataMap().put("ejb", jndiName);
        job.getJobDataMap().put("method", "run");
        String serverName = System.getProperty("jboss.server.name");
        if (serverName.equals("all")) {
            job.getJobDataMap().put("java.naming.provider.url", "jnp://localhost:1100");
        }
        Object[] jdArgs = new Object[3];
        Class[] jdArgsType = new Class[3];
        jdArgs[0] = monitorTypeId;
        job.getJobDataMap().put((Object)"args", (Object)jdArgs);
        jdArgsType[0] = String.class;
        job.getJobDataMap().put((Object)"argTypes", (Object)jdArgsType);
        jdArgs[1] = monitorId;
        job.getJobDataMap().put((Object)"args", (Object)jdArgs);
        jdArgsType[1] = String.class;
        job.getJobDataMap().put((Object)"argTypes", (Object)jdArgsType);
        jdArgs[2] = info.getMonitorType();
        job.getJobDataMap().put((Object)"args", (Object)jdArgs);
        jdArgsType[2] = Integer.class;
        job.getJobDataMap().put((Object)"argTypes", (Object)jdArgsType);
        if (info.getValid() == 1) {
            job.getJobDataMap().put((Object)"valid", (Object)new Integer(1));
        } else {
            job.getJobDataMap().put((Object)"valid", (Object)new Integer(0));
        }
        CronTrigger trigger = null;
        if (schedule == null) {
            int interval = info.getRunInterval();
            trigger = new SimpleTrigger(monitorId, monitorTypeId, new Date(), new Date(Long.MAX_VALUE), SimpleTrigger.REPEAT_INDEFINITELY, (long)(interval * 1000));
        } else {
            trigger = new CronTrigger(monitorId, monitorTypeId);
            trigger.setCronExpression(this.getCronString(schedule));
        }
        QuartzManager manager = QuartzUtil.getQuartzManager();
        try {
            manager.addSchedule(job, (Trigger)trigger);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        if (info.getValid() == 0) {
            try {
                manager.pauseSchedule(job.getName(), monitorTypeId);
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    public void modifySchedule(MonitorInfo info, Calendar schedule) throws NamingException, SchedulerException, ParseException {
        String monitorId = info.getMonitorId();
        String monitorTypeId = info.getMonitorTypeId();
        QuartzManager manager = QuartzUtil.getQuartzManager();
        JobDetail job = null;
        try {
            job = manager.getJobDetail(monitorId, monitorTypeId);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        job.setDurability(true);
        job.setRequestsRecovery(true);
        Object[] jdArgs = new Object[3];
        Class[] jdArgsType = new Class[3];
        jdArgs[0] = monitorTypeId;
        job.getJobDataMap().put((Object)"args", (Object)jdArgs);
        jdArgsType[0] = String.class;
        job.getJobDataMap().put((Object)"argTypes", (Object)jdArgsType);
        jdArgs[1] = monitorId;
        job.getJobDataMap().put((Object)"args", (Object)jdArgs);
        jdArgsType[1] = String.class;
        job.getJobDataMap().put((Object)"argTypes", (Object)jdArgsType);
        jdArgs[2] = info.getMonitorType();
        job.getJobDataMap().put((Object)"args", (Object)jdArgs);
        jdArgsType[2] = Integer.class;
        job.getJobDataMap().put((Object)"argTypes", (Object)jdArgsType);
        if (info.getValid() == 1) {
            job.getJobDataMap().put((Object)"valid", (Object)new Integer(1));
        } else {
            job.getJobDataMap().put((Object)"valid", (Object)new Integer(0));
        }
        CronTrigger trigger = null;
        if (schedule == null) {
            int interval = info.getRunInterval();
            trigger = new SimpleTrigger(monitorId, monitorTypeId, new Date(), new Date(Long.MAX_VALUE), SimpleTrigger.REPEAT_INDEFINITELY, (long)(interval * 1000));
        } else {
            trigger = new CronTrigger(monitorId, monitorTypeId);
            trigger.setCronExpression(this.getCronString(schedule));
        }
        this.deleteSchedule(monitorTypeId, monitorId);
        try {
            manager.addSchedule(job, (Trigger)trigger);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        if (info.getValid() == 0) {
            try {
                manager.pauseSchedule(job.getName(), job.getGroup());
            }
            catch (RemoteException e) {
                // empty catch block
            }
        }
    }

    public void deleteSchedule(String monitorTypeId, String monitorId) throws NamingException, SchedulerException {
        m_log.debug((Object)("deleteSchedule() : type =" + monitorTypeId + ", id=" + monitorId));
        QuartzManager manager = QuartzUtil.getQuartzManager();
        try {
            manager.deleteSchedule(monitorId, monitorTypeId);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    protected String getCronString(Calendar schedule) {
        m_log.debug((Object)"getCronString()");
        if (schedule != null) {
            StringBuffer cron = new StringBuffer();
            if (schedule.get(11) > 0) {
                cron.append(schedule.get(13));
                cron.append(" ");
                cron.append(schedule.get(12));
                cron.append(" ");
                cron.append("*/" + schedule.get(11));
                cron.append(" * * ? *");
            } else if (schedule.get(12) > 0) {
                cron.append(schedule.get(13));
                cron.append(" ");
                cron.append("*/" + schedule.get(12));
                cron.append(" * * * ? *");
            } else {
                cron.append("*/" + schedule.get(13));
                cron.append(" * * * * ? *");
            }
            return cron.toString();
        }
        return null;
    }
}

