/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.monitor.run.composite;

import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.monitor.run.composite.StringValueListTableViewer;
import com.clustercontrol.monitor.run.util.StringValueInfoManager;
import com.clustercontrol.util.Messages;
import java.util.ArrayList;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class StringValueListComposite
extends Composite {
    private StringValueListTableViewer m_tableViewer = null;
    private ArrayList m_tableDefine = null;
    private boolean m_notify = false;

    public StringValueListComposite(Composite parent, int style) {
        super(parent, style);
        this.initialize();
    }

    public StringValueListComposite(Composite parent, int style, ArrayList tableDefine) {
        super(parent, style);
        this.m_tableDefine = tableDefine;
        this.initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        Table table = new Table((Composite)this, 66308);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData((Object)gridData);
        this.m_tableViewer = new StringValueListTableViewer(table);
        this.m_tableViewer.createTableColumn(this.m_tableDefine);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
    }

    public StringValueListTableViewer getTableViewer() {
        return this.m_tableViewer;
    }

    public MonitorStringValueInfo getFilterItem() {
        StructuredSelection selection = (StructuredSelection)this.m_tableViewer.getSelection();
        if (selection == null) {
            return null;
        }
        return (MonitorStringValueInfo)selection.getFirstElement();
    }

    public void setInputData(MonitorInfo monitorInfo) {
        if (monitorInfo != null) {
            StringValueInfoManager.getInstance().initialize(monitorInfo);
            Object[] list = StringValueInfoManager.getInstance().get();
            this.m_tableViewer.setInput(list);
        }
    }

    public void update() {
        Object[] list = StringValueInfoManager.getInstance().get();
        this.m_tableViewer.setInput(list);
    }

    public ValidateResult createInputData(MonitorInfo monitorInfo) {
        this.m_notify = false;
        ArrayList list = StringValueInfoManager.getInstance().getMonitorStringValueInfo();
        if (list != null && list.size() > 0) {
            String MonitorTypeId = monitorInfo.getMonitorTypeId();
            String MonitorId = monitorInfo.getMonitorId();
            int index = 0;
            while (index < list.size()) {
                MonitorStringValueInfo info = (MonitorStringValueInfo)list.get(index);
                info.setMonitorTypeId(MonitorTypeId);
                info.setMonitorId(MonitorId);
                if (info.getNotifyId() != null && !"".equals(info.getNotifyId()) && info.getProcessType() == 1) {
                    this.m_notify = true;
                }
                ++index;
            }
        } else {
            return this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.monitor.32"));
        }
        monitorInfo.setJudgementInfo(list);
        return null;
    }

    protected ValidateResult setValidateResult(String id, String message) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        return validateResult;
    }

    public boolean isNotify() {
        return this.m_notify;
    }
}

