/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.logtransfer.dialog;

import com.clustercontrol.bean.FacilityInfo;
import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ScopeTreeDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.logtransfer.action.GetLogTransfer;
import com.clustercontrol.logtransfer.bean.LogTransferInfo;
import com.clustercontrol.logtransfer.composite.LogTransferFileListComposite;
import com.clustercontrol.ui.ClusterControlUIPlugin;
import com.clustercontrol.util.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class LogTransferCreateDialog
extends CommonDialog {
    public static final int WIDTH_TITLE = 3;
    public static final int WIDTH_VALUE = 8;
    private LogTransferInfo m_inputData = null;
    private ValidateResult m_validateResult = null;
    private String m_transferId = null;
    private Text m_textTransferId = null;
    private Text m_textDescription = null;
    protected Text m_textScope = null;
    protected Button m_buttonScope = null;
    protected String m_facilityId = null;
    LogTransferFileListComposite m_fileList = null;
    private Button m_valid = null;

    public LogTransferCreateDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    public LogTransferCreateDialog(Shell parent, String transferId) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.m_transferId = transferId;
    }

    protected Point getInitialSize() {
        return new Point(700, 500);
    }

    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();
        shell.setText(Messages.getString((String)"dialog.logtransfer.create.modify"));
        Label label = null;
        GridData gridData = null;
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout((Layout)layout);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"logtransfer.id")) + " : ");
        this.m_textTransferId = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textTransferId.setLayoutData((Object)gridData);
        if (this.m_transferId != null && !"".equals(this.m_transferId.trim())) {
            this.m_textTransferId.setEnabled(false);
        }
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"description")) + " : ");
        this.m_textDescription = new Text(parent, 18432);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textDescription.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        label.setText(String.valueOf(Messages.getString((String)"scope")) + " : ");
        this.m_textScope = new Text(parent, 18440);
        gridData = new GridData();
        gridData.horizontalSpan = 6;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textScope.setLayoutData((Object)gridData);
        this.m_buttonScope = new Button(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_buttonScope.setLayoutData((Object)gridData);
        this.m_buttonScope.setText(Messages.getString((String)"refer"));
        this.m_buttonScope.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ScopeTreeDialog dialog = new ScopeTreeDialog(shell);
                if (dialog.open() == 0) {
                    FacilityTreeItem item = dialog.getSelectItem();
                    FacilityInfo info = item.getData();
                    LogTransferCreateDialog.this.m_facilityId = info.getFacilityId();
                    if (info.getType() == 1) {
                        LogTransferCreateDialog.this.m_textScope.setText(info.getFacilityName());
                    } else {
                        FacilityPath path = new FacilityPath(ClusterControlUIPlugin.getDefault().getSeparator());
                        LogTransferCreateDialog.this.m_textScope.setText(path.getPath(item));
                    }
                }
            }
        });
        label = new Label(parent, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)gridData);
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 15;
        composite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)gridData);
        this.m_fileList = new LogTransferFileListComposite(composite, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        this.m_fileList.setLayoutData(gridData);
        this.m_valid = new Button(parent, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.m_valid.setLayoutData((Object)gridData);
        this.m_valid.setText(Messages.getString((String)"setting.valid.confirmed"));
        Label line = new Label(parent, 258);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        line.setLayoutData((Object)gridData);
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2, (display.getBounds().height - shell.getSize().y) / 2);
        LogTransferInfo info = null;
        info = this.m_transferId != null ? new GetLogTransfer().getLogTransfer(this.m_transferId) : new LogTransferInfo();
        this.setInputData(info);
    }

    public LogTransferInfo getInputData() {
        return this.m_inputData;
    }

    protected void setInputData(LogTransferInfo info) {
        this.m_inputData = info;
        if (info.getTransferId() != null) {
            this.m_textTransferId.setText(info.getTransferId());
            this.m_textTransferId.setEnabled(false);
        }
        if (info.getDescription() != null) {
            this.m_textDescription.setText(info.getDescription());
        }
        if (info.getScope() != null) {
            this.m_textScope.setText(info.getScope());
        }
        if (info.getFacilityId() != null) {
            this.m_facilityId = info.getFacilityId();
        }
        if (info.getFileInfo() != null) {
            this.m_fileList.setInputData(info);
        }
        if (info.getValid() == 1) {
            this.m_valid.setSelection(true);
        }
    }

    protected LogTransferInfo createInputData() {
        LogTransferInfo info = new LogTransferInfo();
        if (this.m_textTransferId.getText() == null || "".equals(this.m_textTransferId.getText().trim())) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.logtransfer.8"));
            return null;
        }
        info.setTransferId(this.m_textTransferId.getText());
        if (this.m_textDescription.getText() != null && !"".equals(this.m_textDescription.getText().trim())) {
            info.setDescription(this.m_textDescription.getText());
        }
        if (this.m_textScope.getText() == null || "".equals(this.m_textScope.getText().trim())) {
            this.setValidateResult(Messages.getString((String)"message.hinemos.1"), Messages.getString((String)"message.logtransfer.10"));
            return null;
        }
        info.setFacilityId(this.m_facilityId);
        this.m_validateResult = this.m_fileList.createInputData(info);
        if (this.m_validateResult != null) {
            return null;
        }
        if (this.m_valid.getSelection()) {
            info.setValid(1);
        } else {
            info.setValid(0);
        }
        return info;
    }

    protected ValidateResult validate() {
        this.m_inputData = this.createInputData();
        if (this.m_inputData != null) {
            return super.validate();
        }
        return this.m_validateResult;
    }

    protected String getOkButtonText() {
        return Messages.getString((String)"ok");
    }

    protected String getCancelButtonText() {
        return Messages.getString((String)"cancel");
    }

    private void setValidateResult(String id, String message) {
        this.m_validateResult = new ValidateResult();
        this.m_validateResult.setValid(false);
        this.m_validateResult.setID(id);
        this.m_validateResult.setMessage(message);
    }
}

