/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.jobmanagement.factory;

import com.clustercontrol.bean.CommonTableTreeItem;
import com.clustercontrol.calendar.factory.SelectCalendar;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobStartMasterLocal;
import com.clustercontrol.jobmanagement.util.QuartzUtil;
import com.clustercontrol.quartzmanager.ejb.session.QuartzManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import javax.ejb.FinderException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.SchedulerException;

public class SelectRunSchedule {
    protected static Log m_log = LogFactory.getLog(SelectRunSchedule.class);

    public ArrayList getList() throws NamingException, SchedulerException {
        m_log.debug((Object)"getList()");
        ArrayList list = new ArrayList();
        QuartzManager manager = QuartzUtil.getQuartzManager();
        String[] jobs = null;
        try {
            jobs = manager.getJobs("JOB");
        }
        catch (RemoteException e) {
            // empty catch block
        }
        for (int i = 0; i < jobs.length; ++i) {
            JobDetail job = null;
            try {
                job = manager.getJobDetail(jobs[i], "JOB");
            }
            catch (RemoteException e) {
                // empty catch block
            }
            ArrayList<Object> info = new ArrayList<Object>();
            info.add(job.getName());
            info.add(job.getDescription());
            Object[] jdArgs = (Object[])job.getJobDataMap().get((Object)"args");
            info.add((String)jdArgs[0]);
            String jobName = (String)job.getJobDataMap().get((Object)"jobName");
            info.add(jobName);
            if (jdArgs.length > 1) {
                info.add((String)jdArgs[1]);
            } else {
                info.add("");
            }
            info.add(new Boolean(true));
            list.add(info);
        }
        return list;
    }

    public ArrayList getSchedule(Date base) throws NamingException, SchedulerException, FinderException {
        m_log.debug((Object)"getSchedule()");
        ArrayList list = new ArrayList();
        SelectCalendar selectCalendar = new SelectCalendar();
        QuartzManager manager = QuartzUtil.getQuartzManager();
        String[] jobs = null;
        try {
            jobs = manager.getJobs("JOB");
        }
        catch (RemoteException e) {
            // empty catch block
        }
        for (int i = 0; i < jobs.length; ++i) {
            JobDetail job = null;
            try {
                job = manager.getJobDetail(jobs[i], "JOB");
            }
            catch (RemoteException e) {
                // empty catch block
            }
            ArrayList<Object> info = new ArrayList<Object>();
            info.add(job.getName());
            Object[] jdArgs = (Object[])job.getJobDataMap().get((Object)"args");
            String calendarId = null;
            if (jdArgs.length > 1) {
                calendarId = (String)jdArgs[1];
            }
            for (int j = 0; j < 28; ++j) {
                Calendar baseCalendar = Calendar.getInstance();
                baseCalendar.setTime(base);
                baseCalendar.add(5, j);
                Date work = baseCalendar.getTime();
                if (calendarId != null && calendarId.length() > 0) {
                    if (selectCalendar.isSchedule(calendarId, work).booleanValue()) {
                        info.add(work);
                        continue;
                    }
                    info.add(null);
                    continue;
                }
                info.add(work);
            }
            list.add(info);
        }
        return list;
    }

    public CommonTableTreeItem getDetailList(String scheduleId) throws FinderException, NamingException, SchedulerException {
        QuartzManager manager = QuartzUtil.getQuartzManager();
        JobDetail job = null;
        try {
            job = manager.getJobDetail(scheduleId, "JOB");
        }
        catch (RemoteException e) {
            // empty catch block
        }
        Object[] jdArgs = (Object[])job.getJobDataMap().get((Object)"args");
        String jobId = (String)jdArgs[0];
        JobMasterLocal jobMaster = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(jobId));
        CommonTableTreeItem tree = new CommonTableTreeItem(null, null);
        this.createDetailListTree(jobMaster, tree);
        return tree;
    }

    protected void createDetailListTree(JobMasterLocal job, CommonTableTreeItem parent) {
        ArrayList info = this.createDetailListTreeData(job);
        CommonTableTreeItem item = new CommonTableTreeItem(parent, info);
        Collection collection = null;
        try {
            collection = JobRelationMasterUtil.getLocalHome().findByParentJobId(job.getJob_id());
        }
        catch (FinderException e) {
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (collection != null && collection.size() > 0) {
            for (JobRelationMasterLocal children : collection) {
                JobMasterLocal childJob = children.getJobMaster();
                this.createDetailListTree(childJob, item);
            }
        }
    }

    protected ArrayList createDetailListTreeData(JobMasterLocal job) {
        ArrayList<Object> info = new ArrayList<Object>();
        info.add("");
        info.add(job.getJob_id());
        info.add(job.getJob_name());
        info.add(job.getJob_type());
        JobStartMasterLocal start = job.getJobStartMaster();
        if (start != null && start.getCalendar() == 1) {
            info.add(start.getCalendar_id());
        } else {
            info.add(null);
        }
        return info;
    }

    public CommonTableTreeItem getDetailSchedule(String scheduleId, Date base) throws FinderException, NamingException, SchedulerException {
        QuartzManager manager = QuartzUtil.getQuartzManager();
        JobDetail job = null;
        try {
            job = manager.getJobDetail(scheduleId, "JOB");
        }
        catch (RemoteException e) {
            // empty catch block
        }
        Object[] jdArgs = (Object[])job.getJobDataMap().get((Object)"args");
        String jobId = (String)jdArgs[0];
        String calendarId = null;
        if (jdArgs.length > 1) {
            calendarId = (String)jdArgs[1];
        }
        JobMasterLocal jobMaster = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(jobId));
        CommonTableTreeItem tree = new CommonTableTreeItem(null, null);
        this.createDetailScheduleTree(jobMaster, tree, calendarId, base);
        return tree;
    }

    protected void createDetailScheduleTree(JobMasterLocal job, CommonTableTreeItem parent, String parentCalendarId, Date base) throws FinderException, NamingException {
        ArrayList info = this.createDetailScheduleTreeData(job, parent.getData(), parentCalendarId, base);
        CommonTableTreeItem item = new CommonTableTreeItem(parent, info);
        Collection collection = null;
        try {
            collection = JobRelationMasterUtil.getLocalHome().findByParentJobId(job.getJob_id());
        }
        catch (FinderException e) {
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (collection != null && collection.size() > 0) {
            for (JobRelationMasterLocal children : collection) {
                JobMasterLocal childJob = children.getJobMaster();
                this.createDetailScheduleTree(childJob, item, null, base);
            }
        }
    }

    protected ArrayList createDetailScheduleTreeData(JobMasterLocal job, ArrayList parentInfo, String parentCalendarId, Date base) throws FinderException, NamingException {
        ArrayList<Object> info = new ArrayList<Object>();
        SelectCalendar selectCalendar = new SelectCalendar();
        info.add("");
        info.add(job.getJob_id());
        JobStartMasterLocal start = job.getJobStartMaster();
        String calendarId = null;
        if (start != null && start.getCalendar() == 1) {
            calendarId = start.getCalendar_id();
        }
        for (int j = 0; j < 28; ++j) {
            Calendar baseCalendar = Calendar.getInstance();
            baseCalendar.setTime(base);
            baseCalendar.add(5, j);
            Date work = baseCalendar.getTime();
            boolean run = true;
            if (parentCalendarId != null && parentCalendarId.length() > 0) {
                if (!selectCalendar.isSchedule(parentCalendarId, work).booleanValue()) {
                    run = false;
                }
            } else if (parentInfo != null && parentInfo.get(j + 2) == null) {
                run = false;
            }
            if (run) {
                if (calendarId != null && calendarId.length() > 0) {
                    if (selectCalendar.isSchedule(calendarId, work).booleanValue()) {
                        info.add(work);
                        continue;
                    }
                    info.add(null);
                    continue;
                }
                info.add(work);
                continue;
            }
            info.add(null);
        }
        return info;
    }
}

