/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.calendar.ejb.session;

import com.clustercontrol.bean.Property;
import com.clustercontrol.bean.TableColumnInfo;
import com.clustercontrol.calendar.factory.AddProperty;
import com.clustercontrol.calendar.factory.CalendarProperty;
import com.clustercontrol.calendar.factory.ModifyCalendar;
import com.clustercontrol.calendar.factory.SelectCalendar;
import com.clustercontrol.calendar.factory.WeekdayProperty;
import com.clustercontrol.util.Messages;
import java.rmi.RemoteException;
import java.security.Principal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class CalendarControllerBean
implements SessionBean {
    protected static Log m_log = LogFactory.getLog(CalendarControllerBean.class);
    private SessionContext m_context;

    public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
        this.m_context = ctx;
    }

    public ArrayList getCalendarListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"calendar.id", (Locale)locale), -1, 100, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"calendar.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"valid.time", (Locale)locale) + "(" + Messages.getString((String)"start", (Locale)locale) + ")", -1, 150, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"valid.time", (Locale)locale) + "(" + Messages.getString((String)"end", (Locale)locale) + ")", -1, 150, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"description", (Locale)locale), -1, 150, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"creator.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"create.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"modifier.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(8, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(9, new TableColumnInfo("", 15, 0, 16384));
        return tableDefine;
    }

    public ArrayList getWeekdayListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"weekday", (Locale)locale), 16, 80, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"timestamp", (Locale)locale) + "(" + Messages.getString((String)"start", (Locale)locale) + ")", -1, 100, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"timestamp", (Locale)locale) + "(" + Messages.getString((String)"end", (Locale)locale) + ")", -1, 100, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"description", (Locale)locale), -1, 150, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"creator.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"create.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"modifier.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)locale), -1, 150, 16384));
        return tableDefine;
    }

    public ArrayList getAddListTableDefine(Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"run", (Locale)locale), 15, 50, 16384));
        tableDefine.add(1, new TableColumnInfo(Messages.getString((String)"time", (Locale)locale) + "(" + Messages.getString((String)"start", (Locale)locale) + ")", -1, 150, 16384));
        tableDefine.add(2, new TableColumnInfo(Messages.getString((String)"time", (Locale)locale) + "(" + Messages.getString((String)"end", (Locale)locale) + ")", -1, 150, 16384));
        tableDefine.add(3, new TableColumnInfo(Messages.getString((String)"description", (Locale)locale), -1, 150, 16384));
        tableDefine.add(4, new TableColumnInfo(Messages.getString((String)"creator.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(5, new TableColumnInfo(Messages.getString((String)"create.time", (Locale)locale), -1, 150, 16384));
        tableDefine.add(6, new TableColumnInfo(Messages.getString((String)"modifier.name", (Locale)locale), -1, 100, 16384));
        tableDefine.add(7, new TableColumnInfo(Messages.getString((String)"update.time", (Locale)locale), -1, 150, 16384));
        return tableDefine;
    }

    public ArrayList getScheduleTableDefine(Date base, Locale locale) {
        ArrayList<TableColumnInfo> tableDefine = new ArrayList<TableColumnInfo>();
        tableDefine.add(0, new TableColumnInfo(Messages.getString((String)"calendar.id", (Locale)locale), -1, 0, 16384));
        for (int i = 0; i < 28; ++i) {
            Calendar baseCalendar = Calendar.getInstance();
            baseCalendar.setTime(base);
            baseCalendar.add(5, i);
            Date work = baseCalendar.getTime();
            tableDefine.add(i + 1, new TableColumnInfo(DateFormat.getDateInstance(3, locale).format(work), 17, 70, 16384));
        }
        return tableDefine;
    }

    public ArrayList getCalendarList() throws FinderException, NamingException {
        SelectCalendar select = new SelectCalendar();
        ArrayList list = select.getCalendarList();
        return list;
    }

    public ArrayList getWeekdayList(String id) throws FinderException, NamingException {
        SelectCalendar select = new SelectCalendar();
        ArrayList list = select.getWeekdayList(id);
        return list;
    }

    public ArrayList getAddList(String id) throws FinderException, NamingException {
        SelectCalendar select = new SelectCalendar();
        ArrayList list = select.getAddList(id);
        return list;
    }

    public ArrayList getSchedule(Date base) throws FinderException, NamingException {
        SelectCalendar select = new SelectCalendar();
        ArrayList list = select.getSchedule(base);
        return list;
    }

    public Property getCalendarProperty(String id, int mode, Locale locale) throws FinderException, NamingException {
        return new CalendarProperty().getProperty(id, mode, locale);
    }

    public void addCalendar(Property property) throws NamingException, CreateException, FinderException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyCalendar modify = new ModifyCalendar();
        modify.addCalendar(property, pri.getName());
    }

    public void modifyCalendar(Property property) throws NamingException, FinderException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyCalendar modify = new ModifyCalendar();
        modify.modifyCalendar(property, pri.getName());
    }

    public void deleteCalendar(String id) throws NamingException, RemoveException, FinderException {
        ModifyCalendar modify = new ModifyCalendar();
        modify.deleteCalendar(id);
    }

    public Property getWeekdayProperty(String id, Integer weekday, Date from, Date to, int mode, Locale locale) throws FinderException, NamingException {
        return new WeekdayProperty().getProperty(id, weekday, from, to, mode, locale);
    }

    public void addWeekday(String id, Property property) throws NamingException, CreateException, FinderException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyCalendar modify = new ModifyCalendar();
        modify.addWeekday(id, property, pri.getName());
    }

    public void modifyWeekday(String id, Integer weekday, Date from, Date to, Property property) throws NamingException, FinderException, RemoveException, CreateException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyCalendar modify = new ModifyCalendar();
        modify.modifyWeekday(id, weekday, from, to, property, pri.getName());
    }

    public void deleteWeekday(String id, Integer weekday, Date from, Date to) throws NamingException, RemoveException, FinderException {
        ModifyCalendar modify = new ModifyCalendar();
        modify.deleteWeekday(id, weekday, from, to);
    }

    public Property getAddInfoProperty(String id, Date from, Date to, int mode, Locale locale) throws FinderException, NamingException {
        return new AddProperty().getProperty(id, from, to, mode, locale);
    }

    public void addAddInfo(String id, Property property) throws NamingException, CreateException, FinderException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyCalendar modify = new ModifyCalendar();
        modify.addAddInfo(id, property, pri.getName());
    }

    public void modifyAddInfo(String id, Date from, Date to, Property property) throws NamingException, FinderException, RemoveException, CreateException {
        Principal pri = this.m_context.getCallerPrincipal();
        ModifyCalendar modify = new ModifyCalendar();
        modify.modifyAddInfo(id, from, to, property, pri.getName());
    }

    public void deleteAddInfo(String id, Date from, Date to) throws NamingException, RemoveException, FinderException {
        ModifyCalendar modify = new ModifyCalendar();
        modify.deleteAddInfo(id, from, to);
    }

    public Boolean isRun(String id, Date checkTimestamp) throws FinderException, NamingException {
        SelectCalendar select = new SelectCalendar();
        return select.isRun(id, checkTimestamp);
    }

    public ArrayList getCalendarIdList() throws FinderException, NamingException {
        SelectCalendar select = new SelectCalendar();
        ArrayList list = select.getCalendarIdList();
        return list;
    }
}

