/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.util;

import java.util.Collection;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import net.sf.jasperreports.engine.export.JRCsvExporter;

public class ReportGenerator {
    protected String m_jasperPath;
    protected int m_outputForm;
    static /* synthetic */ Class class$0;

    public ReportGenerator(String path, int form) {
        this.m_jasperPath = path;
        this.m_outputForm = form;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean run(String destPath, Map paramMap, Collection collectionData) {
        Thread cur = Thread.currentThread();
        ClassLoader save = cur.getContextClassLoader();
        try {
            cur.setContextClassLoader(JasperCompileManager.class.getClassLoader());
            JRBeanCollectionDataSource ds = new JRBeanCollectionDataSource(collectionData);
            JasperPrint print = JasperFillManager.fillReport((String)this.m_jasperPath, (Map)paramMap, (JRDataSource)ds);
            if (this.m_outputForm == 0) {
                JasperExportManager.exportReportToPdfFile((JasperPrint)print, (String)destPath);
                return true;
            }
            if (this.m_outputForm != 1) return true;
            JRCsvExporter exporter = new JRCsvExporter();
            exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
            exporter.setParameter(JRExporterParameter.OUTPUT_FILE_NAME, (Object)destPath);
            exporter.setParameter(JRExporterParameter.CHARACTER_ENCODING, (Object)System.getProperty("file.encoding"));
            exporter.exportReport();
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            cur.setContextClassLoader(save);
            return false;
        }
        finally {
            cur.setContextClassLoader(save);
        }
    }
}

