/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.notify.factory;

import com.clustercontrol.accesscontrol.factory.AccessLock;
import com.clustercontrol.notify.bean.NotifyEventInfo;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.ejb.entity.SystemNotifyEventInfoLocal;
import com.clustercontrol.notify.ejb.entity.SystemNotifyEventInfoUtil;
import com.clustercontrol.notify.ejb.entity.SystemNotifyInfoLocal;
import com.clustercontrol.notify.ejb.entity.SystemNotifyInfoUtil;
import com.clustercontrol.notify.factory.DeleteSystemNotify;
import com.clustercontrol.util.apllog.AplLogger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.jms.JMSException;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ModifySystemNotify {
    protected static Log m_log = LogFactory.getLog(ModifySystemNotify.class);

    public boolean modify(NotifyInfo info) throws CreateException, FinderException, RemoveException, NamingException, JMSException {
        AccessLock.lock((String)"NOTIFY");
        try {
            SystemNotifyInfoLocal notify = SystemNotifyInfoUtil.getLocalHome().findByPrimaryKey(info.getNotifyId());
            if (notify != null) {
                notify.setDescription(info.getDescription());
                notify.setStatusFlg(info.getStatusFlg());
                notify.setStatusValidPeriod(info.getStatusValidPeriod());
                notify.setStatusInvalidFlg(info.getStatusInvalidFlg());
                notify.setStatusUpdatePriority(info.getStatusUpdatePriority());
                notify.setEventFlg(info.getEventFlg());
                notify.setInhibitionFlg(info.getInhibitionFlg());
                notify.setInhibitionFrequency(info.getInhibitionFrequency());
                notify.setInhibitionPeriod(info.getInhibitionPeriod());
                notify.setUpdateDate(new Timestamp(new Date().getTime()));
            }
            Collection ct = notify.getSystemNotifyEventInfo();
            DeleteSystemNotify delete = new DeleteSystemNotify();
            delete.deleteEvents(ct);
            ArrayList eventList = info.getNotifyEventInfo();
            ArrayList<SystemNotifyEventInfoLocal> eventLocalList = new ArrayList<SystemNotifyEventInfoLocal>();
            NotifyEventInfo event = null;
            for (int index = 0; index < eventList.size(); ++index) {
                event = (NotifyEventInfo)eventList.get(index);
                if (event == null) continue;
                SystemNotifyEventInfoLocal local = SystemNotifyEventInfoUtil.getLocalHome().create(info.getNotifyId(), event.getPriority(), event.getEventNormalFlg(), event.getEventNormalState(), event.getEventInhibitionFlg(), event.getEventInhibitionState(), event.getMailFlg(), event.getMailAddress());
                eventLocalList.add(local);
            }
            if (eventLocalList != null) {
                ct.addAll(eventLocalList);
                notify.setSystemNotifyEventInfo(ct);
            }
        }
        catch (CreateException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{info.getNotifyId()};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("modify():" + e.getMessage()));
            throw e;
        }
        catch (FinderException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{info.getNotifyId()};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("modify():" + e.getMessage()));
            throw e;
        }
        catch (RemoveException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{info.getNotifyId()};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("modify():" + e.getMessage()));
            throw e;
        }
        catch (NamingException e) {
            AplLogger apllog = new AplLogger("NOTIFY", "notify");
            Object[] args = new String[]{info.getNotifyId()};
            apllog.put("SYS", "002", args);
            m_log.debug((Object)("modify():" + e.getMessage()));
            throw e;
        }
        return true;
    }
}

