<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:php="http://php.net/xsl"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:nt="http://www.arielworks.net/works/codeyard/himmel/xnm"
                              xmlns:nts="http://www.arielworks.net/works/codeyard/himmel/xnm/settings"
                              xmlns:nidx="http://www.arielworks.net/works/codeyard/himmel/xnm/index"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns:hml="http://www.arielworks.net/works/codeyard/himmel"
                              xmlns:s3="http://www.arielworks.net/works/codeyard/sdf/s3"
                              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/"
                              exclude-result-prefixes="php nt nidx">

<xsl:param name="category"/>
<xsl:param name="nidx:category" select="$category"/>
<xsl:param name="year"/>
<xsl:param name="nidx:year" select="$year"/>
<xsl:param name="month"/>
<xsl:param name="nidx:month" select="$month"/>
<xsl:param name="day"/>
<xsl:param name="nidx:day" select="$day"/>
<xsl:param name="hour"/>
<xsl:param name="nidx:hour" select="$hour"/>
<xsl:param name="minute"/>
<xsl:param name="nidx:minute" select="$minute"/>
<xsl:param name="second"/>
<xsl:param name="nidx:second" select="$second"/>
<xsl:param name="rootPath"/>
<xsl:param name="nidx:rootPath" select="$rootPath"/>
<xsl:param name="webPrefix"/>
<xsl:param name="nidx:webPrefix" select="$webPrefix"/>

<xsl:param name="nts:settings" select="document('./settings.xml')/nts:settings"/>


<xsl:template name="listYears">
    <xsl:param name="target" select="ancestor-or-self::nidx:category/nidx:year"/>
    <xsl:param name="limit" select="count($target)"/>
    <xsl:param name="sortOrder" select="'ascending'"/>
    <xsl:param name="layer" select="1"/>
    <xsl:param name="category" select="'ALL'"/>
    <xsl:choose>
        <xsl:when test="$layer = 1">
            <ul>
                <xsl:choose>
                    <xsl:when test="$sortOrder = 'ascending'">
                        <xsl:for-each select="$target[nidx:month/nidx:day/nidx:note/nt:category/nt:li = $category]">
                            <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="ascending"/>
                            <xsl:sort select="./@num" data-type="number" order="ascending"/>
                            <xsl:if test="position() &lt;= $limit">
                                <xsl:call-template name="listYearsLayer1">
                                    <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                    <xsl:with-param name="category" select="$category"/>
                                </xsl:call-template>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:when test="$sortOrder = 'descending'">
                        <xsl:for-each select="$target[nidx:month/nidx:day/nidx:note/nt:category/nt:li = $category]">
                            <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="ascending"/>
                            <xsl:sort select="./@num" data-type="number" order="descending"/>
                            <xsl:if test="position() &lt;= $limit">
                                <xsl:call-template name="listYearsLayer1">
                                    <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                    <xsl:with-param name="category" select="$category"/>
                                </xsl:call-template>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                </xsl:choose>
            </ul>
        </xsl:when>
        <xsl:when test="$layer = 2">
            <dl>
                <xsl:choose>
                    <xsl:when test="$sortOrder = 'ascending'">
                        <xsl:for-each select="$target[nidx:month/nidx:day/nidx:note/nt:category/nt:li = $category]">
                            <xsl:sort select="./@num" data-type="number" order="ascending"/>
                            <xsl:if test="position() &lt;= $limit">
                                <xsl:call-template name="listYearsLayer2">
                                    <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                    <xsl:with-param name="category" select="$category"/>
                                </xsl:call-template>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:when test="$sortOrder = 'descending'">
                        <xsl:for-each select="$target[nidx:month/nidx:day/nidx:note/nt:category/nt:li = $category]">
                            <xsl:sort select="./@num" data-type="number" order="descending"/>
                            <xsl:if test="position() &lt;= $limit">
                                <xsl:call-template name="listYearsLayer2">
                                    <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                    <xsl:with-param name="category" select="$category"/>
                                </xsl:call-template>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                </xsl:choose>
            </dl>
        </xsl:when>
        <xsl:when test="$layer = 3">
            <xsl:choose>
                <xsl:when test="$sortOrder = 'ascending'">
                    <xsl:for-each select="$target[nidx:month/nidx:day/nidx:note/nt:category/nt:li = $category]">
                        <xsl:sort select="./@num" data-type="number" order="ascending"/>
                        <xsl:if test="position() &lt;= $limit">
                            <xsl:call-template name="listMonthsLayer3">
                                <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                <xsl:with-param name="category" select="$category"/>
                            </xsl:call-template>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:when>
                <xsl:when test="$sortOrder = 'descending'">
                    <xsl:for-each select="$target[nidx:month/nidx:day/nidx:note/nt:category/nt:li = $category]">
                        <xsl:sort select="./@num" data-type="number" order="descending"/>
                        <xsl:if test="position() &lt;= $limit">
                            <xsl:call-template name="listYearsLayer3">
                                <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                <xsl:with-param name="category" select="$category"/>
                            </xsl:call-template>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:when>
            </xsl:choose>
        </xsl:when>
    </xsl:choose>
</xsl:template>

<xsl:template name="listYearsLayer1">
    <xsl:param name="sortOrder" select="'ascending'"/>
    <xsl:param name="category" select="'ALL'"/>
    <li>
        <a>
            <xsl:attribute name="href">
                <xsl:value-of select="$nidx:rootPath"/>
                <xsl:if test="not($category = 'ALL')">
                    <xsl:value-of select="concat('/', $category)"/>
                </xsl:if>
                <xsl:value-of select="concat('/', @num)"/>
            </xsl:attribute>
            <xsl:value-of select="./@num"/>
        </a>
        <xsl:value-of select="concat('（', count(nidx:month/nidx:day/nidx:note[nt:category/nt:li = $category]), '）')"/>
    </li>
</xsl:template>

<xsl:template name="listYearsLayer2">
    <xsl:param name="sortOrder" select="'ascending'"/>
    <xsl:param name="category" select="'ALL'"/>
    <dt>
        <a>
            <xsl:attribute name="href">
                <xsl:value-of select="$nidx:rootPath"/>
                <xsl:if test="not($category = 'ALL')">
                    <xsl:value-of select="concat('/', $category)"/>
                </xsl:if>
                <xsl:value-of select="concat('/', @num)"/>
            </xsl:attribute>
            <xsl:value-of select="./@num"/>
        </a>
    </dt>
    <dd>
        <xsl:call-template name="listMonths">
            <xsl:with-param name="layer" select="1"/>
            <xsl:with-param name="category" select="$category"/>
        </xsl:call-template>
    </dd>
</xsl:template>

<xsl:template name="listYearsLayer3">
    <xsl:param name="sortOrder" select="'ascending'"/>
    <xsl:param name="category" select="'ALL'"/>
    <dt>
        <a>
            <xsl:attribute name="href">
                <xsl:value-of select="$nidx:rootPath"/>
                <xsl:if test="not($category = 'ALL')">
                    <xsl:value-of select="concat('/', $category)"/>
                </xsl:if>
                <xsl:value-of select="concat('/', @num)"/>
            </xsl:attribute>
            <xsl:value-of select="./@num"/>
        </a>
    </dt>
    <dd>
        <xsl:call-template name="listMonths">
            <xsl:with-param name="layer" select="2"/>
            <xsl:with-param name="category" select="$category"/>
        </xsl:call-template>
    </dd>
</xsl:template>

<xsl:template name="listMonths">
    <xsl:param name="target" select="ancestor-or-self::nidx:year/nidx:month"/>
    <xsl:param name="limit" select="count($target)"/>
    <xsl:param name="sortOrder" select="'ascending'"/>
    <xsl:param name="layer" select="1"/>
    <xsl:param name="category" select="'ALL'"/>
    <xsl:choose>
        <xsl:when test="$layer = 1">
            <ul>
                <xsl:choose>
                    <xsl:when test="$sortOrder = 'ascending'">
                        <xsl:for-each select="$target[nidx:day/nidx:note/nt:category/nt:li = $category]">
                            <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="ascending"/>
                            <xsl:sort select="./@num" data-type="number" order="ascending"/>
                            <xsl:if test="position() &lt;= $limit">
                                <xsl:call-template name="listMonthsLayer1">
                                    <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                    <xsl:with-param name="category" select="$category"/>
                                </xsl:call-template>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:when test="$sortOrder = 'descending'">
                        <xsl:for-each select="$target[nidx:day/nidx:note/nt:category/nt:li = $category]">
                            <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="ascending"/>
                            <xsl:sort select="./@num" data-type="number" order="descending"/>
                            <xsl:if test="position() &lt;= $limit">
                                <xsl:call-template name="listMonthsLayer1">
                                    <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                    <xsl:with-param name="category" select="$category"/>
                                </xsl:call-template>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                </xsl:choose>
            </ul>
        </xsl:when>
        <xsl:when test="$layer = 2">
            <dl>
                <xsl:choose>
                    <xsl:when test="$sortOrder = 'ascending'">
                        <xsl:for-each select="$target[nidx:day/nidx:note/nt:category/nt:li = $category]">
                            <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="ascending"/>
                            <xsl:sort select="./@num" data-type="number" order="ascending"/>
                            <xsl:if test="position() &lt;= $limit">
                                <xsl:call-template name="listMonthsLayer2">
                                    <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                    <xsl:with-param name="category" select="$category"/>
                                </xsl:call-template>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:when test="$sortOrder = 'descending'">
                        <xsl:for-each select="$target[nidx:day/nidx:note/nt:category/nt:li = $category]">
                            <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="descending"/>
                            <xsl:sort select="./@num" data-type="number" order="descending"/>
                            <xsl:if test="position() &lt;= $limit">
                                <xsl:call-template name="listMonthsLayer2">
                                    <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                    <xsl:with-param name="category" select="$category"/>
                                </xsl:call-template>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                </xsl:choose>
            </dl>
        </xsl:when>
        <xsl:when test="$layer = 3">
            <xsl:choose>
                <xsl:when test="$sortOrder = 'ascending'">
                    <xsl:for-each select="$target[nidx:day/nidx:note/nt:category/nt:li = $category]">
                        <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="ascending"/>
                        <xsl:sort select="./@num" data-type="number" order="ascending"/>
                        <xsl:if test="position() &lt;= $limit">
                            <xsl:call-template name="listMonthsLayer3">
                                <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                <xsl:with-param name="category" select="$category"/>
                            </xsl:call-template>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:when>
                <xsl:when test="$sortOrder = 'descending'">
                    <xsl:for-each select="$target[nidx:day/nidx:note/nt:category/nt:li = $category]">
                        <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="descending"/>
                        <xsl:sort select="./@num" data-type="number" order="descending"/>
                        <xsl:if test="position() &lt;= $limit">
                            <xsl:call-template name="listMonthsLayer3">
                                <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                <xsl:with-param name="category" select="$category"/>
                            </xsl:call-template>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:when>
            </xsl:choose>
        </xsl:when>
    </xsl:choose>
</xsl:template>

<xsl:template name="listMonthsLayer1">
    <xsl:param name="sortOrder" select="'ascending'"/>
    <xsl:param name="category" select="'ALL'"/>
    <li>
        <a>
            <xsl:attribute name="href">
                <xsl:value-of select="$nidx:rootPath"/>
                <xsl:if test="not($category = 'ALL')">
                    <xsl:value-of select="concat('/', $category)"/>
                </xsl:if>
                <xsl:value-of select="concat('/', parent::nidx:year/@num, '/', @num)"/>
            </xsl:attribute>
            <xsl:value-of select="parent::nidx:year/@num"/>
            <xsl:text>-</xsl:text>
            <xsl:value-of select="./@num"/>
        </a>
        <xsl:value-of select="concat('（', count(nidx:day/nidx:note[nt:category/nt:li = $category]), '）')"/>
    </li>
</xsl:template>

<xsl:template name="listMonthsLayer2">
    <xsl:param name="sortOrder" select="'ascending'"/>
    <xsl:param name="category" select="'ALL'"/>
    <dt>
        <a>
            <xsl:attribute name="href">
                <xsl:value-of select="$nidx:rootPath"/>
                <xsl:if test="not($category = 'ALL')">
                    <xsl:value-of select="concat('/', $category)"/>
                </xsl:if>
                <xsl:value-of select="concat('/', parent::nidx:year/@num, '/', @num)"/>
            </xsl:attribute>
            <xsl:value-of select="parent::nidx:year/@num"/>
            <xsl:text>-</xsl:text>
            <xsl:value-of select="./@num"/>
        </a>
    </dt>
    <dd>
        <xsl:call-template name="listDays">
            <xsl:with-param name="layer" select="1"/>
            <xsl:with-param name="category" select="$category"/>
        </xsl:call-template>
    </dd>
</xsl:template>

<xsl:template name="listMonthsLayer3">
    <xsl:param name="sortOrder" select="'ascending'"/>
    <xsl:param name="category" select="'ALL'"/>
    <sdf:section>
        <sdf:meta>
            <dc:title>
                <a>
                    <xsl:attribute name="href">
                        <xsl:value-of select="$nidx:rootPath"/>
                        <xsl:if test="not($category = 'ALL')">
                            <xsl:value-of select="concat('/', $category)"/>
                        </xsl:if>
                        <xsl:value-of select="concat('/', parent::nidx:year/@num, '/', @num)"/>
                    </xsl:attribute>
                    <xsl:value-of select="parent::nidx:year/@num"/>
                    <xsl:text>-</xsl:text>
                    <xsl:value-of select="./@num"/>
                </a>
            </dc:title>
        </sdf:meta>
        <sdf:body>
            <xsl:call-template name="listDays">
                <xsl:with-param name="layer" select="2"/>
                <xsl:with-param name="category" select="$category"/>
            </xsl:call-template>
        </sdf:body>
    </sdf:section>
</xsl:template>

<xsl:template name="listDays">
    <xsl:param name="target" select="ancestor-or-self::nidx:month/nidx:day"/>
    <xsl:param name="limit" select="count($target)"/>
    <xsl:param name="sortOrder" select="'ascending'"/>
    <xsl:param name="layer" select="1"/>
    <xsl:param name="category" select="'ALL'"/>
            <xsl:variable name="targetFilterd" select="$target[nidx:note/nt:category/nt:li = $category]"/>
    <xsl:choose>
        <xsl:when test="$layer = 1">
            <ul>
                <xsl:choose>
                    <xsl:when test="$sortOrder = 'ascending'">
                        <xsl:for-each select="$targetFilterd">
                            <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="ascending"/>
                            <xsl:sort select="ancestor::nidx:month/@num" data-type="number" order="ascending"/>
                            <xsl:sort select="./@num" data-type="number" order="ascending"/>
                            <xsl:if test="position() &lt;= $limit">
                                <xsl:call-template name="listDaysLayer1">
                                    <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                    <xsl:with-param name="category" select="$category"/>
                                </xsl:call-template>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:when test="$sortOrder = 'descending'">
                        <xsl:for-each select="$targetFilterd">
                            <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="descending"/>
                            <xsl:sort select="ancestor::nidx:month/@num" data-type="number" order="descending"/>
                            <xsl:sort select="./@num" data-type="number" order="descending"/>
                            <xsl:if test="position() &lt;= $limit">
                                <xsl:call-template name="listDaysLayer1">
                                    <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                    <xsl:with-param name="category" select="$category"/>
                                </xsl:call-template>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                </xsl:choose>
            </ul>
        </xsl:when>
        <xsl:when test="$layer = 2">
            <dl>
                <xsl:choose>
                    <xsl:when test="$sortOrder = 'ascending'">
                        <xsl:for-each select="$targetFilterd">
                            <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="ascending"/>
                            <xsl:sort select="ancestor::nidx:month/@num" data-type="number" order="ascending"/>
                            <xsl:sort select="./@num" data-type="number" order="ascending"/>
                            <xsl:if test="position() &lt;= $limit">
                                <xsl:call-template name="listDaysLayer2">
                                    <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                    <xsl:with-param name="category" select="$category"/>
                                </xsl:call-template>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:when test="$sortOrder = 'descending'">
                        <xsl:for-each select="$targetFilterd">
                            <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="descending"/>
                            <xsl:sort select="ancestor::nidx:month/@num" data-type="number" order="descending"/>
                            <xsl:sort select="./@num" data-type="number" order="descending"/>
                            <xsl:if test="position() &lt;= $limit">
                                <xsl:call-template name="listDaysLayer2">
                                    <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                    <xsl:with-param name="category" select="$category"/>
                                </xsl:call-template>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                </xsl:choose>
            </dl>
        </xsl:when>
        <xsl:when test="$layer = 3">
            <xsl:choose>
                <xsl:when test="$sortOrder = 'ascending'">
                    <xsl:for-each select="$targetFilterd">
                        <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="ascending"/>
                        <xsl:sort select="ancestor::nidx:month/@num" data-type="number" order="ascending"/>
                        <xsl:sort select="./@num" data-type="number" order="ascending"/>
                        <xsl:if test="position() &lt;= $limit">
                            <xsl:call-template name="listDaysLayer3">
                                <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                <xsl:with-param name="category" select="$category"/>
                            </xsl:call-template>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:when>
                <xsl:when test="$sortOrder = 'descending'">
                    <xsl:for-each select="$targetFilterd">
                        <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="descending"/>
                        <xsl:sort select="ancestor::nidx:month/@num" data-type="number" order="descending"/>
                        <xsl:sort select="./@num" data-type="number" order="descending"/>
                        <xsl:if test="position() &lt;= $limit">
                            <xsl:call-template name="listDaysLayer3">
                                <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                <xsl:with-param name="category" select="$category"/>
                            </xsl:call-template>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:when>
            </xsl:choose>
        </xsl:when>
    </xsl:choose>
</xsl:template>

<xsl:template name="listDaysLayer1">
    <xsl:param name="sortOrder" select="'ascending'"/>
    <xsl:param name="category" select="'ALL'"/>
    <li>
        <a>
            <xsl:attribute name="href">
                <xsl:value-of select="$nidx:rootPath"/>
                <xsl:if test="not($category = 'ALL')">
                    <xsl:value-of select="concat('/', $category)"/>
                </xsl:if>
                <xsl:value-of select="concat('/', ancestor::nidx:year/@num, '/', ancestor::nidx:month/@num, '/', ./@num)"/>
            </xsl:attribute>
            <xsl:value-of select="concat(ancestor::nidx:year/@num, '-', parent::nidx:month/@num, '-', ./@num)"/>
        </a>
        <xsl:value-of select="concat('（', count(nidx:note[nt:category/nt:li = $category]), '）')"/>
    </li>
</xsl:template>

<xsl:template name="listDaysLayer2">
    <xsl:param name="sortOrder" select="'ascending'"/>
    <xsl:param name="category" select="'ALL'"/>
    <dt>
        <a>
            <xsl:attribute name="href">
                <xsl:value-of select="$nidx:rootPath"/>
                <xsl:if test="not($category = 'ALL')">
                    <xsl:value-of select="concat('/', $category)"/>
                </xsl:if>
                <xsl:value-of select="concat('/', ancestor::nidx:year/@num, '/', ancestor::nidx:month/@num, '/', ./@num)"/>
            </xsl:attribute>
            <xsl:value-of select="concat(ancestor::nidx:year/@num, '-', parent::nidx:month/@num, '-', ./@num)"/>
        </a>
    </dt>
    <dd>
        <xsl:call-template name="listNotes">
            <xsl:with-param name="layer" select="1"/>
            <xsl:with-param name="category" select="$category"/>
        </xsl:call-template>
    </dd>
</xsl:template>

<xsl:template name="listDaysLayer3">
    <xsl:param name="sortOrder" select="'ascending'"/>
    <xsl:param name="category" select="'ALL'"/>
    <sdf:section>
        <sdf:meta>
            <dc:title>
                <a>
                    <xsl:attribute name="href">
                        <xsl:value-of select="$nidx:rootPath"/>
                        <xsl:if test="not($category = 'ALL')">
                            <xsl:value-of select="concat('/', $category)"/>
                        </xsl:if>
                        <xsl:value-of select="concat('/', ancestor::nidx:year/@num, '/', ancestor::nidx:month/@num, '/', ./@num)"/>
                    </xsl:attribute>
                    <xsl:value-of select="concat(ancestor::nidx:year/@num, '-', parent::nidx:month/@num, '-', ./@num)"/>
                </a>
            </dc:title>
        </sdf:meta>
        <sdf:body>
            <xsl:call-template name="listNotes">
                <xsl:with-param name="layer" select="2"/>
            <xsl:with-param name="category" select="$category"/>
            </xsl:call-template>
        </sdf:body>
    </sdf:section>
</xsl:template>


<xsl:template name="listNotes">
    <xsl:param name="target" select="ancestor-or-self::nidx:day/nidx:note"/>
    <xsl:param name="limit" select="count($target)"/>
    <xsl:param name="sortOrder" select="'ascending'"/>
    <xsl:param name="layer" select="1"/>
    <xsl:param name="category" select="'ALL'"/>
    <xsl:choose>
        <xsl:when test="$layer = 1">
            <ul>
                <xsl:choose>
                    <xsl:when test="$sortOrder = 'ascending'">
                        <xsl:for-each select="$target[nt:category/nt:li = $category]">
                            <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="ascending"/>
                            <xsl:sort select="ancestor::nidx:month/@num" data-type="number" order="ascending"/>
                            <xsl:sort select="ancestor::nidx:day/@num" data-type="number" order="ascending"/>
                            <xsl:sort select="./@num" data-type="number" order="ascending"/>
                            <xsl:if test="position() &lt;= $limit">
                                <xsl:call-template name="listNotesLayer1">
                                    <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                    <xsl:with-param name="category" select="$category"/>
                                </xsl:call-template>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:when test="$sortOrder = 'descending'">
                        <xsl:for-each select="$target[nt:category/nt:li = $category]">
                            <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="descending"/>
                            <xsl:sort select="ancestor::nidx:month/@num" data-type="number" order="descending"/>
                            <xsl:sort select="ancestor::nidx:day/@num" data-type="number" order="descending"/>
                            <xsl:sort select="./@num" data-type="number" order="descending"/>
                            <xsl:if test="position() &lt;= $limit">
                                <xsl:call-template name="listNotesLayer1">
                                    <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                    <xsl:with-param name="category" select="$category"/>
                                </xsl:call-template>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:when>
                </xsl:choose>
            </ul>
        </xsl:when>
        <xsl:when test="$layer = 2">
            <xsl:choose>
                <xsl:when test="$sortOrder = 'ascending'">
                    <xsl:for-each select="$target[nt:category/nt:li = $category]">
                        <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="ascending"/>
                        <xsl:sort select="ancestor::nidx:month/@num" data-type="number" order="ascending"/>
                        <xsl:sort select="ancestor::nidx:day/@num" data-type="number" order="ascending"/>
                        <xsl:sort select="./@num" data-type="number" order="ascending"/>
                        <xsl:if test="position() &lt;= $limit">
                            <xsl:call-template name="listNotesLayer2">
                                <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                <xsl:with-param name="category" select="$category"/>
                            </xsl:call-template>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:when>
                <xsl:when test="$sortOrder = 'descending'">
                    <xsl:for-each select="$target[nt:category/nt:li = $category]">
                        <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="descending"/>
                        <xsl:sort select="ancestor::nidx:month/@num" data-type="number" order="descending"/>
                        <xsl:sort select="ancestor::nidx:day/@num" data-type="number" order="descending"/>
                        <xsl:sort select="./@num" data-type="number" order="descending"/>
                        <xsl:if test="position() &lt;= $limit">
                            <xsl:call-template name="listNotesLayer2">
                                <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                <xsl:with-param name="category" select="$category"/>
                            </xsl:call-template>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:when>
            </xsl:choose>
        </xsl:when>
        <xsl:when test="$layer = 3">
            <xsl:choose>
                <xsl:when test="$sortOrder = 'ascending'">
                    <xsl:for-each select="$target[nt:category/nt:li = $category]">
                        <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="ascending"/>
                        <xsl:sort select="ancestor::nidx:month/@num" data-type="number" order="ascending"/>
                        <xsl:sort select="ancestor::nidx:day/@num" data-type="number" order="ascending"/>
                        <xsl:sort select="./@num" data-type="number" order="ascending"/>
                        <xsl:if test="position() &lt;= $limit">
                            <xsl:call-template name="listNotesLayer3">
                                <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                <xsl:with-param name="category" select="$category"/>
                            </xsl:call-template>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:when>
                <xsl:when test="$sortOrder = 'descending'">
                    <xsl:for-each select="$target[nt:category/nt:li = $category]">
                        <xsl:sort select="ancestor::nidx:year/@num" data-type="number" order="descending"/>
                        <xsl:sort select="ancestor::nidx:month/@num" data-type="number" order="descending"/>
                        <xsl:sort select="ancestor::nidx:day/@num" data-type="number" order="descending"/>
                        <xsl:sort select="./@num" data-type="number" order="descending"/>
                        <xsl:if test="position() &lt;= $limit">
                            <xsl:call-template name="listNotesLayer3">
                                <xsl:with-param name="sortOrder" select="$sortOrder"/>
                                <xsl:with-param name="category" select="$category"/>
                            </xsl:call-template>
                        </xsl:if>
                    </xsl:for-each>
                </xsl:when>
            </xsl:choose>
        </xsl:when>
    </xsl:choose>
</xsl:template>

<xsl:template name="listNotesLayer1">
    <xsl:param name="sortOrder" select="'ascending'"/>
    <xsl:param name="category" select="'ALL'"/>
    <li>
        <xsl:value-of select="concat('（', substring(./dcterms:created, 12, 8), '）')"/>
        <a href="{concat($nidx:rootPath, '/', ancestor::nidx:year/@num, '/', ancestor::nidx:month/@num, '/', ancestor::nidx:day/@num, '/', ./@num)}">
            <xsl:value-of select="./dc:title"/>
        </a>
    </li>
</xsl:template>

<xsl:template name="listNotesLayer2">
    <xsl:param name="sortOrder" select="'ascending'"/>
    <xsl:param name="category" select="'ALL'"/>
    <xsl:variable name="nidx:current_note" select="php:function('Xnm_DataManager::loadNote', string(./@id))"/>
    <sdf:section>
        <sdf:meta>
            <xsl:copy-of select="$nidx:current_note/nt:note/*[not(local-name() = 'body' and namespace-uri() = 'http://www.arielworks.net/works/codeyard/himmel/xnm')]"/>
            <xh:link rel="permanent" href="{concat($nidx:webPrefix, $nidx:rootPath, '/', ancestor::nidx:year/@num, '/', ancestor::nidx:month/@num, '/', ancestor::nidx:day/@num, '/', ./@num)}"/>
        </sdf:meta>
        <sdf:body>
            <xsl:copy-of select="$nidx:current_note/nt:note/nt:body/node()"/>
        </sdf:body>
    </sdf:section>
</xsl:template>

<xsl:template name="listNotesLayer3">
    <xsl:param name="sortOrder" select="'ascending'"/>
    <xsl:param name="category" select="'ALL'"/>
    <xsl:variable name="nidx:current_note" select="php:function('Xnm_DataManager::loadNote', string(./@id))"/>
    <sdf:section>
        <sdf:meta>
            <xsl:copy-of select="$nidx:current_note/nt:note/*[not(local-name() = 'body' and namespace-uri() = 'http://www.arielworks.net/works/codeyard/himmel/xnm')]"/>
        </sdf:meta>
        <sdf:body>
            <xsl:copy-of select="$nidx:current_note/nt:note/nt:body/node()"/>
            <dl>
                <dt>Comments</dt>
                <dd>
                    <a href="{concat($nidx:rootPath, '/', ancestor::nidx:year/@num, '/', ancestor::nidx:month/@num, '/', ancestor::nidx:day/@num, '/', ./@num)}#comments">
                        <xsl:value-of select="count(./nt:comments/nt:comment)"/>
                    </a>
                </dd>
                <dt>Trackbacks</dt>
                <dd>
                    <a href="{concat($nidx:rootPath, '/', ancestor::nidx:year/@num, '/', ancestor::nidx:month/@num, '/', ancestor::nidx:day/@num, '/', ./@num)}#trackbacks">
                        <xsl:value-of select="count(./nt:referredBy/nt:Trackback)"/>
                    </a>
                </dd>
                <dt>PermaLink</dt>
                <dd>
                    <a href="{concat($nidx:rootPath, '/', ancestor::nidx:year/@num, '/', ancestor::nidx:month/@num, '/', ancestor::nidx:day/@num, '/', ./@num)}">
                        <xsl:value-of select="concat($nidx:webPrefix, $nidx:rootPath, '/', ancestor::nidx:year/@num, '/', ancestor::nidx:month/@num, '/', ancestor::nidx:day/@num, '/', ./@num)"/>
                    </a>
                </dd>
            </dl>
        </sdf:body>
    </sdf:section>
</xsl:template>


<xsl:template name="listCategories">
    <xsl:param name="layer" select="1"/>
    <xsl:choose>
        <xsl:when test="$layer = 1">
            <ul>
                <xsl:for-each select="/nidx:index/nidx:year/nidx:month/nidx:day/nidx:note/nt:category/nt:li[not(text() = 'ALL')]">
                    <xsl:if test="not(. = /nidx:index/nidx:year/nidx:month/nidx:day/nidx:note[@id &lt; current()/parent::nt:category/parent::nidx:note/@id]/nt:category/nt:li)">
                        <li>
                            <a href="{$nidx:rootPath}/{.}">
                                <xsl:call-template name="getCategoryName">
                                    <xsl:with-param name="of" select="."/>
                                </xsl:call-template>
                            </a>
                        </li>
                    </xsl:if>
                </xsl:for-each>
            </ul>
        </xsl:when>
        <xsl:when test="$layer = 2">
            <dl>
                <xsl:for-each select="/nidx:index/nidx:year/nidx:month/nidx:day/nidx:note/nt:category/nt:li[not(text() = 'ALL')]">
                    <xsl:if test="not(. = /nidx:index/nidx:year/nidx:month/nidx:day/nidx:note[@id &lt; current()/parent::nt:category/parent::nidx:note/@id]/nt:category/nt:li)">
                        <dt>
                            <a href="{$nidx:rootPath}/{.}">
                                <xsl:call-template name="getCategoryName">
                                    <xsl:with-param name="of" select="."/>
                                </xsl:call-template>
                            </a>
                        </dt>
                        <dd>
                            <xsl:call-template name="listYears">
                                <xsl:with-param name="target" select="/nidx:index/nidx:year"/>
                                <xsl:with-param name="layer" select="1"/>
                                <xsl:with-param name="category" select="."/>
                            </xsl:call-template>
                        </dd>
                    </xsl:if>
                </xsl:for-each>
            </dl>
        </xsl:when>
    </xsl:choose>
</xsl:template>


<xsl:template name="getCategoryName">
    <xsl:param name="of"/>
    <xsl:choose>
        <xsl:when test="$nts:settings/nts:value[@name ='CategoryNames']/nts:value[@name = $of]">
            <xsl:value-of select="$nts:settings/nts:value[@name ='CategoryNames']/nts:value[@name = $of]"/>
        </xsl:when>
        <xsl:otherwise>
            <xsl:value-of select="$of"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>


<xsl:template name="nidx:copy_oldest_created">
    <xsl:param name="nidx:targets_dom"/>

    <xsl:for-each select="$nidx:targets_dom">
        <xsl:sort select="./@timestamp" data-type="number"/>
            <xsl:if test="position() = 1">
                <xsl:copy-of select="./dcterms:created"/>
            </xsl:if>
    </xsl:for-each>
</xsl:template>

<xsl:template name="nidx:copy_latest_modified">
    <xsl:param name="nidx:targets_dom"/>

    <xsl:for-each select="$nidx:targets_dom/dcterms:created | $nidx:targets_dom/dcterms:modified | $nidx:targets_dom/nt:referredBy/nt:Trackback/nt:datetime | $nidx:targets_dom/nt:comments/nt:comment/nt:datetime">
        <xsl:sort select="php:function('Xnm_DataManager::parseW3cdtf', string(.))" order="descending"/>
        <xsl:if test="position() = 1">
            <dcterms:modified xsi:type="dcterms:W3CDTF">
                <xsl:value-of select="."/>
            </dcterms:modified>
        </xsl:if>
    </xsl:for-each>
</xsl:template>

</xsl:stylesheet>