<?php
/**
 * @author  Arielworks
 * @access public
 * @version 1.2.0
 * @license Public Domain
 */
class Hml_OutputDefinitionRss10 extends Hml_OutputDefinition {
    protected $formatType            = Hml_OutputDefinition::SIMPLE;
    protected $encoding              = "UTF-8";

    public function outputToHttp($outputUnit) {
        $msgBody = $this->makeMassageBody();
        $outputUnit->setMassageBody($msgBody);
        $outputUnit->setHeader("Content-Type", "application/rss+xml");
    }

    protected function makeMassageBody() {
        $resultDom = $this->transformSdf($this->sourceContainer);
        $resultDom->formatOutput = TRUE;
        $resultDom->encoding = "UTF-8";
        $resultStr = $resultDom->saveXML();
        return $resultStr;
    }

    protected function transformSdf($sourceContainer) {
        $domXsl = new Domdocument();
        $domXsl->load(dirname(__FILE__) . "/Hml_OutputDefinitionRss10/SdfToRss10.xsl");

        $xsltp = new XsltProcessor();
        $xsltp->importStyleSheet($domXsl);
        $xsltp->setParameter(NULL, "uri", "http://" . $_SERVER["HTTP_HOST"] . "/" . substr($_SERVER["REQUEST_URI"], 1));
        return $xsltp->transformToDoc($sourceContainer->getData());
    }

}
?>