<?php
/**
 * The container to store DOM Object and provide easy access method
 * 
 * @author Arielworks
 * @access public
 * @license Public Domain
 */
class Hml_DataContainer {
    /**
     * @access private
     */
    private $dataDom = NULL;
    private $dataXpath = NULL;

    /**
     * @return void
     * @access public
     */
    public function __construct() {
        $tmpl = new DomDocument();
        $tmpl->load(dirname(__FILE__) . "/SdfTemplate.xml");
        $this->setData($tmpl);
    }

    /**
     * @return void
     * @param DomDoument $newDataDom DomDocument to store
     * @access public
     */
    public function setData(DomDocument $newDataDom) {
        $this->dataDom = $newDataDom;
        $this->dataXpath = new DomXpath($this->dataDom);
        Hml_Util::registerBasicNs($this->dataXpath);
    }


    public function appendBodyData(DOMNode $fragment) {
        $fragmentNode = $this->dataDom->importNode($fragment, TRUE);
        $this->dataXpath->query("/sdf:document/sdf:body")->item(0)->appendChild($fragmentNode);
    }


    public function setId($newId) {
        $this->dataXpath->query("/sdf:document/sdf:meta")->item(0)->appendChild($this->dataDom->createElementNS(Hml_Util::getNsUri("sdf"), "sdf:id", $newId));
    }

    public function setTitle($newTitle) {
        $titleNode = $this->dataDom->importNode($newTitle, TRUE);
        $this->dataXpath->query("/sdf:document/sdf:meta/dc:title")->item(0)->appendChild($titleNode);
    }


    public function setCreatedDatetime($datetime) {
        if ($this->isW3cDtf($datetime)) {
            $this->dataXpath->query("/sdf:document/sdf:meta/dcterms:created")->item(0)->appendChild($this->dataDom->createTextNode($datetime));
        } else {
            throw new Exception("Given datetime are not W3CDTF fromat.");
        }
    }


    protected function isW3cdtf($str) {
        try {
            Hml_Util::parseW3cdtf($str);
            return TRUE;
        } catch(Exception $e) {
            return FALSE;
        }
    }

    /**
     * @return DomDocument
     * @access public
     */
    public function getData() {
        return $this->dataDom;
    }


    public function getTitle() {
    }


    public function getCreatedDatetime() {
        $nodeList = $this->dataXpath->query("//sdf:meta/dcterms:created");
        if ($nodeList->item(0)) {
            $createdMinTs = Hml_Util::parseW3cdtf($nodeList->item(0)->textContent);
            $createdMin = $nodeList->item(0)->textContent;
            for ($i = 1; $aCreated = $nodeList->item($i); $i++) {
                try{
                    $ts = Hml_Util::parseW3cdtf($aCreated->textContent);
                    if($ts < $createdMin) {
                        $createdMinTs = $ts;
                        $createdMin = $aCreated->textContent;
                    }
                } catch(Exception $e) {
                }
            }
            return $createdMin;
        } else {
            return NULL;
        }
    }


    public function getModifiedDatetime() {
        $nodeList = $this->dataXpath->query("//sdf:meta/dcterms:modified | //sdf:meta/dcterms:created");
        if ($nodeList->item(0)) {
            $modifiedMaxTs = Hml_Util::parseW3cdtf($nodeList->item(0)->textContent);
            $modifiedMax = $nodeList->item(0)->textContent;
            for ($i = 1; $aModified = $nodeList->item($i); $i++) {
                try{
                    $ts = Hml_Util::parseW3cdtf($aModified->textContent);
                    if($ts > $modifiedMax) {
                        $modifiedMaxTs = $ts;
                        $modifiedMax = $aModified->textContent;
                    }
                } catch(Exception $e) {
                }
            }
            return $modifiedMax;
        } else {
            return NULL;
        }
    }


    public function getCreator() {
    }

}
?>