<?php
/**
 * The class to load settings from the XML file and to provide methods to refer
 * them for the other classes
 * 
 * @author Arielworks
 * @license Public Domain
 */
class Xnm_SettingManager {
    /**
     * File path of the XML file that settings are saved in. Use relative path
     * from this class file.
     * @access private
     */
    private $filePath = "/settings.xml";

    /**
     * Namespace URI of the settings-XML document.
     * @access private
     */
    private $settingsNs = "http://www.arielworks.net/works/codeyard/himmel/xnm/settings";

    /**
     * Array to store the loaded settings.
     * @access private
     */
    private $settings = array();

    /**
     * The instance of this class for the static methods.
     * @access private
     */
    static private $instance = NULL;



    /**
     * Constructor, parses the XML file.
     * @access private
     */
    private function __construct() {
        $stgDom = new DomDocument();
        $stgDom->load(dirname(__FILE__) . $this->filePath);
        $this->settings = $this->parseElement($stgDom->firstChild);
    }


    /**
     * Return the instance of this class. (internal) Singleton pattern.
     * @access private
     */
    static private function getInstance() {
        if (self::$instance == NULL) {
            self::$instance = new Xnm_SettingManager;
        }
        return self::$instance;
    }


    /**
     * Return the value of the asked field.
     * @access public
     * @param string name Name of the field that you want value of.
     */
    static function getValue($name) {
        $sm = self::getInstance();
        return $sm->settings[$name];
    }


    /**
     * Method to parse Elements of the XML file.
     * @access protected
     * @param DomNode targetNode DomNode to parse.
     */
    protected function parseElement($targetNode) {
        $values = $targetNode->getElementsByTagName("value");
        if ($values->item(0)) {
            $result = array();
            for ($i = 0; $aValue = $values->item($i); $i++) {
                if ($targetNode->isSameNode($aValue->parentNode)) {
                    $result[$aValue->getAttribute("name")] = $this->parseElement($aValue);
                }
            }
            return $result;
        } else {
            return $targetNode->textContent;
        }
    }
}
?>