<?php
class Xnm_ItratorToBuildIndexFileSystemRNote extends Xnm_ItratorToBuildIndexFileSystem {

    public function __construct($dataDirectory) {
        parent::__construct($dataDirectory);
    }


    public function next() {
        $result = parent::next();
        $dom = $result["note"];

        $xp = new DomXpath($dom);
        $xp->registerNamespace("rnote", "http://rinn.e-site.jp/rnote/");
        if ($xp->query("/rnote:rNote")->item(0)) {
            $domXsl = new DomDocument();
            $domXsl->load("RNoteToXnm.xsl");
            $xsltp = new XsltProcessor();
            $xsltp->importStyleSheet($domXsl);
            $dom = $xsltp->transformToDoc($dom);
        }

        $result["note"] = $dom;
        return $result;
    }
}
?>