<?php
abstract class Xnm_DataController {
    protected $timezoneOffset = 0;
    protected $index = NULL;
    protected $indexXpath = NULL;


    public function __construct($newTimezoneOffset) {
        $this->timezoneOffset = $newTimezoneOffset;
        $this->buildIndex();
        $this->indexXpath = new DomXpath($this->index);
        Hml_Util::registerBasicNs($this->indexXpath);
    }


    public function getIndex() {
        return $this->index; 
    }


    public function saveTrackBack($targetId, $uri, $blogName, $title, $excerpt) {
        if ($internalId = $this->indexXpath->query("/nidx:index/nidx:year/nidx:month/nidx:day/nidx:note[@id = '$targetId']")->item(0)) {
            $tbDom = new DomDocument();
            $tbDom->preserveWhiteSpace = FALSE;
            $tbDom->formatOutput = TRUE;
            $tbDom->encoding = "UTF-8";
            if ($this->readTrackBack($targetId, $tbDom)) {
                $rootNd = $tbDom->documentElement;
            } else {
                $rootNd = $tbDom->appendChild($tbDom->createElementNS(Hml_Util::getNsUri("nt"), "referredBy"));
            }
            $tbNd = $rootNd->appendChild($tbDom->createElementNS(Hml_Util::getNsUri("nt"), "Trackback"));
            $tbNd->setAttribute("uri", $uri);
            $tbNd->appendChild($tbDom->createElementNS(Hml_Util::getNsUri("nt"), "blogName", $blogName));
            $tbNd->appendChild($tbDom->createElementNS(Hml_Util::getNsUri("nt"), "title", $title));
            $tbNd->appendChild($tbDom->createElementNS(Hml_Util::getNsUri("nt"), "excerpt", $excerpt));
            $localDt = gmdate("Y-m-d\TH:i:s", gmmktime(gmdate("H"), gmdate("i") + $this->timezoneOffset, gmdate("s"), gmdate("m"), gmdate("d"), gmdate("Y")));
            if ($this->timezoneOffset == 0) {
                $localDt .= "Z";
            } elseif ($this->timezoneOffset > 0) {
                $localDt .= sprintf("+%02d:%02d", $this->timezoneOffset / 60, $this->timezoneOffset % 60);
            } else {
                $localDt .= sprintf("-%02d:%02d", (-1 *$this->timezoneOffset) / 60, (-1 * $this->timezoneOffset) % 60);
            }
            $dtNd = $tbNd->appendChild($tbDom->createElementNS(Hml_Util::getNsUri("nt"), "datetime", $localDt));
            $this->writeTrackBack($targetId, $tbDom);
            $this->buildIndex(TRUE);
        } else {
            throw new Exception("Target Not Found");
        }
    }


    abstract protected function writeTrackBack($targetId, $dom);
    abstract protected function readTrackBack($targetId, $dom);


    public function saveComment($targetId, $name, $identifier, $message) {
        if ($internalId = $this->indexXpath->query("/nidx:index/nidx:year/nidx:month/nidx:day/nidx:note[@id = '$targetId']")->item(0)) {
            $cmtDom = new DomDocument;
            $cmtDom->preserveWhiteSpace = FALSE;
            $cmtDom->formatOutput = TRUE;
            $cmtDom->encoding = "UTF-8";
            if ($this->readComment($targetId, $cmtDom)) {
                $rootNd = $cmtDom->documentElement;
            } else {
                $rootNd = $cmtDom->appendChild($cmtDom->createElementNS(Hml_Util::getNsUri("nt"), "comments"));
            }
            $cmtNd = $rootNd->appendChild($cmtDom->createElementNS(Hml_Util::getNsUri("nt"), "comment"));
            $cmtNd->appendChild($cmtDom->createElementNS(Hml_Util::getNsUri("nt"), "name", $name));
            $cmtNd->appendChild($cmtDom->createElementNS(Hml_Util::getNsUri("nt"), "identifier", $identifier));
            $cmtNd->appendChild($cmtDom->createElementNS(Hml_Util::getNsUri("nt"), "message", $message));
            $localDt = gmdate("Y-m-d\TH:i:s", gmmktime(gmdate("H"), gmdate("i") + $this->timezoneOffset, gmdate("s"), gmdate("m"), gmdate("d"), gmdate("Y")));
            if ($this->timezoneOffset == 0) {
                $localDt .= "Z";
            } elseif ($this->timezoneOffset > 0) {
                $localDt .= sprintf("+%02d:%02d", $this->timezoneOffset / 60, $this->timezoneOffset % 60);
            } else {
                $localDt .= sprintf("-%02d:%02d", (-1 *$this->timezoneOffset) / 60, (-1 * $this->timezoneOffset) % 60);
            }
            $cmtNd->appendChild($cmtDom->createElementNS(Hml_Util::getNsUri("nt"), "datetime", $localDt));
            $this->writeComment($targetId, $cmtDom);
            $this->buildIndex(TRUE);
        } else {
            throw new Exception("Target Not Found");
        }
    }


    abstract protected function writeComment($targetId, $dom);
    abstract protected function readComment($targetId, $dom);


    protected function buildIndex($forceClearCahce = FALSE) {
        $cachePath = dirname(__FILE__) . "/Temp/IndexCache.xml";
        if (file_exists($cachePath) && ! $forceClearCahce) {
            $indexCheck = new DomDocument();
            if (@$indexCheck->load($cachePath)) {
                if ($this->ifDataChanged(filemtime($cachePath))) {
                    // Changed
                    $result = $this->rebuildIndex();
                    $result->save($cachePath);
                } else {
                    // Not Changed
                    $result = $indexCheck;
                }
            } else {
                // Cache File Broken
                $result = $this->rebuildIndex();
                $result->save($cachePath);
            }
        } else {
            // Forced to clear or cache not existed
            $result = $this->rebuildIndex();
            $result->save($cachePath);
        }
        $this->index = $result;
    }


    protected function rebuildIndex() {
        $indexDom = new DomDocument();
        $indexDom->encoding = "UTF-8";
        $nodeIndex = $indexDom->appendChild($indexDom->createElementNS(Hml_Util::getNsUri("nidx"), "index"));

        $it = $this->getItratorToBuildIndex();
        $noteList = array();
        while ($it->hasNext()) {
            $newNote = $this->makeNoteNode($it->next(), $indexDom);
            $noteList[$newNote["year"]][$newNote["month"]][$newNote["day"]][$newNote["hour"] . $newNote["minute"] . $newNote["second"]] = $newNote["node"];

        }
        ksort($noteList);
        foreach ($noteList as $keyYear => $noteListYear) {
            $nodeYear = $nodeIndex->appendChild($indexDom->createElementNS(Hml_Util::getNsUri("nidx"), "year"));
            $nodeYear->setAttribute("num", $keyYear);
            ksort($noteListYear);
            foreach ($noteListYear as $keyMonth => $noteListMonth) {
                $nodeMonth = $nodeYear->appendChild($indexDom->createElementNS(Hml_Util::getNsUri("nidx"), "month"));
                $nodeMonth->setAttribute("num", $keyMonth);
                ksort($noteListMonth);
                foreach ($noteListMonth as $keyDay => $noteListDay) {
                    $nodeDay = $nodeMonth->appendChild($indexDom->createElementNS(Hml_Util::getNsUri("nidx"), "day"));
                    $nodeDay->setAttribute("num", $keyDay);
                    ksort($noteListDay);
                    foreach ($noteListDay as $keyHis => $aNote) {
                        $nodeIndivi = $nodeDay->appendChild($aNote);
                        $nodeIndivi->setAttribute("num", $keyHis);
                    }
                }
            }
        }
        return $indexDom;
    }


    private function makeNoteNode($note, $indexDom){
        $nodeNote = $indexDom->createElementNS(Hml_Util::getNsUri("nidx"), "note");
        $nodeNote->setAttribute("internal_id", $note["internalId"]);
        $nodeNote->setAttribute("internal_timestamp", $note["internalTimestamp"]);

        $noteDom = $note["note"];
        $noteXp = new DomXpath($noteDom);
        hml_Util::registerBasicNs($noteXp);
        $dtW3c = $noteXp->query("/nt:note/dcterms:created/text()")->item(0)->nodeValue;
        $dtTimestamp = Hml_Util::parseW3cdtf($dtW3c);
        $nodeNote->setAttribute("id", $dtTimestamp);

        $otherMetaElements = $noteXp->query("/nt:note/*[not(namespace-uri(.) = '" . Hml_Util::getNsUri("nt") .  "' and local-name() = 'body')]");
        for($i = 0; $otherMetaElements->item($i); $i++) {
            $nodeNote->appendChild($indexDom->importNode($otherMetaElements->item($i), TRUE));
        }
        if (! $categoryNd = $nodeNote->getElementsByTagNameNS(Hml_Util::getNsUri("nt"), "category")->item(0)) {
            $categoryNd = $nodeNote->appendChild($indexDom->createElementNS(Hml_Util::getNsUri("nt"), "category"));
        }
        $categoryNd->appendChild($indexDom->createElementNS(Hml_Util::getNsUri("nt"), "li"))->appendChild($indexDom->createTextNode("ALL"));

        if ($cmtDom = $note["comment"]) {
            $nodeNote->appendChild($indexDom->importNode($cmtDom->firstChild, TRUE));
        }
        if ($tbDom = $note["trackback"]) {
            $nodeNote->appendChild($indexDom->importNode($tbDom->firstChild, TRUE));
        }

        // Hack for date() and gmdate(); we can choose only GMT(UTC) or system local timezone. 
        $dtUserLocalTimestamp = gmmktime(gmdate("H", $dtTimestamp), gmdate("i", $dtTimestamp) + Xnm_SettingManager::getValue("TimezoneOffset"), gmdate("s", $dtTimestamp), gmdate("m", $dtTimestamp), gmdate("d", $dtTimestamp), gmdate("Y", $dtTimestamp));

        $result = array(
            "node" => $nodeNote,
            "year" => gmdate("Y", $dtUserLocalTimestamp),
            "month" => gmdate("m", $dtUserLocalTimestamp),
            "day" => gmdate("d", $dtUserLocalTimestamp),
            "hour" =>gmdate("H", $dtUserLocalTimestamp),
            "minute" =>gmdate("i", $dtUserLocalTimestamp),
            "second" =>gmdate("s", $dtUserLocalTimestamp)
        );

        return $result;
    }


    abstract protected function getItratorToBuildIndex();
}
?>