<?php
class Hml_IoManager {
    private $acceptList = array();
    private $requestedId = NULL;
    private $fileExtension = NULL;
    private $outputDefinition = NULL;

    private $extensionRuleList = array(
        "html" => "XHTML1.0",
        "rdf"  => "RSS1.0",
        "rss"  => "RSS1.0"
    );

    private $uaSpecialRule = array(
        "!MSIE6!"
    );

    private $contentTypeRuleList = array(
        "application/xhtml+xml" => array("XHTML1.1", "XHTML1.0"),
        "text/html"             => array("XHTML1.0"),
        "application/rss+xml"   => array("RSS1.0"),
        "application/rdf+xml"   => array("RSS1.0"),
        "application/xml"       => array("XHTML1.1", "XHTML1.0", "RSS1.0"),
        "text/xml"              => array("XHTML1.1", "XHTML1.0", "RSS1.0")
    );

    private $formatList = array(
        "XHTML1.1" => "Hml_OutputDefinitionXhtml11",
        "XHTML1.0" => "Hml_OutputDefinitionXhtml10",
        "RSS1.0"   => "Hml_OutputDefinitionRss10"
    );



    public function __construct($query) {

        $this->acceptList = $this->parseAccept($_SERVER["HTTP_ACCEPT"]);

        preg_match('!^(/(?:.*?/)*[^.]*)(?:\.(.+))?$!', $query, $qFragments);
        $this->requestedId = $qFragments[1];
        $this->fileExtension = $qFragments[2];

        $this->outputDefinition = $this->resolveOutputDefinition();
    }

    protected function parseAccept($acceptString) {
        $acceptList = array();
        $acceptListWithQuality = explode(",", $acceptString);
        foreach ($acceptListWithQuality as $anAccept) {
            $anAcceptFragments = explode(";", $anAccept);
            if ($anAcceptFragments[1] == "") {
                $quality = "1.0";
            } else {
                $quality = substr($anAcceptFragments[1], 2);
            }
            if (! array_key_exists($quality, $acceptList)) {
                $acceptList[$quality] = array($anAcceptFragments[0]);
            } else {
                $acceptList[$quality][] = $anAcceptFragments[0];
            }
        }
        krsort($acceptList);
        return $acceptList;
    }


    protected function resolveOutputDefinition() {
        $formatName = NULL;
        if ($this->fileExtension !== NULL) {
            if (array_key_exists($this->fileExtension, $this->extensionRuleList)) {
                $formatName = $this->extensionRuleList[$this->fileExtension];
            
            // Unkonwn Extesnsion
            } else {
                $formatName = NULL;
            }

        } else {
            foreach ($this->acceptList as $qLebel => $qCtList) {
                $currentFormatList = array();
                foreach ($qCtList as $aCt) {
                    if (array_key_exists($aCt, $this->contentTypeRuleList)) {
                        $currentFormatList += $this->contentTypeRuleList[$aCt];
                    }
                }
                $currentFormatList = array_values(array_unique($currentFormatList));

                foreach ($this->formatList as $aFormatName => $aFormatDef) {
                    if (array_search("XHTML1.1", $currentFormatList) !== FALSE){
                        $formatName = $aFormatName;
                        break 2;
                    }
                }
            }
            if (! $formatName) {
                $formatName = "XHTML1.0";
            }
        }

        if ($formatName !== NULL) {
            $defClassName = $this->formatList[$formatName];  
            $result = new $defClassName();
        } else {
            $result = NULL;
        }
        return $result;
    }

    public function getAcceptList($quality = NULL) {
        if ($quality !== NULL) {
            $result = $this->acceptList[$quality];
            $result = $result ? $result : NULL;
            return $result;
        } else {
            return $this->acceptList;
        }
        
    }

    public function getFileExtension() {
        return $this->fileExtension;
    }


    public function getOutputDefinition() {
        return $this->outputDefinition;
    }


    public function getRequestedId() {
        return $this->requestedId;
    }

    public function output($dataContainer, $statusCode = 200) {
        $hou = new Hml_HttpOutputUnit();
        $hou->setHeader("Vary", "Accept");
        $hou->setStatusCode($statusCode);
        if ($modified = Hml_Util::parseW3cdtf($dataContainer->getModifiedDatetime())) {
            $hou->setHeader("Last-Modified", gmdate("D, d M Y H:i:s", $modified) . " GMT");
        }
        $this->outputDefinition->setSource($dataContainer);
        $this->outputDefinition->outputToHttp($hou);
        $hod = new Hml_HttpOutputDirector();
        $hod->output($hou);
    }
}
?>