<?php
class Xnm_XmlNoteManager {
    private $timezoneOffset = 0;
    private $dataManager = NULL;


    public function __construct() {
        $this->timezoneOffset = Xnm_SettingManager::getValue("TimezoneOffset");

        $dmType = Xnm_SettingManager::getValue("DataStorage");
        try {
            Xnm_DataManager::initialize($dmType, $this->timezoneOffset);
        } catch (Exception $e) {
            $this->outputError($e->getMessage());
            exit();
        }
        $this->dataManager = Xnm_DataManager::getInstance();
    }


    public function excute() {
        $queryString = $_SERVER["PATH_INFO"];

        if ($queryString == "" && $_POST["action"] == "comment") {
            try {
                $this->recieveComment($_POST["target"], $_POST["name"], $_POST["identifier"], $_POST["message"]);
            } catch(Exception $e) {
                $this->outputError($e->getMessage());
            }
            try {
                $localTs = gmmktime(gmdate("H", $_POST["target"]), gmdate("i", $_POST["target"]) + $this->timezoneOffset, gmdate("s", $_POST["target"]), gmdate("m", $_POST["target"]), gmdate("d", $_POST["target"]), gmdate("Y", $_POST["target"]));
                $this->outputStandardResponse(gmdate("Y", $localTs), gmdate("m", $localTs), gmdate("d", $localTs), gmdate("H", $localTs), gmdate("i", $localTs), gmdate("s", $localTs));
            } catch(Exception $e) {
                $this->outputNotFound();
            }

        } elseif (preg_match('!(?:/([^/]+?))??/latest(\.rss)?!', $queryString, $queryFragments)) {
            if ($queryFragments[2]) {
                $this->outputLatestRss($qCategory ? $qCategory : "ALL");
            } else {
                $this->outputLatest($qCategory ? $qCategory : "ALL");
            }

        } elseif (preg_match('!^(?:/([^/]+?))??(?:/(\d{4})(?:/(0[1-9]|1[0-2])(?:/(0[1-9]|[12][0-9]|3[01])(?:/([01][0-9]|2[0-3])([0-5][0-9])([0-5][0-9]))?)?)?)?$!', $queryString, $queryFragments)) {
            array_shift($queryFragments);
            list($qCategory,$qYear, $qMonth, $qDay, $qHour, $qMinute, $qSecond) = $queryFragments;
            try {
                $this->outputStandardResponse($qYear, $qMonth, $qDay, $qHour, $qMinute, $qSecond, $qCategory ? $qCategory : "ALL");
            } catch(Exception $e) {
                $this->outputNotFound();
            }

        } elseif (preg_match('!^/(\d{4})/(0[1-9]|1[0-2])/(0[1-9]|[12][0-9]|3[01])/([01][0-9]|2[0-3])([0-5][0-9])([0-5][0-9])\.trackback$!', $queryString, $queryFragments)) {
            array_shift($queryFragments);
            list($qYear, $qMonth, $qDay, $qHour, $qMinute, $qSecond) = $queryFragments;
            $tgtTimestamp = gmmktime($qHour, $qMinute - $this->timezoneOffset, $qSecond, $qMonth, $qDay, $qYear);
            try {
                $this->recieveTrackbackAndResponse($tgtTimestamp, $_POST["url"], $_POST["title"], $_POST["blog_name"], $_POST["excerpt"]);
            } catch(Exception $e) {
                $this->outputError($e->getMessage());
            }
        } else {
            $this->outputNotFound();
        }
    }


    protected function outputStandardResponse($year = NULL, $month = NULL, $day = NULL, $hour = NULL, $minute = NULL, $second = NULL, $category = "ALL") {
        $indexDom = $this->dataManager->getIndex();
        $indexXp = new DomXpath($indexDom);
        Hml_Util::registerBasicNs($indexXp);

        $domXsl = new DomDocument();
        if ($second !== NULL) {
            if ($indexXp->query("/nidx:index/nidx:year[@num = '$year']/nidx:month[@num = '$month']/nidx:day[@num = '$day']/nidx:note[@num = '$hour$minute$second']")->item(0)) {
                $domXsl->load(dirname(__FILE__) . "/IndexToSdfIndividual.xsl");
            } else {
                throw new Exception ("TargetNotFound");
            }
        } elseif ($day !== NULL) {
            if ($indexXp->query("/nidx:index/nidx:year[@num = '$year']/nidx:month[@num = '$month']/nidx:day[@num = '$day' and nidx:note/nt:category/nt:li = '$category']")->item(0)) {
                $domXsl->load(dirname(__FILE__) . "/IndexToSdfDaily.xsl");
            } else {
                throw new Exception ("TargetNotFound");
            }
        } elseif ($month !== NULL) {
            if ($indexXp->query("/nidx:index/nidx:year[@num = '$year']/nidx:month[@num = '$month' and nidx:day/nidx:note/nt:category/nt:li = '$category']")->item(0)) {
                $domXsl->load(dirname(__FILE__) . "/IndexToSdfMonthly.xsl");
            } else {
                throw new Exception ("TargetNotFound");
            }
        } elseif ($year !== NULL) {
            if ($indexXp->query("/nidx:index/nidx:year[@num = '$year' and nidx:month/nidx:day/nidx:note/nt:category/nt:li = '$category']")->item(0)) {
                $domXsl->load(dirname(__FILE__) . "/IndexToSdfYearly.xsl");
            } else {
                throw new Exception ("TargetNotFound");
            }
        } else {
            $domXsl->load(dirname(__FILE__) . "/IndexToSdfHome.xsl");
        }

        $xsltp = new XsltProcessor();
        $xsltp->registerPhpFunctions();
        $xsltp->setParameter(Hml_Util::getNsUri("idx"), "category", $category);
        $xsltp->setParameter(Hml_Util::getNsUri("idx"), "year", $year);
        $xsltp->setParameter(Hml_Util::getNsUri("idx"), "month", $month);
        $xsltp->setParameter(Hml_Util::getNsUri("idx"), "day", $day);
        $xsltp->setParameter(Hml_Util::getNsUri("idx"), "hour", $hour);
        $xsltp->setParameter(Hml_Util::getNsUri("idx"), "minute", $minute);
        $xsltp->setParameter(Hml_Util::getNsUri("idx"), "second", $second);
        $xsltp->importStyleSheet($domXsl);
        $sdfDom = $xsltp->transformToDoc($indexDom);

        $hml = new Hml_Himmel("XmlNoteManager");
        $dc = $hml->getDataContainer();
        $dc->setData($sdfDom);
        $hml->excute($dc);
    }


    protected function outputLatest($category = "ALL") {
        $indexDom = $this->dataManager->getIndex();

        $domXsl = new DomDocument();
        $domXsl->load(dirname(__FILE__) . "/IndexToSdfLatest.xsl");
        $xsltp = new XsltProcessor();
        $xsltp->setParameter(Hml_Util::getNsUri("nidx"), "category", $category);
        $xsltp->registerPhpFunctions();
        $xsltp->importStyleSheet($domXsl);
        $sdfDom = $xsltp->transformToDoc($indexDom);

        $hml = new Hml_Himmel("XmlNoteManager");
        $dc = $hml->getDataContainer();
        $dc->setData($sdfDom);
        $hml->excute($dc);
    }


    protected function outputLatestRss($category = "ALL") {
        $indexDom = $this->dataManager->getIndex();

        $domXsl = new DomDocument();
        $domXsl->load(dirname(__FILE__) . "/IndexToRss.xsl");
        $xsltp = new XsltProcessor();
        $xsltp->setParameter(Hml_Util::getNsUri("nidx"), "category", $category);
        $xsltp->registerPhpFunctions();
        $xsltp->importStyleSheet($domXsl);
        $rssDom = $xsltp->transformToDoc($indexDom);
        $rssDom->preserveWhiteSpace = FALSE;
        $rssDom->formatOutput = TRUE;
        $rssDom->encoding = "UTF-8";

        $rssXp = new DomXpath($rssDom);
        Hml_Util::registerBasicNs($rssXp);
        $dateList = $rssXp->query("/rdf:RDF/rss:item/dc:date");
        $lastModified = 0;
        for($i = 0; $aDate = $dateList->item($i); $i++) {
            if (Hml_Util::parseW3cdtf($aDate->nodeValue) > $lastModified) {
                $lastModified = $aDate->nodeValue;
            }
        }

        // HACK HIMMEL CORE...
        $hou = new Hml_HttpOutputUnit();
        $hou->setStatusCode(200);
        $hou->setHeader("Last-Modified", gmdate("D, d M Y H:i:s", $lastModified) . " GMT");
        $hou->setHeader("Content-Type", "application/rss+xml");
        $hou->setMassageBody($rssDom->saveXml());

        $hod = new Hml_HttpOutputDirector();
        $hod->output($hou);

    }

    protected function recieveTrackbackAndResponse($targetId, $url, $title, $blogName, $excerpt) {
        // Except "&", do not HTML-sanitize these inputs now, leave to DomDocument.
        $url = str_replace("&", "&amp;", $url);
        $title = str_replace("&", "&amp;", $title);
        $blogName = str_replace("&", "&amp;", $blogName);
        $excerpt = str_replace("&", "&amp;", $excerpt);

        header("Content-Type: text/xml");
        print '<?xml version="1.0" encoding="UTF-8"?>';

        if (! $url || strlen($url) > 256) {
            print '<response><error>1</error><message>URI NOT VALID</message></response>';
        } elseif (strlen($title) > 256) {
            print '<response><error>1</error><message>TITLE TOO LONG</message></response>';
        } elseif (strlen($blogName) > 256) {
            print '<response><error>1</error><message>BLOG NAME TOO LONG</message></response>';
        } elseif (strlen($excerpt) > 256) {
            print '<response><error>1</error><message>EXCERPT TOO LONG</message></response>';
        } else {
            try {
                $this->dataManager->saveTrackBack($targetId, $url, $title, $blogName, $excerpt);
                print '<response><error>0</error></response>';
            } catch (Exception $e) {
                print "<response><error>1</error><message>EXCEPTION</message></response>";
            }
        }
    }


    protected function recieveComment($targetId, $name, $identifier, $message) {
        // Except "&", do not HTML-sanitize these inputs now, leave to DomDocument.
        $name = str_replace("&", "&amp;", $name);
        $identifier = str_replace("&", "&amp;", $identifier);
        $message = str_replace("&", "&amp;", $message);

        if (strlen($name) > 256) {
            exit("namae nagasugi");
        } elseif (strlen($identifier) > 256) {
            exit("Identifier nagasugi");
        } elseif (! $message) {
            exit("message ne");
        } elseif (strlen($message) > 1024) {
            exit("message nagasugi");
        } else {
            try {
                $this->dataManager->saveComment($targetId, $name, $identifier, $message);
            } catch (Exception $e) {
                throw $e;
            }
        }
    }


    protected function outputError($msg) {
        $hml = new Hml_Himmel("XmlNoteManager");
        $dc = $hml->getDataContainer();
        $sdfDom = new DomDocument();
        $sdfDom->load("xnm/error.xml");
        $sdfDom->getElementsByTagNameNS(Hml_Util::getNsUri("xh"), "p")->item(0)->appendChild($sdfDom->createTextNode(str_replace("&", "&amp;", $msg)));
        $dc->setData($sdfDom);
        $hml->excute($dc);
    }


    protected function outputNotFound() {
        $hml = new Hml_Himmel("XmlNoteManager");
        $dc = $hml->getDataContainer();
        $sdfDom = new DomDocument();
        $sdfDom->load("xnm/404.xml");
        $dc->setData($sdfDom);
        $hml->excute($dc);
    }
}
?>