<?php
class Xnm_SettingManager {
    private $filePath = "/settings.xml";
    private $settingsNs = "http://www.arielworks.net/works/codeyard/himmel/xnm/settings";
    private $settings = array();
    static private $instance = NULL;

    private function __construct() {
        $stgDom = new DomDocument();
        $stgDom->load(dirname(__FILE__) . $this->filePath);
        $this->settings = $this->parseElement($stgDom->firstChild);
    }

    static private function getInstance() {
        if (self::$instance == NULL) {
            self::$instance = new Xnm_SettingManager;
        }
        return self::$instance;
    }

    static function getValue($name) {
        $sm = self::getInstance();
        return $sm->settings[$name];
    }

    protected function parseElement($targetNode) {
        $values = $targetNode->getElementsByTagName("value");
        if ($values->item(0)) {
            $result = array();
            for ($i = 0; $aValue = $values->item($i); $i++) {
                if ($targetNode->isSameNode($aValue->parentNode)) {
                    $result[$aValue->getAttribute("name")] = $this->parseElement($aValue);
                }
            }
            return $result;
        } else {
            return $targetNode->textContent;
        }
    }

}

?>