<?php
class Xnm_ItratorToBuildIndexFileSystem {
    private $fileList = array();
    private $pointer = 0;

    public function __construct($newFileList) {
        $this->fileList = $newFileList;
    }

    public function next() {
        $internalId = $this->fileList[$this->pointer];
        $this->pointer++;
        $result = $this->makeNoteSet($internalId);
        return $result;
    }

    protected function makeNoteSet($internalId) {
        $internalTimestamp = filemtime($internalId . ".xnm");
        $noteDom = new DomDocument();
        $noteDom->load($internalId . ".xnm");
        if (file_exists($internalId . ".tb")) {
            $tbDom = new DomDocument();
            $tbDom->load($internalId . ".tb");
            $tbTimestamp = filemtime($internalId . ".tb");
            if ($tbTimestamp > $internalTimestamp) {
                $internalTimestamp = $tbTimestamp;
            }
        } else {
            $tbDom = NULL;
        }
        if (file_exists($internalId . ".cmt")) {
            $cmtDom = new DomDocument();
            $cmtDom->load($internalId . ".cmt");
            $cmtTimestamp = filemtime($internalId . ".cmt");
            if ($cmtTimestamp > $internalTimestamp) {
                $internalTimestamp = $cmtTimestamp;
            }
        } else {
            $cmtDom = NULL;
        }
        $result = array(
            "internalId" => $internalId,
            "internalTimestamp" => $internalTimestamp,
            "note" => $noteDom,
            "comment" => $cmtDom,
            "trackback" => $tbDom
        );
        return $result;
    }

    public function hasNext() {
        if ($this->pointer < count($this->fileList)) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
}
?>