<?php
class Xnm_DataControllerFileSystem extends Xnm_DataController {
    protected $dataDirectory;
    protected $noteList = NULL;

    public function __construct($newTimezoneOffset) {
        $this->dataDirectory = Xnm_SettingManager::getValue("DataDirectory");
        $this->noteList = $this->makeFileList($this->dataDirectory);
        parent::__construct($newTimezoneOffset);
    }

    protected function getItratorToBuildIndex() {
        return new Xnm_ItratorToBuildIndexFileSystem($this->noteList); 
    }

    protected function ifDataChanged($latestTimestamp) {
        $fileList = $this->noteList;
        $tList = array();
        clearstatcache();
        foreach ($fileList as $filePath) {
            $tList[] = filemtime($filePath . ".xnm");
            if (file_exists($filePath . ".cmt")) {
                $tList[] = filemtime($filePath . ".cmt");
            }
            if (file_exists($filePath . ".tb")) {
                $tList[] = filemtime($filePath . ".tb");
            }
        }
        if ($latestTimestamp <= max($tList)) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function readNote($id) {
        $targetDom = new DomDocument();
        $internalId = $this->transformToInternalId($id);
        if ($targetDom->load($internalId . ".xnm")) {
            return $targetDom;
        } else{
            return new Exception("FileNotFound");
        }
    }

    protected function writeTrackBack($id, $dom) {
        $internalId = $this->transformToInternalId($id);
        if (@$dom->save($internalId . ".tb")) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    protected function readTrackBack($id, $dom) {
        $internalId = $this->transformToInternalId($id);
        if (file_exists($internalId . ".tb")) {
            $dom->load($internalId . ".tb");
            return $dom;
        } else {
            return FALSE;
        } 
    }

    protected function writeComment($id, $dom) {
        $internalId = $this->transformToInternalId($id);
        if (@$dom->save($internalId . ".cmt")) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
    protected function readComment($id, $dom) {
        $internalId = $this->transformToInternalId($id);
        if (file_exists($internalId . ".cmt")) {
            $dom->load($internalId . ".cmt");
            return $dom;
        } else {
            return FALSE;
        } 
    }

    protected function transformToInternalId($id) {
        $internalId = $this->indexXpath->query("/nidx:index/nidx:year/nidx:month/nidx:day/nidx:note[@id = '$id']/@internal_id")->item(0)->nodeValue;
        return $internalId;
    }

    protected function makeFileList($targetDir) {
        $fileList = array();
        if ($dir = opendir($targetDir)) {
            while (FALSE !== ($currentTgt = readdir($dir))) {
                if ($currentTgt != "." && $currentTgt != "..") {
                    if (is_dir($targetDir . "/" . $currentTgt)) {
                        $fileList = array_merge($fileList, $this->makeFileList($targetDir . "/" . $currentTgt));
                    } elseif (preg_match('/(.+)\.xnm/', $currentTgt, $tgtFragments)) {
                        $filePath = $targetDir . "/" . $tgtFragments[1];
                        $fileList[] = $filePath;
                    }
                }
            }
            closedir($dir);
        } else {
            throw new Exception("Directory open Error: " . $targetDir);
        }
        return $fileList;
    }
}
?>