<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns:php="http://php.net/xsl"
                              xmlns="http://purl.org/rss/1.0/"
                              xmlns:content="http://purl.org/rss/1.0/modules/content/"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/"
                              xmlns:nt="http://www.arielworks.net/works/codeyard/himmel/xnm"
                              xmlns:nts="http://www.arielworks.net/works/codeyard/himmel/xnm/settings"
                              xmlns:nidx="http://www.arielworks.net/works/codeyard/himmel/xnm/index"
                              exclude-result-prefixes="xh php dcterms nt nidx nts">

<xsl:include href="IndexToSdfUtil.xsl"/>

<xsl:template match="/nidx:index">
    <rdf:RDF>
        <channel rdf:about="{concat($nts:settings/nts:value[@name = 'WebPrefix'], $nts:settings/nts:value[@name = 'RootPath'], 'latset.rss')}">
            <title>
                <xsl:value-of select="$nts:settings/nts:value[@name = 'SiteName']"/>
                <xsl:text>::Latest Notes</xsl:text>
            </title>
            <description>
                <xsl:value-of select="$nts:settings/nts:value[@name = 'SiteName']"/>
                <xsl:text>に最近登録された記事15件分</xsl:text>
            </description>
            <link>
                <xsl:value-of select="$nts:settings/nts:value[@name = 'WebPrefix']"/>
                <xsl:value-of select="$nts:settings/nts:value[@name = 'RootPath']"/>
            </link>
            <items>
                <rdf:Seq>
                    <xsl:for-each select="/nidx:index/nidx:year/nidx:month/nidx:day/nidx:note[nt:category/nt:li = $nidx:category]">
                        <xsl:sort select="./@id" data-type="number" order="descending"/>
                        <xsl:if test="position() &lt;= 15">
                            <rdf:li rdf:resource="{concat($nts:settings/nts:value[@name = 'WebPrefix'], $nts:settings/nts:value[@name = 'RootPath'], '/', ancestor::nidx:year/@num, '/', ancestor::nidx:month/@num, '/', ancestor::nidx:day/@num, '/', ./@num)}"/>
                        </xsl:if>
                    </xsl:for-each>
                </rdf:Seq>
            </items>
        </channel>

        <xsl:for-each select="/nidx:index/nidx:year/nidx:month/nidx:day/nidx:note[nt:category/nt:li = $nidx:category]">
            <xsl:sort select="./@id" data-type="number" order="descending"/>
            <xsl:if test="position() &lt;= 15">
                <xsl:variable name="content" select="php:function('Xnm_DataManager::loadNote', string(./@id))"/>
                <item rdf:about="{concat($nts:settings/nts:value[@name = 'WebPrefix'], $nts:settings/nts:value[@name = 'RootPath'], '/', ancestor::nidx:year/@num, '/', ancestor::nidx:month/@num, '/', ancestor::nidx:day/@num, '/', ./@num)}">
                    <title>
                        <xsl:value-of select="./dc:title"/>
                    </title>
                    <description>
                        <xsl:value-of select="$content/nt:note/nt:body/descendant::xh:p[text()][1]"/>
                    </description>
                    <content:encoded>
                        <xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
                        <xsl:apply-templates select="$content/nt:note/nt:body/node()" mode="toEncoded"/>
                        <xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
                    </content:encoded>
                    <link>
                        <xsl:value-of select="concat($nts:settings/nts:value[@name = 'WebPrefix'], $nts:settings/nts:value[@name = 'RootPath'], '/', ancestor::nidx:year/@num, '/', ancestor::nidx:month/@num, '/', ancestor::nidx:day/@num, '/', ./@num)"/>
                    </link>
                    <dc:date>
                        <xsl:value-of select="./dcterms:created"/>
                    </dc:date>
                </item>
            </xsl:if>
        </xsl:for-each>

    </rdf:RDF>
</xsl:template>

<!-- 要素は基本的にコピー -->
<xsl:template match="*" mode="toEncoded">
    <xsl:element name="{local-name()}">
        <xsl:apply-templates select="@*" mode="toEncoded"/>
        <xsl:apply-templates mode="toEncoded"/>
    </xsl:element>
</xsl:template>

<!-- 属性は基本的にコピー -->
<xsl:template match="@*" mode="toEncoded">
    <xsl:copy-of select="."/>
</xsl:template>

</xsl:stylesheet>