<?php
abstract class Xnm_DataController {
    protected $index;
    protected $indexXpath;

    public function __construct($forceClearCahce = FALSE) {
        $this->buildIndex($forceClearCahce);
        $this->indexXpath = new DomXpath($this->index);
        Hml_Util::registerBasicNs($this->indexXpath);
    }

    public function getIndex() {
        return $this->index; 
    }

    public function saveTrackBack($targetId, $uri, $blogName, $title, $excerpt) {
        if ($tbDom = $this->readTrackBack($targetId)) {
            $rootNd = $tbDom->firstChild;
        } else {
            $tbDom = new DomDocument();
            $rootNd = $tbDom->appendChild($tbDom->createElementNS(Hml_Util::getNsUri("nt"), "referredBy"));
        }
        $tbDom->encoding = "UTF-8";
        $rootNd->appendChild($tbDom->createTextNode("\n    "));
        $tbNd = $rootNd->appendChild($tbDom->createElementNS(Hml_Util::getNsUri("nt"), "Trackback"));
        $tbNd->setAttribute("uri", $uri);
        $tbNd->appendChild($tbDom->createTextNode("\n        "));
        $bnNd = $tbNd->appendChild($tbDom->createElementNS(Hml_Util::getNsUri("nt"), "blogName"));
        $bnNd->appendChild($tbDom->createTextNode($blogName));
        $tbNd->appendChild($tbDom->createTextNode("\n        "));
        $titleNd = $tbNd->appendChild($tbDom->createElementNS(Hml_Util::getNsUri("nt"), "title"));
        $titleNd->appendChild($tbDom->createTextNode($title));
        $tbNd->appendChild($tbDom->createTextNode("\n        "));
        $exptNd = $tbNd->appendChild($tbDom->createElementNS(Hml_Util::getNsUri("nt"), "excerpt"));
        $exptNd->appendChild($tbDom->createTextNode($excerpt));
        $tbNd->appendChild($tbDom->createTextNode("\n        "));
        $dtNd = $tbNd->appendChild($tbDom->createElementNS(Hml_Util::getNsUri("nt"), "datetime"));
        $localDt = gmdate("Y-m-d\TH:i:s", gmmktime(gmdate("H"), gmdate("i") + 540, gmdate("s"), gmdate("m"), gmdate("d"), gmdate("Y"))) . "+09:00";
        $dtNd->appendChild($tbDom->createTextNode($localDt));
        $tbNd->appendChild($tbDom->createTextNode("\n     "));
        $rootNd->appendChild($tbDom->createTextNode("\n"));
        $this->writeTrackBack($targetId, $tbDom);
        $this->rebuildIndex();
        return TRUE;
    }

    abstract protected function writeTrackBack($targetTimestamp, $dom);
    abstract protected function readTrackBack($targetTimestamp);

    public function saveComment($targetId, $name, $identifier, $message) {
        if ($cmtDom = $this->readComment($targetId)) {
            $rootNd = $cmtDom->firstChild;
        } else {
            $cmtDom = new DomDocument();
            $rootNd = $cmtDom->appendChild($cmtDom->createElementNS(Hml_Util::getNsUri("nt"), "comments"));
        }
        $cmtDom->encoding = "UTF-8";
        $rootNd->appendChild($cmtDom->createTextNode("\n    "));
        $cmtNd = $rootNd->appendChild($cmtDom->createElementNS(Hml_Util::getNsUri("nt"), "comment"));
        $cmtNd->appendChild($cmtDom->createTextNode("\n        "));
        $nNd = $cmtNd->appendChild($cmtDom->createElementNS(Hml_Util::getNsUri("nt"), "name"));
        $nNd->appendChild($cmtDom->createTextNode($name));
        $cmtNd->appendChild($cmtDom->createTextNode("\n        "));
        $idNd = $cmtNd->appendChild($cmtDom->createElementNS(Hml_Util::getNsUri("nt"), "identifier"));
        $idNd->appendChild($cmtDom->createTextNode($identifier));
        $cmtNd->appendChild($cmtDom->createTextNode("\n        "));
        $msgNd = $cmtNd->appendChild($cmtDom->createElementNS(Hml_Util::getNsUri("nt"), "message"));
        $msgNd->appendChild($cmtDom->createTextNode($message));
        $cmtNd->appendChild($cmtDom->createTextNode("\n        "));
        $dtNd = $cmtNd->appendChild($cmtDom->createElementNS(Hml_Util::getNsUri("nt"), "datetime"));
        $localDt = gmdate("Y-m-d\TH:i:s", gmmktime(gmdate("H"), gmdate("i") + 540, gmdate("s"), gmdate("m"), gmdate("d"), gmdate("Y"))) . "+09:00";
        $dtNd->appendChild($cmtDom->createTextNode($localDt));
        $cmtNd->appendChild($cmtDom->createTextNode("\n     "));
        $rootNd->appendChild($cmtDom->createTextNode("\n"));
        $this->writeComment($targetId, $cmtDom);
        $this->rebuildIndex();
        return TRUE;
    }

    protected function buildIndex($forceClearCahce) {
        $cachePath = "./Temp/IndexCache.xml";
        if (file_exists($cachePath) && ! $forceClearCahce) {
            $indexCheck = new DomDocument();
            if (@$indexCheck->load($cachePath)) {
                if ($this->ifDataChanged(filemtime($cachePath))) {
                    // Changed
                    $result = $this->rebuildIndex();
                    $result->save($cachePath);
                } else {
                    // Not Changed
                    $result = $indexCheck;
                }
            } else {
                // Cache File Broken
                $result = $this->rebuildIndex();
                $result->save($cachePath);
            }
        } else {
            // Forced to clear or cache not existed
            $result = $this->rebuildIndex();
            $result->save($cachePath);
        }
        $this->index = $result;
    }

    protected function rebuildIndex() {
        $indexDom = new DomDocument();
        $indexDom->encoding = "UTF-8";
        $nodeIndex = $indexDom->appendChild($indexDom->createElementNS(Hml_Util::getNsUri("nidx"), "index"));

        $it = $this->getItratorToBuildIndex();
        $noteList = array();
        while ($it->hasNext()) {
            $newNote = $this->makeNoteNode($it->next(), $indexDom);
            $noteList[$newNote["year"]][$newNote["month"]][$newNote["day"]][$newNote["hour"] . $newNote["minute"] . $newNote["second"]] = $newNote["node"];

        }
        ksort($noteList);
        foreach ($noteList as $keyYear => $noteListYear) {
            $nodeYear = $nodeIndex->appendChild($indexDom->createElementNS(Hml_Util::getNsUri("nidx"), "year"));
            $nodeYear->setAttribute("num", $keyYear);
            ksort($noteListYear);
            foreach ($noteListYear as $keyMonth => $noteListMonth) {
                $nodeMonth = $nodeYear->appendChild($indexDom->createElementNS(Hml_Util::getNsUri("nidx"), "month"));
                $nodeMonth->setAttribute("num", $keyMonth);
                ksort($noteListMonth);
                foreach ($noteListMonth as $keyDay => $noteListDay) {
                    $nodeDay = $nodeMonth->appendChild($indexDom->createElementNS(Hml_Util::getNsUri("nidx"), "day"));
                    $nodeDay->setAttribute("num", $keyDay);
                    ksort($noteListDay);
                    foreach ($noteListDay as $keyHis => $aNote) {
                        $nodeIndivi = $nodeDay->appendChild($aNote);
                        $nodeIndivi->setAttribute("num", $keyHis);
                    }
                }
            }
        }
        return $indexDom;
    }

    private function makeNoteNode($note, $indexDom){
        $nodeNote = $indexDom->createElementNS(Hml_Util::getNsUri("nidx"), "note");
        $nodeNote->setAttribute("internal_id", $note["internalId"]);
        $nodeNote->setAttribute("internal_timestamp", $note["internalTimestamp"]);

        $noteDom = $note["note"];
        $noteXp = new DomXpath($noteDom);
        hml_Util::registerBasicNs($noteXp);
        $dtW3c = $noteXp->query("/nt:note/dcterms:created/text()")->item(0)->nodeValue;
        $dtTimestamp = Hml_Util::parseW3cdtf($dtW3c);
        $nodeNote->setAttribute("id", $dtTimestamp);

        $otherMetaElements = $noteXp->query("/nt:note/*[not(namespace-uri(.) = '" . Hml_Util::getNsUri("nt") .  "' and local-name() = 'body')]");
        for($i = 0; $otherMetaElements->item($i); $i++) {
            $nodeNote->appendChild($indexDom->importNode($otherMetaElements->item($i), TRUE));
        }
        if (! $categoryNd = $nodeNote->getElementsByTagNameNS(Hml_Util::getNsUri("nt"), "category")->item(0)) {
            $categoryNd = $nodeNote->appendChild($indexDom->createElementNS(Hml_Util::getNsUri("nt"), "category"));
        }
        $categoryNd->appendChild($indexDom->createElementNS(Hml_Util::getNsUri("nt"), "li"))->appendChild($indexDom->createTextNode("ALL"));
        
        if ($cmtDom = $note["comment"]) {
            $nodeNote->appendChild($indexDom->importNode($cmtDom->firstChild, TRUE));
        }
        if ($tbDom = $note["trackback"]) {
            $nodeNote->appendChild($indexDom->importNode($tbDom->firstChild, TRUE));
        }

        // Hack for date() and gmdate(); we can choose only GMT(UTC) or system local timezone. 
        $dtUserLocalTimestamp = gmmktime(gmdate("H", $dtTimestamp), gmdate("i", $dtTimestamp) + 540, gmdate("s", $dtTimestamp), gmdate("m", $dtTimestamp), gmdate("d", $dtTimestamp), gmdate("Y", $dtTimestamp));

        $result = array(
            "node" => $nodeNote,
            "year" => gmdate("Y", $dtUserLocalTimestamp),
            "month" => gmdate("m", $dtUserLocalTimestamp),
            "day" => gmdate("d", $dtUserLocalTimestamp),
            "hour" =>gmdate("H", $dtUserLocalTimestamp),
            "minute" =>gmdate("i", $dtUserLocalTimestamp),
            "second" =>gmdate("s", $dtUserLocalTimestamp)
        );

        return $result;
    }

    abstract protected function getItratorToBuildIndex();
}
?>