<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:php="http://php.net/xsl"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:nt="http://www.arielworks.net/works/codeyard/himmel/xnm"
                              xmlns:nts="http://www.arielworks.net/works/codeyard/himmel/xnm/settings"
                              xmlns:nidx="http://www.arielworks.net/works/codeyard/himmel/xnm/index"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns:hml="http://www.arielworks.net/works/codeyard/himmel"
                              xmlns:s3="http://www.arielworks.net/works/codeyard/sdf/s3"
                              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/">

<xsl:include href="IndexToSdfUtil.xsl"/>

<xsl:template match="/nidx:index">
    <sdf:document xml:lang="ja">
        <sdf:meta>
            <dc:title>
            <xsl:value-of select="$nts:settings/nts:value[@name = 'SiteName']"/>
                <xsl:text>::</xsl:text>
                <xsl:value-of select="$nidx:year"/>
                <xsl:if test="not($nidx:category = 'ALL')">
                    <xsl:text>::</xsl:text>
                    <xsl:value-of select="$nts:settings/nts:value[@name = 'categoryNames']/nts:value[@name = $nidx:category]"/>
                </xsl:if>
            </dc:title>
            <xsl:call-template name="nidx:copy_latest_modified">
                <xsl:with-param name="nidx:targets_dom" select="./nidx:year[@num = $nidx:year]//nidx:note[nt:category/nt:li = $nidx:category]"/>
            </xsl:call-template>
            <xsl:call-template name="nidx:copy_oldest_created">
                <xsl:with-param name="nidx:targets_dom" select="./nidx:year[@num = $nidx:year]//nidx:note[nt:category/nt:li = $nidx:category]"/>
            </xsl:call-template>

            <link rel="up" href="../archive" title="{$nts:settings/nts:value[@name = 'siteName']}"/>

            <xsl:variable name="prev_page" select="./nidx:year[@num = $nidx:year]/preceding-sibling::nidx:year[nt:month/nt:day/nt:note/nt:category/nt:li = $nidx:category][1]"/>
            <xsl:if test="$prev_page">
                <link rel="prev" href="./{$prev_page/@num}" title="{$nts:settings/nts:value[@name = 'SiteName']}::{$prev_page/@num}"/>
            </xsl:if>
            <xsl:variable name="next_page" select="./nidx:year[@num = $nidx:year]/following-sibling::nidx:year[nt:month/nt:day/nt:note/nt:category/nt:li = $nidx:category][1]"/>
            <xsl:if test="$next_page">
                <link rel="next" href="./{$next_page/@num}" title="{$nts:settings/nts:value[@name = 'SiteName']}::{$next_page/@num}"/>
            </xsl:if>
        </sdf:meta>
        <sdf:body>
                <xsl:call-template name="listMonths">
                    <xsl:with-param name="target" select="/nidx:index/nidx:year[@num = $nidx:year]/nidx:month"/>
                    <xsl:with-param name="layer" select="2"/>
                    <xsl:with-param name="category" select="$nidx:category"/>
                </xsl:call-template>
        </sdf:body>
    </sdf:document>
</xsl:template>

</xsl:stylesheet>