<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:php="http://php.net/xsl"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:nt="http://www.arielworks.net/works/codeyard/himmel/xnm"
                              xmlns:nts="http://www.arielworks.net/works/codeyard/himmel/xnm/settings"
                              xmlns:nidx="http://www.arielworks.net/works/codeyard/himmel/xnm/index"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns:hml="http://www.arielworks.net/works/codeyard/himmel"
                              xmlns:s3="http://www.arielworks.net/works/codeyard/sdf/s3"
                              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/">

<xsl:include href="IndexToSdfUtil.xsl"/>

<xsl:template match="/nidx:index">
    <sdf:document xml:lang="ja">
        <sdf:meta>
            <dc:title>
                <xsl:value-of select="$nts:settings/nts:value[@name = 'SiteName']"/>
            </dc:title>
            <xsl:call-template name="nidx:copy_latest_modified">
                <xsl:with-param name="nidx:targets_dom" select="//nidx:note"/>
            </xsl:call-template>
            <xsl:call-template name="nidx:copy_oldest_created">
                <xsl:with-param name="nidx:targets_dom" select="///nidx:note"/>
            </xsl:call-template>
        </sdf:meta>
        <sdf:body>
            <sdf:section>
                <sdf:meta>
                    <dc:title>記事一覧</dc:title>
                </sdf:meta>
                <sdf:body>
                    <xsl:call-template name="listYears">
                        <xsl:with-param name="target" select="/nidx:index/nidx:year"/>
                        <xsl:with-param name="layer" select="2"/>
                    </xsl:call-template>
                </sdf:body>
            </sdf:section>
            <sdf:section>
                <sdf:meta>
                    <dc:title>最近の記事5件</dc:title>
                </sdf:meta>
                <sdf:body>
                    <xsl:call-template name="listNotes">
                        <xsl:with-param name="target" select="/nidx:index/descendant::nidx:note[position() &gt;= last() - 5]"/>
                        <xsl:with-param name="sortOrder" select="'descending'"/>
                        <xsl:with-param name="layer" select="2"/>
                    </xsl:call-template>
                </sdf:body>
            </sdf:section>
        </sdf:body>
    </sdf:document>
</xsl:template>


</xsl:stylesheet>