<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns="http://purl.org/rss/1.0/"
                              xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                              xmlns:content="http://purl.org/rss/1.0/modules/content/"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns:hml="http://www.arielworks.net/works/codeyard/himmel"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/"
                              exclude-result-prefixes="hml dcterms sdf xh">

<xsl:param name="uri" select="''"/>

<!-- sdf:document into basic structure -->
<xsl:template match="/sdf:document">
    <rdf:RDF>
        <channel rdf:about="$uri">
            <title>
                <xsl:value-of select="./sdf:meta/dc:title"/>
            </title>
            <description>
                <xsl:value-of select="./sdf:body/xh:p[1]"/>
            </description>
            <link>
                <xsl:value-of select="$uri"/>
            </link>
            <items>
                <rdf:Seq>
                    <xsl:call-template name="show_memos_latest">
                        <xsl:with-param name="mode" select="'inner'"/>
                    </xsl:call-template>
                </rdf:Seq>
            </items>
        </channel>

        <xsl:call-template name="show_memos_latest">
            <xsl:with-param name="mode" select="'outer'"/>
        </xsl:call-template>

    </rdf:RDF>
</xsl:template>


<xsl:template match="sdf:section" mode="inner">
    <xsl:param name="target_id" select="''"/>

    <rdf:li rdf:resource="http://ishikawa.arielworks.com{$target_id}#d{substring(./sdf:meta/dcterms:created, 9, 2)}{substring(./sdf:meta/dcterms:created, 12, 2)}{substring(./sdf:meta/dcterms:created, 15, 2)}"/>
</xsl:template>

<xsl:template match="sdf:section" mode="outer">
    <xsl:param name="target_id" select="''"/>

    <item rdf:about="http://ishikawa.arielworks.com{$target_id}#d{substring(./sdf:meta/dcterms:created, 9, 2)}{substring(./sdf:meta/dcterms:created, 12, 2)}{substring(./sdf:meta/dcterms:created, 15, 2)}">
        <title><xsl:value-of select="./sdf:meta/dc:title"/></title>
        <description><xsl:value-of select="./sdf:body/descendant::xh:p[text()][1]"/></description>
        <content:encoded>
            <xsl:text disable-output-escaping="yes">&lt;![CDATA[</xsl:text>
                <xsl:apply-templates select="./sdf:body/node()" mode="toEncoded"/>
            <xsl:text disable-output-escaping="yes">]]&gt;</xsl:text>
        </content:encoded>
        <link><xsl:value-of select="concat('http://ishikawa.arielworks.com', $target_id, '#d', substring(./sdf:meta/dcterms:created, 9, 2), substring(./sdf:meta/dcterms:created, 12, 2), substring(./sdf:meta/dcterms:created, 15, 2))"/></link>
        <dc:date><xsl:value-of select="./sdf:meta/dcterms:modified"/></dc:date>
    </item>
</xsl:template>


</xsl:stylesheet>