<?php
class Xnm_DataControllerFileSystem extends Xnm_DataController {
    protected $dataDirectory = "./Data";
    protected $noteList = NULL;
    public function __construct() {
        $this->noteList = $this->makeFileList($this->dataDirectory);
        parent::__construct();
    }

    protected function getItratorToBuildIndex() {
        return new Xnm_ItratorToBuildIndexFileSystem($this->noteList); 
    }

    protected function ifDataChanged($latestTimestamp) {
        $fileList = $this->noteList;
        $tList = array();
        clearstatcache();
        foreach ($fileList as $filePath) {
            $tList[] = filemtime($filePath . ".xnm");
            if (file_exists($filePath . ".tb")) {
                $tList[] = filemtime($filePath . ".tb");
            }
        };
        if ($latestTimestamp <= max($tList)) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    public function loadNote($timestamp) {
        $targetDom = new DomDocument();
        $internalId = $this->indexXpath->query("/nidx:index/nidx:note[@timestamp = " . $timestamp . "]/@internal_id")->item(0)->nodeValue;
        if ($targetDom->load($internalId . ".xnm")) {
            return $targetDom;
        } else{
            return new Exception("FileNotFound");
        }
    }

    public function loadTrackBack($timestamp) {
        $targetDom = new DomDocument();
        $internalId = $this->indexXpath->query("/nidx:index/nidx:note[@timestamp = " . $timestamp . "]/@internal_id")->item(0)->nodeValue;
        if ($targetDom->load($internalId . ".tb")) {
            return $targetDom;
        } else{
            return new Exception("FileNotFound");
        }
    }

    protected function writeTrackBack($internalId, $dom) {
        if (@$dom->save($internalId . ".tb")) {
            return TRUE;
        } else {
            return FALSE;
        }
    }

    protected function readTrackBack($internalId) {
        if (file_exists($internalId . ".tb")) {
            $dom = new DomDocument();
            $dom->load($internalId . ".tb");
            return $dom;
        } else {
            return FALSE;
        } 
    }

    protected function makeFileList($targetDir) {
        $fileList = array();
        if ($dir = opendir($targetDir)) {
            while (FALSE !== ($currentTgt = readdir($dir))) {
                if ($currentTgt != "." && $currentTgt != "..") {
                    if (is_dir($targetDir . "/" . $currentTgt)) {
                        $fileList = array_merge($fileList, $this->makeFileList($targetDir . "/" . $currentTgt));
                    } elseif (preg_match('/(.+)\.xnm/', $currentTgt, $tgtFragments)) {
                        $filePath = $targetDir . "/" . $tgtFragments[1];
                        $fileList[] = $filePath;
                    }
                }
            }
            closedir($dir);
        } else {
            throw new Exception("Directory open Error: " . $targetDir);
        }
        return $fileList;
    }
}

class Xnm_ItratorToBuildIndexFileSystem {
    private $fileList = array();
    private $compact = FALSE;
    private $pointer = 0;

    public function __construct($newFileList) {
        $this->fileList = $newFileList;
    }

    public function checkOut($internalId, $internalTimestamp) {
        $key = array_search($internalId, $this->fileList);
        if ($key !== FALSE) { 
            unset($this->fileList[$key]);
            $newInternalTimestamp = filemtime($internalId . ".xnm");
            if (file_exists($internalId . ".tb")) {
                $tbTimestamp = filemtime($internalId . ".tb");
                if ($tbTimestamp > $newInternalTimestamp) {
                    $newInternalTimestamp = $tbTimestamp;
                }
            }
            if ($newInternalTimestamp != $internalTimestamp) {
                $result = $this->makeNoteSet($internalId);
                return $result;
            } else {
                return FALSE;
            }
        } else { 
            return NULL;
        }
    }

    public function next() {
        if ($this->compact == FALSE) {
            sort($this->fileList);
            $this->compact = TRUE;
        }
        $internalId = $this->fileList[$this->pointer];
        $this->pointer++;
        $result = $this->makeNoteSet($internalId);
        return $result;
    }

    protected function makeNoteSet($internalId) {
        $internalTimestamp = filemtime($internalId . ".xnm");
        $noteDom = new DomDocument();
        $noteDom->load($internalId . ".xnm");
        if (file_exists($internalId . ".tb")) {
            $tbDom = new DomDocument();
            $tbDom->load($internalId . ".tb");
            $tbTimestamp = filemtime($internalId . ".tb");
            if ($tbTimestamp > $internalTimestamp) {
                $internalTimestamp = $tbTimestamp;
            }
        } else {
            $tbDom = NULL;
        }
        $result = array(
            "internalId" => $internalId,
            "internalTimestamp" => $internalTimestamp,
            "note" => $noteDom,
            "trackback" => $tbDom
        );
        return $result;
    }

    public function hasNext() {
        if ($this->pointer < count($this->fileList)) {
            return TRUE;
        } else {
            return FALSE;
        }
    }
}
?>