<?php
abstract class Xnm_DataController {
    protected $index;
    protected $indexXpath;

    public function __construct($forceClearCahce = FALSE) {
        $this->buildIndex($forceClearCahce);
        $this->indexXpath = new DomXpath($this->index);
        Hml_Util::registerBasicNs($this->indexXpath);
    }

    public function getIndex() {
        return $this->index; 
    }

    public function saveTrackBack($targetTimestamp, $uri, $blogName, $title, $excerpt) {
        if ($internalId = $this->indexXpath->query("/nidx:index/nidx:note[@timestamp = '" . $targetTimestamp . "']/@internal_id")->item(0)->nodeValue) {
            if ($tbDom = $this->readTrackBack($internalId)) {
                $rootNd = $tbDom->firstChild;
            } else {
                $tbDom = new DomDocument();
                $rootNd = $tbDom->appendChild($tbDom->createElementNS(Hml_Util::getNsUri("nt"), "referredBy"));
            }
            $tbDom->encoding = "UTF-8";
            $rootNd->appendChild($tbDom->createTextNode("\n    "));
            $tbNd = $rootNd->appendChild($tbDom->createElementNS(Hml_Util::getNsUri("nt"), "Trackback"));
            $tbNd->setAttribute("uri", $uri);
            $tbNd->appendChild($tbDom->createTextNode("\n        "));
            $bnNd = $tbNd->appendChild($tbDom->createElementNS(Hml_Util::getNsUri("nt"), "blogName"));
            $bnNd->appendChild($tbDom->createTextNode($blogName));
            $tbNd->appendChild($tbDom->createTextNode("\n        "));
            $titleNd = $tbNd->appendChild($tbDom->createElementNS(Hml_Util::getNsUri("nt"), "title"));
            $titleNd->appendChild($tbDom->createTextNode($title));
            $tbNd->appendChild($tbDom->createTextNode("\n        "));
            $exptNd = $tbNd->appendChild($tbDom->createElementNS(Hml_Util::getNsUri("nt"), "excerpt"));
            $exptNd->appendChild($tbDom->createTextNode($excerpt));
            $tbNd->appendChild($tbDom->createTextNode("\n        "));
            $dtNd = $tbNd->appendChild($tbDom->createElementNS(Hml_Util::getNsUri("nt"), "datetime"));
            $localDt = gmdate("Y-m-d\TH:i:s", gmmktime(gmdate("H"), gmdate("i") + 540, gmdate("s"), gmdate("m"), gmdate("d"), gmdate("Y"))) . "+09:00";
            $dtNd->appendChild($tbDom->createTextNode($localDt));
            $tbNd->appendChild($tbDom->createTextNode("\n     "));
            $rootNd->appendChild($tbDom->createTextNode("\n"));
            $this->writeTrackBack($internalId, $tbDom);
            return TRUE;
        } else {
            throw new Exception("Referred Note Not Exist");
        }
    }

    abstract protected function writeTrackBack($targetTimestamp, $dom);
    abstract protected function readTrackBack($targetTimestamp);

    protected function buildIndex($forceClearCahce) {
        $cachePath = "./Temp/IndexCache.xml";
        if (file_exists($cachePath) && ! $forceClearCahce) {
            $indexCheck = new DomDocument();
            if (@$indexCheck->load($cachePath)) {
                if (filemtime($cachePath) <= time() - 0 * 60) {
                    if ($this->ifDataChanged(filemtime($cachePath))) {
                        // Changed
                        $result = $this->updateIndex($indexCheck);
                        $result->save($cachePath);
                    } else {
                        // Not Changed
                        $result = $indexCheck;
                        touch($cachePath);
                    }
                } else {
                    // 1min limit
                    $result = $indexCheck;
                }
            } else {
                // Cache File Broken
                $result = $this->rebuildIndex();
                $result->save($cachePath);
            }
        } else {
            // Forced to clear or cache not existed 
            $result = $this->rebuildIndex();
            $result->save($cachePath);
        }
        $this->index = $result;
    }

    protected function updateIndex($currentIndex) {
        $indexDom = $currentIndex;
        $indexDom->encoding = "UTF-8";
        $nodeIndex = $indexDom->firstChild;
        $indexXp = new DomXpath($indexDom);
        Hml_Util::registerBasicNs($indexXp);
        $currentNoteList = $indexXp->query("/nidx:index/nidx:note");

        $it = $this->getItratorToBuildIndex();
        $noteList = array();
        for ($i = 0; $aNote = $currentNoteList->item($i); $i++) {
            $iId = $aNote->getAttribute("internal_id");
            $iTs = $aNote->getAttribute("internal_timestamp");
            $check = $it->checkOut($iId, $iTs);
            if ($check) { // modified
                $newNote = $this->makeNoteNode($check, $indexDom);
                $noteList[$newNote["timestamp"]] = $newNote["node"]; 
            } elseif ($check === FALSE) { // not modified
                $ts = $indexXp->query("./@timestamp", $aNote)->item(0)->nodeValue;
                $noteList[$ts] = $aNote;
            } else { // $check === NULL; deleted
            }
            $nodeIndex->removeChild($aNote);
        }
        while ($it->hasNext()) {
            $newNote = $this->makeNoteNode($it->next(), $indexDom);
            $noteList[$newNote["timestamp"]] = $newNote["node"]; 
        }
        ksort($noteList);
        foreach ($noteList as $aNote) {
            $nodeIndex->appendChild($aNote);
        }
        return $indexDom;
    }

    protected function rebuildIndex() {
        $indexDom = new DomDocument();
        $indexDom->encoding = "UTF-8";
        $nodeIndex = $indexDom->appendChild($indexDom->createElementNS(Hml_Util::getNsUri("nidx"), "index"));

        $it = $this->getItratorToBuildIndex();
        $noteList = array();
        while ($it->hasNext()) {
            $newNote = $this->makeNoteNode($it->next(), $indexDom);
            $noteList[$newNote["timestamp"]] = $newNote["node"]; 
        }
        ksort($noteList);
        foreach ($noteList as $aNote) {
            $nodeIndex->appendChild($aNote);
        }
        return $indexDom;
    }

    private function makeNoteNode($note, $indexDom){
        $nodeNote = $indexDom->createElementNS(Hml_Util::getNsUri("nidx"), "note");
        $nodeNote->setAttribute("internal_id", $note["internalId"]);
        $nodeNote->setAttribute("internal_timestamp", $note["internalTimestamp"]);

        $noteDom = $note["note"];
        $noteXp = new DomXpath($noteDom);
        hml_Util::registerBasicNs($noteXp);
        $dtW3c = $noteXp->query("/nt:note/dcterms:created/text()")->item(0)->nodeValue;
        $dtTimestamp = Hml_Util::parseW3cdtf($dtW3c);
        $nodeNote->setAttribute("timestamp", $dtTimestamp);
        // Hack for date() and gmdate(); we can choose only GMT(UTC) or system local timezone. 
        $dtUserLocalTimestamp = gmmktime(gmdate("H", $dtTimestamp), gmdate("i", $dtTimestamp) + 540, gmdate("s", $dtTimestamp), gmdate("m", $dtTimestamp), gmdate("d", $dtTimestamp), gmdate("Y", $dtTimestamp));
        $nodeNote->setAttribute("year", gmdate("Y", $dtUserLocalTimestamp));
        $nodeNote->setAttribute("month", gmdate("m", $dtUserLocalTimestamp));
        $nodeNote->setAttribute("day", gmdate("d", $dtUserLocalTimestamp));
        $nodeNote->setAttribute("hour", gmdate("H", $dtUserLocalTimestamp));
        $nodeNote->setAttribute("minute", gmdate("i", $dtUserLocalTimestamp));
        $nodeNote->setAttribute("second", gmdate("s", $dtUserLocalTimestamp));
        $otherMetaElements = $noteXp->query("/nt:note/*[not(namespace-uri(.) = '" . Hml_Util::getNsUri("nt") .  "' and local-name() = 'body')]");
        for($i = 0; $otherMetaElements->item($i); $i++) {
            $nodeNote->appendChild($indexDom->importNode($otherMetaElements->item($i), TRUE));
        }
        if ($tbDom = $note["trackback"]) {
            $nodeNote->appendChild($indexDom->importNode($tbDom->firstChild, TRUE));
        }
        return array("timestamp" => $dtTimestamp, "node" =>$nodeNote);
    }

    abstract protected function getItratorToBuildIndex();
}
?>