<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:php="http://php.net/xsl"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:nt="http://www.arielworks.net/works/codeyard/himmel/xnm"
                              xmlns:nts="http://www.arielworks.net/works/codeyard/himmel/xnm/settings"
                              xmlns:nidx="http://www.arielworks.net/works/codeyard/himmel/xnm/index"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns:hml="http://www.arielworks.net/works/codeyard/himmel"
                              xmlns:s3="http://www.arielworks.net/works/codeyard/sdf/s3"
                              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/">

<xsl:include href="IndexToSdfUtil.xsl"/>

<xsl:template match="/nidx:index">
    <sdf:document xml:lang="ja">
        <sdf:meta>
            <dc:title>
                <xsl:value-of select="$nts:settings/nts:value[@name = 'siteName']"/>
            </dc:title>
            <xsl:call-template name="nidx:copy_latest_modified">
                <xsl:with-param name="nidx:targets_dom" select="/nidx:index/nidx:note"/>
            </xsl:call-template>
            <xsl:call-template name="nidx:copy_oldest_created">
                <xsl:with-param name="nidx:targets_dom" select="/nidx:index/nidx:note"/>
            </xsl:call-template>
        </sdf:meta>
        <sdf:body>
            <sdf:section>
                <sdf:meta>
                    <dc:title>記事一覧</dc:title>
                </sdf:meta>
                <sdf:body>
                    <dl>
                        <xsl:for-each select="/nidx:index/nidx:note">
                            <xsl:sort select="./@timestamp" data-type="number"/>
                            <xsl:if test="not(@year = preceding-sibling::nidx:note/@year)">
                            <dt>
                                <a>
                                    <xsl:attribute name="href">
                                        <xsl:value-of select="concat('./archive/', @year)"/>
                                    </xsl:attribute>
                                    <xsl:value-of select="./@year"/>
                                </a>
                            </dt>
                            <dd>
                                <ul>
                                    <xsl:for-each select="/nidx:index/nidx:note[@year = current()/@year and not(@month = preceding-sibling::nidx:note[@year = current()/@year]/@month)]">
                                        <li>
                                            <a>
                                                <xsl:attribute name="href">
                                                    <xsl:value-of select="concat('./archive/', @year, '/', @month)"/>
                                                </xsl:attribute>
                                                <xsl:value-of select="./@year"/>
                                                <xsl:text>-</xsl:text>
                                                <xsl:value-of select="./@month"/>
                                            </a>
                                            <xsl:text>（</xsl:text>
                                            <xsl:value-of select="count(/nidx:index/nidx:note[@year = current()/@year and @month = current()/@month])"/>
                                            <xsl:text>）</xsl:text>
                                        </li>
                                    </xsl:for-each>
                                </ul>
                            </dd>
                            </xsl:if>
                        </xsl:for-each>
                    </dl>
                </sdf:body>
            </sdf:section>
            <sdf:section>
                <sdf:meta>
                    <dc:title>最近の記事5件</dc:title>
                </sdf:meta>
                <sdf:body>
                    <xsl:for-each select="./nidx:note">
                        <xsl:sort select="./@timestamp" data-type="number" order="descending"/>
                        <xsl:if test="position() &lt;= 5">
                            <xsl:variable name="nidx:current_note" select="php:function('Xnm_DataManager::document', string(./@internal_id))"/>
                            <sdf:section>
                                <sdf:meta>
                                    <xsl:copy-of select="$nidx:current_note/nt:note/*[not(local-name() = 'body' and namespace-uri() = 'http://www.arielworks.net/works/codeyard/himmel/xnm')]"/>
                                </sdf:meta>
                                <sdf:body>
                                    <xsl:copy-of select="$nidx:current_note/nt:note/nt:body/node()"/>
                                    <dl>
                                        <dt>この項目の参照用URI</dt>
                                        <dd>
                                            <a>
                                                <xsl:attribute name="href">
                                                    <xsl:value-of select="concat('./archive/', ./@year, '/', ./@month, '/' , ./@day, '/', ./@hour, ./@minute, ./@second)"/>
                                                </xsl:attribute>
                                                <xsl:value-of select="$nts:settings/nts:value[@name = 'webRoot']"/>
                                                <xsl:value-of select="concat('/archive/', ./@year, '/', ./@month, '/', ./@day, '/', ./@hour, ./@minute, ./@second)"/>
                                            </a>
                                        </dd>
                                    </dl>
                                </sdf:body>
                            </sdf:section>
                        </xsl:if>
                    </xsl:for-each>
                </sdf:body>
            </sdf:section>
        </sdf:body>
    </sdf:document>
</xsl:template>

</xsl:stylesheet>