<?php
class Hml_Util {
    private static $nsUriList = array(
        "sdf"     => "http://www.arielworks.net/works/codeyard/sdf",
        "hml"     => "http://www.arielworks.net/works/codeyard/himmel",
        "nt"      => "http://www.arielworks.net/works/codeyard/himmel/xnm",
        "nidx"    => "http://www.arielworks.net/works/codeyard/himmel/xnm/index",
        "dc"      => "http://purl.org/dc/elements/1.1/",
        "dcterms" => "http://purl.org/dc/terms/"
    );

    public static function parseW3cdtf($dateStr) {
        if (preg_match('/^(\d{4})(?:-(0[1-9]|1[0-2])(?:-(0[1-9]|[12][0-9]|3[0-1])(?:T([01][0-9]|2[0-3]):([0-5][0-9])(?::([0-5][0-9])(?:\.(\d+))?)?(Z|\+|-)(?(?<=\+|-)([01][0-9]|2[0-3]):([0-5][0-9])))?)?)?$/', $dateStr, $resultFragments)) {
            array_shift($resultFragments);
            list($year, $month, $day, $hour, $minute, $second, $fraction, $offseSign, $offsetHour, $offsetMinute) = $resultFragments;

            if (! $offseSign || $offseSign == "Z") {
                $offseSign = "+";
                $offsetHour = "0";
                $offsetMinute = "0";
            }
            $offsetTotalMinute = $offsetMinute + ($offsetHour * 60);
            $offsetTotalMinute = $offseSign + $offsetTotalMinute;

            $timestamp = (int) gmmktime($hour, $minute - ($offsetTotalMinute), $second, $month, $day, $year);

            return $timestamp;

        } else {
            throw new Himmel_DateFormatNotW3cdtfException();
        }
    }

    public static function getNsUri($prefix) {
        return self::$nsUriList[$prefix];
    }

    public static function registerBasicNs($xpath) {
        foreach (self::$nsUriList as $nsPrefix => $nsUri) {
            $xpath->registerNamespace($nsPrefix, $nsUri);
        }
    }
}
?>