<?xml version="1.0" encoding="UTF-8"?>

<!--
 +======================================================================+
 | S3 interface.xsl v0.8                                        XSLT1.0 |
 +======================================================================+
 | Distributed at http://www.arielworks.net/works/codeyard/sdf/s3       |
 +======================================================================+
-->

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:xh="http://www.w3.org/1999/xhtml"
                              xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:sdf="http://www.arielworks.net/works/codeyard/sdf"
                              xmlns:s3="http://www.arielworks.net/works/codeyard/sdf/s3"
                              xmlns:sm="http://www.arielworks.net/works/codeyard/sitemap"
                              xmlns:ishk="http://ishikawa.arielworks.com/"
                              xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
                              xmlns:dc="http://purl.org/dc/elements/1.1/"
                              xmlns:dcterms="http://purl.org/dc/terms/"
                              exclude-result-prefixes="sdf s3 sm ishk xsi dc dcterms">

<xsl:import href="./core.xsl"/>

<xsl:output omit-xml-declaration="no" version="1.0" method="xml" indent="no" encoding="UTF-8"/>

<xsl:param name="s3:web_domain" select="'ishikawa.arielworks.com'"/>
<xsl:param name="s3:web_root" select="'/'"/>
<xsl:param name="processor_root" select="'/'"/>

<!-- Hack for PHP5.0.0 -->
<xsl:param name="s3:processor_root" select="$processor_root"/>


<!-- head要素内に追加する要素 -->
<xsl:template name="s3:meta_extended">
    <link rel="stylesheet" href="/template/rr103" media="all" type="text/css" title="R.R103"/>
    <link rel="shortcut icon" href="/favicon" type="image/x-icon"/>
</xsl:template>



<!-- 表示するメタデータを指定 -->
<xsl:template name="s3:show_status_item">
    <dl>
        <xsl:if test="/sdf:document/sdf:meta/dcterms:created and not(/sdf:document/sdf:meta/dcterms:created/@s3:visibility = 'hidden')">
            <dt>
                <xsl:choose>
                    <xsl:when test="lang('ja')">制作日</xsl:when>
                    <xsl:otherwise>Created</xsl:otherwise>
                </xsl:choose>
            </dt>
            <dd>
                <xsl:value-of select="substring(/sdf:document/sdf:meta/dcterms:created, 0, 11)"/>
            </dd>
        </xsl:if>
        <xsl:if test="/sdf:document/sdf:meta/dcterms:modified and not(/sdf:document/sdf:meta/dcterms:modified/@s3:visibility = 'hidden')">
            <dt>
                <xsl:choose>
                    <xsl:when test="lang('ja')">最終更新日</xsl:when>
                    <xsl:otherwise>Last Modified</xsl:otherwise>
                </xsl:choose>
            </dt>
            <dd>
                <xsl:value-of select="substring($s3:modified, 0, 11)"/>
            </dd>
        </xsl:if>
        <dt>
            <xsl:choose>
                <xsl:when test="lang('ja')">参照用URI</xsl:when>
                <xsl:otherwise>URI</xsl:otherwise>
            </xsl:choose>
        </dt>
        <dd>
            <xsl:call-template name="s3:show_uri"/>
        </dd>
    </dl>
</xsl:template>


<!-- ヘッダ追加用テンプレート -->
<xsl:template name="s3:show_head">
</xsl:template>

<!-- フッタ追加用テンプレート -->
<xsl:template name="s3:show_foot">
    <address>
        <xsl:choose>
                <xsl:when test="/sdf:document/@xml:lang = 'ja'">連絡先、リンク、転載や複製などについては『<a href="/about">サイト案内</a>』をご覧ください。</xsl:when>
                <xsl:otherwise>Note: Most of the pages in this site are written in Japanese. <a href="/about">About this site.</a></xsl:otherwise>
        </xsl:choose>
        <a href="http://www.arielworks.net/works/codeyard/himmel">
            <img src="/himmel/logo" alt="Powered by HIMMEL"/>
        </a>
    </address>
</xsl:template>


<!-- objectはimgに -->
<xsl:template match="xh:object[starts-with(./@type, 'image') and not(./@type = 'image/svg+xml')]">
    <img src="{./@data}" alt="{.}"/>
</xsl:template>

<!-- set xml:preserve to xh:pre -->
<xsl:template match="xh:pre">
    <pre xml:space="preserve"><xsl:apply-templates select="./@*"/><xsl:apply-templates/></pre>
</xsl:template>






<!-- ishikawa用拡張 -->

<!-- PHP用ハック -->
<xsl:param name="s3:modified">
    <xsl:variable name="ishk:modified_default" select="//sdf:meta/dcterms:modified"/>
    <xsl:choose>
        <xsl:when test="//ishk:show_memos">
            <xsl:for-each select="$s3:sitemap/sm:sitemap/sm:page[./sm:id = '/memo']/sm:page/sm:page">
                <xsl:sort select="./sm:id" order="descending"/>
                    <xsl:if test="position() = 1">
                        <xsl:variable name="ishk:target_id" select="./sm:id"/>
                        <xsl:variable name="ishk:target_path">
                            <xsl:if test="not($s3:processor_root = '/')">
                                <xsl:value-of select="$s3:processor_root"/>
                            </xsl:if>
                            <xsl:value-of select="concat(./sm:id, '/index.xml')"/>
                        </xsl:variable>
                        <xsl:variable name="ishk:modifieds" select="$ishk:modified_default | document($ishk:target_path)//sdf:meta/dcterms:modified"/>
                        <xsl:for-each select="$ishk:modifieds">
                            <xsl:sort select="." order="descending"/>
                            <xsl:if test="position() = 1">
                                <xsl:value-of select="."/>
                            </xsl:if>
                        </xsl:for-each>
                    </xsl:if>
            </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
            <xsl:for-each select="$ishk:modified_default">
                <xsl:sort select="." order="descending"/>
                <xsl:if test="position() = 1">
                    <xsl:value-of select="."/>
                </xsl:if>
            </xsl:for-each>
        </xsl:otherwise>
    </xsl:choose>
</xsl:param>

<xsl:template match="ishk:show_memos">
    <xsl:choose>
        <xsl:when test="./@type = 'latest'">
            <xsl:call-template name="ishk:show_memos_latest">
                <xsl:with-param name="ishk:select" select="./@select"/>
            </xsl:call-template>
        </xsl:when>
    </xsl:choose>
</xsl:template>

<xsl:template name="ishk:show_memos_latest">
    <xsl:param name="ishk:select" select="5"/>
    <xsl:param name="ishk:recursion" select="1"/>
    <xsl:param name="ishk:remaining" select="$ishk:select"/>

    <xsl:for-each select="$s3:sitemap/sm:sitemap/sm:page[./sm:id = '/memo']/sm:page/sm:page">
        <xsl:sort select="./sm:id" order="descending"/>
            <xsl:if test="position() = $ishk:recursion">
                <xsl:variable name="ishk:target_id" select="./sm:id"/>
                <xsl:variable name="ishk:target_path">
                    <xsl:if test="not($s3:processor_root = '/')">
                        <xsl:value-of select="$s3:processor_root"/>
                    </xsl:if>
                    <xsl:value-of select="concat(./sm:id, '/index.xml')"/>
                </xsl:variable>
                <xsl:for-each select="document($ishk:target_path)/sdf:document/sdf:body/sdf:section">
                    <xsl:sort select="./sdf:meta/dc:title" order="descending"/>
                    <xsl:if test="position() &lt;= $ishk:remaining">
                        <xsl:apply-templates select="." mode="ishk:show_memos_item">
                            <xsl:with-param name="ishk:target_id" select="$ishk:target_id"/>
                        </xsl:apply-templates>
                    </xsl:if>
                    <xsl:if test="position() = $ishk:remaining + 1">
                        <div class="section">
                            <h3>これ以前の記事</h3>
                            <ul>
                                <li>
                                    <a>
                                        <xsl:attribute name="href">
                                            <xsl:value-of select="concat($ishk:target_id, '#')"/>
                                            <xsl:choose>
                                                <xsl:when test="./@xml:id">
                                                    <xsl:value-of select="./@xml:id"/>
                                                </xsl:when>
                                                <xsl:when test="starts-with($s3:id, '/memo') and ./sdf:meta/dcterms:created">
                                                    <xsl:text>d</xsl:text>
                                                    <xsl:value-of select="substring(./sdf:meta/dcterms:created, 9, 2)"/>
                                                    <xsl:value-of select="substring(./sdf:meta/dcterms:created, 12, 2)"/>
                                                    <xsl:value-of select="substring(./sdf:meta/dcterms:created, 15, 2)"/>
                                                </xsl:when>
                                            </xsl:choose>
                                        </xsl:attribute>
                                        <xsl:text>これ以前の記事</xsl:text>
                                    </a>
                                </li>
                            </ul>
                        </div>
                    </xsl:if>
                </xsl:for-each>
                <!-- 不足分を再帰 -->
                <xsl:if test="count(document($ishk:target_path)/sdf:document/sdf:body/sdf:section) &lt; $ishk:remaining">
                    <xsl:call-template name="ishk:show_memos_latest">
                        <xsl:with-param name="ishk:select" select="$ishk:select"/>
                        <xsl:with-param name="ishk:recursion" select="$ishk:recursion + 1"/>
                        <xsl:with-param name="ishk:remaining" select="$ishk:remaining - count(document($ishk:target_path)/sdf:document/sdf:body/sdf:section)"/>
                    </xsl:call-template>
                </xsl:if>
            </xsl:if>
    </xsl:for-each>
</xsl:template>

<!-- sdf:sectionからdivによる入れ子構造に変換 -->
<xsl:template match="sdf:section" mode="ishk:show_memos_item">
    <xsl:param name="ishk:target_id" select="'/'"/>

    <div class="{normalize-space(concat('section ', ./@xh:class))}">
        <xsl:call-template name="s3:add_xhtml_attributes"/>
        <xsl:apply-templates select="./sdf:meta" mode="ishk:show_memos_item">
            <xsl:with-param name="ishk:target_id" select="$ishk:target_id"/>
        </xsl:apply-templates>
        <xsl:apply-templates select="./sdf:body" mode="ishk:show_memos_item">
            <xsl:with-param name="ishk:target_id" select="$ishk:target_id"/>
        </xsl:apply-templates>
    </div>
</xsl:template>

<xsl:template match="sdf:meta" mode="ishk:show_memos_item">
    <xsl:param name="ishk:target_id" select="'/'"/>

    <xsl:if test="../sdf:meta/dc:title">
        <xsl:element name="{concat('h', count(./ancestor::node()) div 2 + 1)}">
            <xsl:apply-templates select="../sdf:meta/dc:title/node()"/>
            <xsl:if test="starts-with($s3:id, '/memo') and ../sdf:meta/dcterms:created">
                <span class="entry_time">
                    <xsl:text>（</xsl:text>
                    <xsl:value-of select="substring(../sdf:meta/dcterms:created, 12, 5)"/>
                    <abbr title="協定世界時（UTC）。9時間足した時刻が日本時間になります。">Z</abbr>
                    <xsl:text>）</xsl:text>
                </span>
            </xsl:if>
        </xsl:element>
    </xsl:if>
    <xsl:if test="../@xml:id or (starts-with($s3:id, '/memo') and ./dcterms:created)">
        <dl class="permalink">
            <dt>参照用URI</dt>
            <dd>
                <xsl:value-of select="concat('http://ishikawa.arielworks.com', $ishk:target_id, '#')"/>
                <xsl:choose>
                    <xsl:when test="../@xml:id">
                        <xsl:value-of select="../@xml:id"/>
                    </xsl:when>
                    <xsl:when test="starts-with($s3:id, '/memo') and ./dcterms:created">
                        <xsl:text>d</xsl:text>
                        <xsl:value-of select="substring(./dcterms:created, 9, 2)"/>
                        <xsl:value-of select="substring(./dcterms:created, 12, 2)"/>
                        <xsl:value-of select="substring(./dcterms:created, 15, 2)"/>
                    </xsl:when>
                </xsl:choose>
            </dd>
        </dl>
    </xsl:if>
</xsl:template>

<xsl:template match="sdf:body" mode="ishk:show_memos_item">
    <xsl:apply-templates mode="ishk:show_memos_item">
        <xsl:sort select="./sdf:meta/dcterms:created" order="descending"/>
        <xsl:with-param name="ishk:target_id" select="$ishk:target_id"/>
    </xsl:apply-templates>
</xsl:template>

<xsl:template match="ishk:show_log">
    <ul>
        <xsl:for-each select="$s3:sitemap/sm:sitemap/sm:page[./sm:id = '/memo']/sm:page">
            <li>
                <xsl:value-of select="substring(./sm:id, 7, 4)"/>
                <xsl:text>年</xsl:text>
                <ul>
                    <xsl:for-each select="./sm:page">
                        <li>
                            <a href="{./sm:id}">
                                <xsl:value-of select="substring(./sm:id, 12, 2)"/>
                                <xsl:text>月</xsl:text>
                            </a>
                        </li>
                    </xsl:for-each>
                </ul>
            </li>
        </xsl:for-each>
    </ul>
</xsl:template>




<!-- blockquote要素は引用元を表示 -->
<xsl:template match="xh:blockquote[not(ancestor::xh:blockquote)]">
    <blockquote>
        <xsl:apply-templates select="./@*"/>
        <xsl:apply-templates/>
    </blockquote>
    <xsl:if test="./@title">
        <p class="citation-origin">
            <xsl:text>『</xsl:text>
            <cite>
                <xsl:choose>
                    <xsl:when test="./@cite">
                        <a href="{./@cite}">
                            <xsl:value-of select="./@title"/>
                        </a>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="./@title"/>
                    </xsl:otherwise>
                </xsl:choose>
            </cite>
            <xsl:text>』より引用。</xsl:text>
        </p>
    </xsl:if>
</xsl:template>

<!-- 要素は基本的にコピー -->
<xsl:template match="*" mode="ishk:show_memos_item">
        <xsl:apply-templates select="self::node()"/>
</xsl:template>

<!-- ソースXMLファイルのコメントはコピー -->
<xsl:template match="comment()" mode="ishk:show_memos_item">
    <xsl:copy-of select="."/>
</xsl:template>

</xsl:stylesheet>