<?php
class OutputManager {
    private $acceptRuleList = array(
        "application/xhtml+xml" => "OutputDefinitionXhtml11",
        "text/html"             => "OutputDefinitionXhtml10",
        "*/*"                   => "OutputDefinitionXhtml10"
    );
    private $outputDefinition = NULL;

    public function __construct() {
        $acceptListWithQuality = explode(",", $_SERVER["HTTP_ACCEPT"]);
        $acceptList = array();
        foreach ($acceptListWithQuality as $anAccept) {
            $anAcceptFragments = explode(";", $anAccept);
            if ($anAcceptFragments[1] == "") {
                $quality = "1.0";
            } else {
                $quality = substr($anAcceptFragments[1], 2);
            }
            if (! array_key_exists($quality, $acceptList)) {
                $acceptList[$quality] = array($anAcceptFragments[0]);
            } else {
                $acceptList[$quality][] = $anAcceptFragments[0];
            }
        }
        //arsort($acceptList);
        $this->outputDefinition = new OutputDefinitionXhtml10();
        foreach ($acceptList as $aQuality) {
            foreach ($this->acceptRuleList as $mimeName => $className) {
                if (in_array($mimeName, $aQuality)) {
                    $this->outputDefinition = new $className();
                    break 2;
                }
            }
        }
    } 

    public function output($dataContainer, $statusCode = 200) {
        $hou = new HttpOutputUnit();
        $hou->setStatusCode($statusCode);
        if ($modified = $this->parseW3cdtf($dataContainer->getModifiedDatetime())) {
            $hou->setHeader("Last-Modified", gmdate("D, d M Y H:i:s", $modified) . " GMT");
        }
        $this->outputDefinition->setSource($dataContainer);
        $this->outputDefinition->outputToHttp($hou);
        $hod = new HttpOutputDirector();
        $hod->output($hou);
    }

    protected function parseW3cdtf($datetimeStr) {
        if (preg_match('/^(\d{4})(?:-(0[1-9]|1[0-2])(?:-(0[1-9]|[12][0-9]|3[0-1])(?:T([0-5][0-9]):([0-5][0-9])(?::([0-5][0-9])(?:\.(\d+))?)?(Z|(?:\+|-)[0-5][0-9]:[0-5][0-9]))?)?)?$/', $datetimeStr, $resultFragments)) {
            $year = $resultFragments[1];
            $month = $resultFragments[2];
            $day = $resultFragments[3];
            $hour = $resultFragments[4];
            $minute = $resultFragments[5];
            $second = $resultFragments[6];
            $fraction = $resultFragments[7];
            $timezone = $resultFragments[8];

            $offset_sign = "+";
            $offset_hour = "0";
            $offset_minute = "0";
            if($timezone && $timezone != "Z") {
                $offset_sign = substr($timezone, 0, 1);
                $offset_hour = substr($timezone, 1, 2);
                $offset_minute = substr($timezone, 4, 2);
            }

            $timestamp = gmmktime($hour - ($offset_sign . $offset_hour), $minute - ($offset_sign . $offset_minute), $second, $month, $day, $year);

            return $timestamp;

        // Not W3C-DTF
        } else {
            return FALSE;
        }
    }
}
?>