<?php
/**
 * @author  Arielworks
 * @access public
 * @version 1.2.0
 * @license Public Domain
 */
class OutputDefinitionXhtml11 extends OutputDefinition {
    protected $encoding              = "UTF-8";
    protected $xmlBeautifier         = TRUE;
    protected $xhtmlHacks            = TRUE;
    protected $ie6XmlDeclarationHack = TRUE;
    protected $validXslPath          = "valid11.xsl";

    public function outputToHttp($outputUnit) {
        $msgBody = $this->makeMassageBody();
        $outputUnit->setMassageBody($msgBody);
        $outputUnit->setHeader("Content-Type", "application/xhtml+xml; " . $this->encoding);
        $outputUnit->setHeader("Content-Style-Type", "text/css");
        $outputUnit->setHeader("Content-Script-Type", "text/javascript");
    }

    protected function makeMassageBody() {
        $resultDom = $this->transformSdf($this->sourceContainer->getData());
        if ($this->xmlBeautifier) {
            $resultDom = $this->applyBeautifier($resultDom);
        }
        $resultStr = $resultDom->saveXML();
        if ($this->xhtmlHacks) {
            $resultStr = $this->hackXhtml($resultStr);
        }
        if ($this->ie6XmlDeclarationHack) {
            $resultStr = $this->hackIe6($resultStr);
        }
        return $resultStr;
    }

    protected function transformSdf($source) {
        $nsS3 = "http://www.arielworks.net/works/codeyard/sdf/s3";

        $paramInterface = array(
            array($nsS3, "processor_root", "")
        );
        $result = $this->xsltDomAndFile($source, "/s3/interface.xsl", $paramInterface);
        return $result;
    }

    protected function applyBeautifier($source) {
        // indent
        $source->preserveWhiteSpace = FALSE;
        $indented = $this->xsltDomAndFile($source, "/indent.xsl");
        // clean up namespace
        $result = $this->xsltDomAndFile($indented, $this->validXslPath);
        return $result;
    }

    protected function xsltDomAndFile($xmlDom, $xslFilePath, $parameters = array()) {
        $domXsl = new Domdocument();
        $domXsl->load(dirname(__FILE__) . "/" . $xslFilePath);

        $xsltp = new XsltProcessor();
        $xsltp->importStyleSheet($domXsl);
        foreach ($parameters as $aParam) {
            $xsltp->setParameter($aParam[0], $aParam[1], $aParam[2]);
        }
        return $xsltp->transformToDoc($xmlDom);
    }

    protected function hackXhtml($source) {
        $result = preg_replace("/<textarea([^>]*?)\/>/is", "<textarea$1></textarea>", $source);
        $result = preg_replace("/<script([^>]*?)\/>/is", "<script$1></script>", $result);
        $result = preg_replace("/(<[^>]*?[^ ])\/>/is", "$1 />", $result);
        return $result;
    }

    protected function hackIe6($source) {
        if (preg_match("/MSIE 6.0/", $_SERVER["HTTP_USER_AGENT"])) {
            $result = preg_replace("/<\?xml.*?\?>(\n)?/", "", $source);
        } else {
            $result = $source;
        }
        return $result;
    }
}
?>