<?php
/**
 * The container to store DOM Object and provide easy access method
 * 
 * @author Arielworks
 * @access public
 * @version 1.0.0
 * @license Public Domain
 */
class DataContainer {
    /**
     * @access private
     */
    private $dataDom = NULL;
    private $dataXpath = NULL;

    /**
     * @return void
     * @access public
     */
    public function __construct() {
    }

    /**
     * @return void
     * @param DomDoument $newDataDom DomDocument to store
     * @access public
     */
    public function setData($newDataDom) {
        $this->dataDom = $newDataDom;
        $this->dataXpath = new DomXpath($this->dataDom);
        $this->dataXpath->registerNameSpace("sdf", "http://www.arielworks.net/works/codeyard/sdf");
        $this->dataXpath->registerNameSpace("dc", "http://purl.org/dc/elements/1.1/");
        $this->dataXpath->registerNameSpace("dcterms", "http://purl.org/dc/terms/");
    }

    /**
     * @return DomDocument
     * @access public
     */
    public function getData() {
        return $this->dataDom;
    }

    public function getTitle() {
    }

    public function getCreateDatetime() {
    }

    public function getModifiedDatetime() {
        $nodeList = $this->dataXpath->query("/sdf:document/sdf:meta/dcterms:modified/node()");
        return $this->dataDom->saveXML($nodeList->item(0));
    }

    public function getCreator() {
    }
}
?>