<?php
function __autoload($className) {
   include_once($className . ".php");
}
/**
 * Main class of HIMMEL
 * 
 * @author Arielworks
 * @access public
 * @version 0.8.1
 * @license Public Domain
 */
class Himmel {
    /**
     * @access private
     */
    private $outputManager = NULL;

    /**
     * Constractor
     * 
     * @return void
     * @access public
     */
    public function __construct() {
        $this->outputManager = new OutputManager();
    }

    /**
     * @return DataContainer
     * @access public
     */
    public function getDataContainer() {
        return new DataContainer();
    }

    /**
     * @return void
     * @param DataContainer $dataContainer DataContainer to excute
     * @param int $statusCode default code is 200
     * @access public
     */
    public function excute($dataContainer, $statusCode = NULL) {
        $this->outputManager->output($dataContainer);
    }
}
?>