﻿<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns="http://www.w3.org/1999/xhtml"
                              xmlns:xh="http://www.w3.org/1999/xhtml">

<xsl:output omit-xml-declaration="no" version="1.0" method="xml" indent="no" encoding="UTF-8"/>

<xsl:template match="xh:ruby | xh:rb | xh:rt | xh:rbc | xh:rtc |xh:rt | xh:rp">
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="*">
    <xsl:element name="{local-name()}" namespace="{namespace-uri(.)}">
        <xsl:attribute name="xmlns">test</xsl:attribute>
        <xsl:apply-templates select="@*"/>
        <xsl:apply-templates/>
    </xsl:element>
</xsl:template>

<xsl:template match="@xml:lang">
    <xsl:copy-of select="."/>
    <xsl:attribute name="lang">
        <xsl:value-of select="."/>
    </xsl:attribute>
</xsl:template>

<xsl:template match="xh:a/@id | xh:map/@id">
    <xsl:copy-of select="."/>
    <xsl:attribute name="name">
        <xsl:value-of select="."/>
    </xsl:attribute>
</xsl:template>

<xsl:template match="@*">
    <xsl:copy-of select="."/>
</xsl:template>

<xsl:template match="comment()">
    <xsl:copy-of select="."/>
</xsl:template>


</xsl:stylesheet>